/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soyparse;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.AbstractPrimitiveNode;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.soyparse.HtmlRewriter;
import com.google.template.soy.soyparse.ParseErrors;
import com.google.template.soy.soyparse.ParseException;
import com.google.template.soy.soyparse.RawTextBuilder;
import com.google.template.soy.soyparse.SimpleCharStream;
import com.google.template.soy.soyparse.SoyFileParserConstants;
import com.google.template.soy.soyparse.SoyFileParserTokenManager;
import com.google.template.soy.soyparse.SoyParseUtils;
import com.google.template.soy.soyparse.Token;
import com.google.template.soy.soyparse.TokenMgrError;
import com.google.template.soy.soyparse.Tokens;
import com.google.template.soy.soytree.AbstractCommandNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AbstractSoyNode;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CallParamValueNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.DebuggerNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.LogNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.NamespaceDeclaration;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateBasicNodeBuilder;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateElementNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateNodeBuilder;
import com.google.template.soy.soytree.VeLogNode;
import com.google.template.soy.soytree.WhitespaceMode;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.ast.GenericTypeNode;
import com.google.template.soy.types.ast.NamedTypeNode;
import com.google.template.soy.types.ast.RecordTypeNode;
import com.google.template.soy.types.ast.TypeNode;
import com.google.template.soy.types.ast.UnionTypeNode;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;

public class SoyFileParser
implements SoyFileParserConstants {
    private static final SoyErrorKind INVALID_ALIAS_NAME = SoyErrorKind.of("An alias must be a single identifier. Found ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CALLEE_NAME = SoyErrorKind.of("Invalid callee name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_DELTEMPLATE_NAME = SoyErrorKind.of("Deltemplate ''{0}'' must have a fully qualified name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TEMPLATE_NAME = SoyErrorKind.of("Template name ''{0}'' must be relative to the file namespace, i.e. a dot followed by an identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK = SoyErrorKind.of("Tags ''plural'' and ''select'' are not allowed inside ''plural'' blocks.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_OUT_OF_BOUNDS = SoyErrorKind.of("Plural case ''{0}'' must be a nonnegative integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_CASE_MALFORMED = SoyErrorKind.of("Invalid number in ''plural case'' command text.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLURAL_OFFSET_OUT_OF_BOUNDS = SoyErrorKind.of("The ''offset'' for plural must be a positive integer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_AFTER = SoyErrorKind.of("Unexpected content after ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CONTENT_BEFORE = SoyErrorKind.of("Unexpected content before ''{0}'', expected only comments or whitespace.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CSS_XID_MIGRATION = SoyErrorKind.of("The ''{0}'' command is {1}, please switch to using the {0} function.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INJECT_DEFAULT_PARAM = SoyErrorKind.of("Default parameters are not supported on injected parameters.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OPTIONAL_DEFAULT_PARAM = SoyErrorKind.of("Default parameters are not supported on optional parameters. Did you mean '''{@param ...}'''?", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_IN_TEMPLATE = SoyErrorKind.of("@state declarations are only allowed in elements.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STATE_REQUIRES_VALUE = SoyErrorKind.of("@state declarations require an initial value.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_NAME = SoyErrorKind.of("Duplicate {0} ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_KEY_NAME = SoyErrorKind.of("Invalid {0} ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INTEGER_OUT_OF_RANGE = SoyErrorKind.of("Soy integers are constrained to the range of JavaScript integers: https://www.ecma-international.org/ecma-262/5.1/#sec-8.5", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind INVALID_PARAM_NAME = SoyErrorKind.of("Invalid param name ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_PIPE = SoyErrorKind.of("Unexpected ''|''. Print directives should not have whitespace after ''|''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind OLD_RECORD_LITERAL_SYNTAX = SoyErrorKind.of("Parse error at '':''. If this is a record literal, use the new syntax: ''record(key1: \"value1\", key2: 2)''. If this is a legacy_object_map literal, there is no syntax for that, consider using ''map()'' instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FOREACH_IS_DISABLED = SoyErrorKind.of("foreach loops are no longer supported, please switch to the for loop.", SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind PARSER_ERROR = SoyErrorKind.of("parse error at ''{0}'': expected {1}", SoyErrorKind.StyleAllowance.NO_CAPS, SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final ImmutableSet<String> EXPR_ATTR_NAMES = ImmutableSet.of((Object)"data", (Object)"genders", (Object)"key", (Object)"logonly", (Object)"variant");
    private IdGenerator nodeIdGen;
    private String filePath;
    private WhitespaceMode whitespaceMode = WhitespaceMode.JOIN;
    private ErrorReporter errorReporter;
    private TemplateNode.SoyFileHeaderInfo headerInfo;
    public SoyFileParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[94];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public static ExprNode parseExprOrDie(String exprText) {
        return SoyFileParser.parseExpression(exprText, ErrorReporter.exploding());
    }

    @Nullable
    public static ExprNode parseExpression(String exprText, ErrorReporter errorReporter) {
        String filePath = "expression parser";
        SoyFileParser parser = new SoyFileParser(exprText, filePath, errorReporter);
        try {
            return parser.ExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    @Nullable
    public static TypeNode parseType(String typeText, String filePath, ErrorReporter errorReporter) {
        SoyFileParser parser = new SoyFileParser(typeText, filePath, errorReporter);
        try {
            return parser.TypeExprInput();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(errorReporter, filePath, e, parser.token_source.curLexState);
            return null;
        }
    }

    public SoyFileParser(IdGenerator nodeIdGen, Reader input, String filePath, ErrorReporter errorReporter) {
        this(input);
        this.nodeIdGen = (IdGenerator)Preconditions.checkNotNull((Object)nodeIdGen);
        this.filePath = (String)Preconditions.checkNotNull((Object)filePath);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
    }

    private SoyFileParser(String input, String filePath, ErrorReporter errorReporter) {
        this(new SoyFileParserTokenManager(new SimpleCharStream(new StringReader(input), 1, 1), 2));
        this.filePath = filePath;
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
        this.headerInfo = TemplateNode.SoyFileHeaderInfo.EMPTY;
    }

    @Nullable
    public SoyFileNode parseSoyFile() {
        Preconditions.checkNotNull((Object)this.nodeIdGen);
        ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
        SoyFileNode soyFileNode = null;
        try {
            soyFileNode = this.SoyFile();
        }
        catch (ParseException e) {
            ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, e, this.token_source.curLexState);
        }
        catch (TokenMgrError e) {
            ParseErrors.reportTokenMgrError(this.errorReporter, this.filePath, e);
        }
        if (this.errorReporter.errorsSince(checkpoint)) {
            return null;
        }
        HtmlRewriter.rewrite(soyFileNode, this.nodeIdGen, this.errorReporter);
        return soyFileNode;
    }

    private void reportFileErrorAndSkipTo(ParseException error, int skipTo) {
        Token t;
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        do {
            t = this.getNextToken();
        } while (t.kind != skipTo && t.kind != 0);
    }

    private Token reportTemplateBodyErrorAndSkipTo(ParseException error, int ... kinds) {
        ParseErrors.reportSoyFileParseException(this.errorReporter, this.filePath, error, this.token_source.curLexState);
        return this.skipToTemplateToken(kinds);
    }

    private Token skipToTemplateToken(int ... kinds) {
        Token t;
        ImmutableSet skipTo = ImmutableSet.copyOf((Collection)Ints.asList((int[])kinds));
        do {
            t = this.getNextToken();
            if (!skipTo.contains((Object)t.kind)) continue;
            return t;
        } while (t.kind != 26 && t.kind != 27 && t.kind != 0);
        throw new AbortParsingError();
    }

    private SourceLocation createSrcLoc(Token tok1, Token ... rest) {
        return Tokens.createSrcLoc(this.filePath, tok1, rest);
    }

    private VarRefNode errorExpr(Token tok1, Token ... rest) {
        return VarRefNode.error(this.createSrcLoc(tok1, rest));
    }

    private final SoyFileNode SoyFile() throws ParseException {
        Identifier delpackageName = null;
        Object aliases = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: {
                delpackageName = this.DelPackage();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
            }
        }
        NamespaceDeclaration namespace = this.Namespace();
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 10: {
                    break;
                }
                default: {
                    this.jj_la1[1] = this.jj_gen;
                    break block9;
                }
            }
            AliasDeclaration alias = this.Alias();
            if (aliases.isEmpty()) {
                aliases = new ArrayList();
            }
            if (alias == null) continue;
            aliases.add(alias);
        }
        this.headerInfo = new TemplateNode.SoyFileHeaderInfo(this.errorReporter, delpackageName, namespace, (Collection<AliasDeclaration>)aliases);
        SoyFileNode sfn = new SoyFileNode(this.nodeIdGen.genId(), this.filePath, namespace, this.headerInfo);
        block10: while (true) {
            TemplateNode template;
            if ((template = this.Template(this.headerInfo)) != null) {
                sfn.addChild(template);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 23: 
                case 24: 
                case 25: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[2] = this.jj_gen;
        this.jj_consume_token(0);
        return sfn;
    }

    private final AliasDeclaration Alias() throws ParseException {
        Identifier alias = null;
        Token open = this.jj_consume_token(10);
        Identifier namespace = this.Identifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 136: {
                this.Keyword("as");
                alias = this.Identifier();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(83);
        SourceLocation srcLoc = this.createSrcLoc(open, close);
        if (alias != null && !BaseUtils.isIdentifier(alias.identifier())) {
            this.errorReporter.report(srcLoc, INVALID_ALIAS_NAME, alias.identifier());
            return null;
        }
        if (alias == null) {
            alias = namespace.extractPartAfterLastDot();
        }
        return AliasDeclaration.create(namespace, alias);
    }

    private final NamespaceDeclaration Namespace() throws ParseException {
        Token open = this.jj_consume_token(11);
        Identifier name = this.DottedIdent();
        List<CommandTagAttribute> attributes = this.Attributes();
        Token close = this.jj_consume_token(83);
        return new NamespaceDeclaration(name, attributes, this.errorReporter);
    }

    private final List<CommandTagAttribute> Attributes() throws ParseException {
        Object attributes = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 85: 
                case 136: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            CommandTagAttribute attr = this.Attribute();
            if (attributes.isEmpty()) {
                attributes = new ArrayList();
            }
            attributes.add(attr);
        }
        CommandTagAttribute.removeDuplicatesAndReportErrors((Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        return attributes;
    }

    private final CommandTagAttribute Attribute() throws ParseException {
        Token nameToken;
        ImmutableList exprList = ImmutableList.of();
        Preconditions.checkState((this.token_source.curLexState == 1 || this.token_source.curLexState == 2 ? 1 : 0) != 0);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 85: {
                nameToken = this.jj_consume_token(85);
                break;
            }
            case 136: {
                nameToken = this.jj_consume_token(136);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Identifier name = Identifier.create(nameToken.image, this.createSrcLoc(nameToken, new Token[0]));
        this.token_source.SwitchTo(1);
        this.jj_consume_token(88);
        if (EXPR_ATTR_NAMES.contains((Object)name.identifier())) {
            Token qToken;
            QuoteStyle quoteStyle;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    quoteStyle = QuoteStyle.DOUBLE;
                    this.token_source.SwitchTo(3);
                    try {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 121: 
                            case 125: 
                            case 128: 
                            case 132: 
                            case 136: 
                            case 137: {
                                exprList = this.ExprList();
                                break;
                            }
                            default: {
                                this.jj_la1[6] = this.jj_gen;
                            }
                        }
                        qToken = this.jj_consume_token(15);
                        this.token_source.SwitchTo(1);
                    }
                    catch (ParseException e) {
                        this.token_source.SwitchTo(1);
                        exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                        qToken = this.reportTemplateBodyErrorAndSkipTo(e, 101);
                    }
                    break;
                }
                case 14: {
                    this.jj_consume_token(14);
                    quoteStyle = QuoteStyle.SINGLE;
                    this.token_source.SwitchTo(4);
                    try {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 94: 
                            case 95: 
                            case 96: 
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 121: 
                            case 125: 
                            case 128: 
                            case 132: 
                            case 136: 
                            case 137: {
                                exprList = this.ExprList();
                                break;
                            }
                            default: {
                                this.jj_la1[7] = this.jj_gen;
                            }
                        }
                        qToken = this.jj_consume_token(16);
                        this.token_source.SwitchTo(1);
                    }
                    catch (ParseException e) {
                        this.token_source.SwitchTo(1);
                        exprList = ImmutableList.of((Object)this.errorExpr(e.currentToken, new Token[0]));
                        qToken = this.reportTemplateBodyErrorAndSkipTo(e, 100);
                    }
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            if (exprList.isEmpty()) {
                this.errorReporter.report(this.createSrcLoc(qToken, new Token[0]), PARSER_ERROR, qToken.image, "an expression");
                exprList = ImmutableList.of((Object)this.errorExpr(qToken, new Token[0]));
            }
            return new CommandTagAttribute(Identifier.create(name.identifier(), name.location()), quoteStyle, (ImmutableList<ExprNode>)exprList);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 13: 
            case 14: {
                QuoteStyle quoteStyle;
                Token value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        this.token_source.pushState(8);
                        value = this.jj_consume_token(17);
                        quoteStyle = QuoteStyle.DOUBLE;
                        break;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        this.token_source.pushState(9);
                        value = this.jj_consume_token(18);
                        quoteStyle = QuoteStyle.SINGLE;
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return new CommandTagAttribute(name, quoteStyle, value.image, this.createSrcLoc(value, new Token[0]));
            }
        }
        this.jj_la1[10] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final Identifier DelPackage() throws ParseException {
        this.jj_consume_token(12);
        Identifier name = this.DottedIdent();
        this.jj_consume_token(83);
        return name;
    }

    private final TemplateNode Template(TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo) throws ParseException {
        Token close = null;
        TemplateNode templateNode = null;
        RawTextNode initialWhitespace = null;
        List<SoyNode.StandaloneNode> templateBodyNodes = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 24: {
                Token open = this.jj_consume_token(24);
                TemplateBasicNodeBuilder builder = new TemplateBasicNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, false);
                    this.whitespaceMode = builder.getWhitespaceMode();
                    initialWhitespace = this.TemplateHeader(builder, false);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(26);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 26);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            case 23: {
                Token open = this.jj_consume_token(23);
                TemplateDelegateNodeBuilder builder = new TemplateDelegateNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, true);
                    this.whitespaceMode = builder.getWhitespaceMode();
                    initialWhitespace = this.TemplateHeader(builder, false);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(27);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 27);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            case 25: {
                Token open = this.jj_consume_token(25);
                TemplateElementNodeBuilder builder = new TemplateElementNodeBuilder(soyFileHeaderInfo, this.errorReporter);
                try {
                    this.TemplateOpenTagHelper(builder, open, false);
                    initialWhitespace = this.TemplateHeader(builder, true);
                    templateBodyNodes = this.TemplateBlock();
                    close = this.jj_consume_token(28);
                    builder.setSourceLocation(this.createSrcLoc(open, close));
                    templateNode = builder.build();
                    break;
                }
                catch (ParseException e) {
                    this.reportFileErrorAndSkipTo(e, 28);
                    return null;
                }
                catch (AbortParsingError e) {
                    return null;
                }
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (initialWhitespace != null) {
            templateNode.addChild(initialWhitespace);
        }
        if (templateBodyNodes != null) {
            templateNode.addChildren(templateBodyNodes);
        }
        return templateNode;
    }

    private final void TemplateOpenTagHelper(TemplateNodeBuilder<?> builder, Token open, boolean isDeltemplate) throws ParseException {
        builder.setId(this.nodeIdGen.genId());
        Identifier templateName = this.TemplateNameInDef(isDeltemplate);
        List<CommandTagAttribute> attributes = this.Attributes();
        builder.setCommandValues(templateName, attributes);
        Token soyDoc = open.specialToken;
        if (soyDoc != null && soyDoc.kind == 9) {
            builder.setSoyDoc(soyDoc.image, this.createSrcLoc(soyDoc, new Token[0]));
        }
        Token close = this.jj_consume_token(83);
        builder.setOpenTagLocation(this.createSrcLoc(open, close));
    }

    private final Identifier TemplateNameInDef(boolean isDeltemplate) throws ParseException {
        Identifier templateName = this.TemplateName();
        if (!isDeltemplate && templateName.type() != Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_TEMPLATE_NAME, templateName.identifier());
        } else if (isDeltemplate && templateName.type() == Identifier.Type.DOT_IDENT) {
            this.errorReporter.report(templateName.location(), INVALID_DELTEMPLATE_NAME, templateName.identifier());
        }
        return templateName;
    }

    private final Identifier TemplateName() throws ParseException {
        Identifier ident;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 89: {
                Token dot = this.jj_consume_token(89);
                Token name = this.jj_consume_token(85);
                ident = Identifier.create("." + name.image, this.createSrcLoc(dot, name));
                break;
            }
            case 85: {
                ident = this.DottedIdent();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return ident;
    }

    private final Identifier DottedIdent() throws ParseException {
        StringBuilder sb = null;
        Token next = null;
        Token name = this.jj_consume_token(85);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 89: {
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    break block3;
                }
            }
            Token dot = this.jj_consume_token(89);
            next = this.jj_consume_token(85);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(name.image);
            }
            sb.append('.').append(next.image);
        }
        return sb == null ? Identifier.create(name.image, this.createSrcLoc(name, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(name, next));
    }

    private final void SkipWhitespace() throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(92);
        }
    }

    private final RawTextNode RawText() throws ParseException {
        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
        block22: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: 
                case 93: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 93: {
                            token = this.jj_consume_token(93);
                            break;
                        }
                        case 92: {
                            token = this.jj_consume_token(92);
                            break;
                        }
                        default: {
                            this.jj_la1[15] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addBasic(token);
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    Token token = this.jj_consume_token(91);
                    builder.addLiteral(token);
                    break;
                }
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: {
                    Token token;
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 35: {
                            token = this.jj_consume_token(35);
                            break;
                        }
                        case 36: {
                            token = this.jj_consume_token(36);
                            break;
                        }
                        case 38: {
                            token = this.jj_consume_token(38);
                            break;
                        }
                        case 37: {
                            token = this.jj_consume_token(37);
                            break;
                        }
                        case 39: {
                            token = this.jj_consume_token(39);
                            break;
                        }
                        case 40: {
                            token = this.jj_consume_token(40);
                            break;
                        }
                        case 41: {
                            token = this.jj_consume_token(41);
                            break;
                        }
                        case 42: {
                            token = this.jj_consume_token(42);
                            break;
                        }
                        default: {
                            this.jj_la1[16] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    builder.addTextualCommand(token);
                    break;
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 92: 
                case 93: {
                    continue block22;
                }
            }
            break;
        }
        this.jj_la1[18] = this.jj_gen;
        return builder.build();
    }

    private final RawTextNode TemplateHeader(TemplateNodeBuilder<?> templateBuilder, boolean allowState) throws ParseException {
        RawTextNode whitespace;
        Object params;
        block21: {
            params = ImmutableList.of();
            whitespace = null;
            String soyDoc = null;
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 92: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block21;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 92: {
                        RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
                        block16: while (true) {
                            Token tok = this.jj_consume_token(92);
                            if (tok.specialToken != null) {
                                soyDoc = tok.specialToken.image;
                            }
                            builder.addBasic(tok);
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 92: {
                                    continue block16;
                                }
                            }
                            break;
                        }
                        this.jj_la1[20] = this.jj_gen;
                        whitespace = builder.build();
                        continue block15;
                    }
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        TemplateHeaderVarDefn param = this.ParamDecl(soyDoc);
                        switch (param.kind()) {
                            case PARAM: {
                                whitespace = null;
                                soyDoc = null;
                                if (params.isEmpty()) {
                                    params = new ArrayList();
                                }
                                params.add((TemplateParam)param);
                                break;
                            }
                            case STATE: {
                                if (params.isEmpty()) {
                                    params = new ArrayList();
                                }
                                if (allowState) {
                                    params.add(param);
                                    break;
                                }
                                this.errorReporter.report(param.nameLocation(), STATE_IN_TEMPLATE, new Object[0]);
                                break;
                            }
                            case LOCAL_VAR: 
                            case UNDECLARED: {
                                throw new AssertionError((Object)("unexpected var kind: " + (Object)((Object)param.kind())));
                            }
                        }
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[21] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        templateBuilder.addVarDefns((Iterable<TemplateHeaderVarDefn>)params);
        return whitespace;
    }

    private final TemplateHeaderVarDefn ParamDecl(@Nullable String desc) throws ParseException {
        Token tagBegin;
        TypeNode paramTypeNode = null;
        ExprNode value = null;
        boolean optional = false;
        boolean inject = false;
        boolean stateVar = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 29: {
                tagBegin = this.jj_consume_token(29);
                break;
            }
            case 30: {
                tagBegin = this.jj_consume_token(30);
                optional = true;
                break;
            }
            case 31: {
                tagBegin = this.jj_consume_token(31);
                inject = true;
                break;
            }
            case 32: {
                tagBegin = this.jj_consume_token(32);
                inject = true;
                optional = true;
                break;
            }
            case 33: {
                tagBegin = this.jj_consume_token(33);
                stateVar = true;
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (tagBegin.specialToken != null) {
            desc = tagBegin.specialToken.image;
        }
        Token name = this.jj_consume_token(85);
        try {
            block8 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 86: {
                    this.jj_consume_token(86);
                    paramTypeNode = this.TypeExpr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 135: {
                            this.jj_consume_token(135);
                            value = this.Expr();
                            break block8;
                        }
                    }
                    this.jj_la1[23] = this.jj_gen;
                    break;
                }
                case 87: {
                    this.jj_consume_token(87);
                    value = this.Expr();
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.jj_consume_token(83);
        }
        catch (ParseException parseException) {
            this.reportTemplateBodyErrorAndSkipTo(parseException, 83);
        }
        if (desc != null) {
            desc = desc.substring(3, desc.length() - 2).trim();
        }
        if (stateVar) {
            if (value == null) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), STATE_REQUIRES_VALUE, new Object[0]);
                value = this.errorExpr(name, new Token[0]);
            }
            return new TemplateStateVar(name.image, paramTypeNode, value, desc, this.createSrcLoc(name, new Token[0]));
        }
        boolean isNullable = false;
        if (paramTypeNode instanceof UnionTypeNode) {
            UnionTypeNode utn = (UnionTypeNode)paramTypeNode;
            for (TypeNode tn : utn.candidates()) {
                if (!(tn instanceof NamedTypeNode) || !((NamedTypeNode)tn).name().equals("null")) continue;
                isNullable = true;
                break;
            }
        } else if (paramTypeNode instanceof NamedTypeNode && ((NamedTypeNode)paramTypeNode).name().equals("null")) {
            isNullable = true;
        }
        if (optional && !isNullable && paramTypeNode != null) {
            NamedTypeNode nullType = NamedTypeNode.create(paramTypeNode.sourceLocation(), "null");
            TypeNode typeNode = paramTypeNode = paramTypeNode instanceof UnionTypeNode ? UnionTypeNode.create((Iterable<TypeNode>)ImmutableList.builder().addAll(((UnionTypeNode)paramTypeNode).candidates()).add((Object)nullType).build()) : UnionTypeNode.create((Iterable<TypeNode>)ImmutableList.of((Object)paramTypeNode, (Object)nullType));
        }
        if (value != null) {
            if (inject) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), INJECT_DEFAULT_PARAM, new Object[0]);
            } else if (optional) {
                this.errorReporter.report(this.createSrcLoc(tagBegin, new Token[0]), OPTIONAL_DEFAULT_PARAM, new Object[0]);
            }
        }
        return new TemplateParam(name.image, this.createSrcLoc(name, new Token[0]), paramTypeNode, value == null && !optional && !isNullable, inject, desc, value);
    }

    private final List<SoyNode.StandaloneNode> TemplateBlock() throws ParseException {
        Object templateBlock = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 50: 
                case 53: 
                case 54: 
                case 55: 
                case 59: 
                case 61: 
                case 67: 
                case 71: 
                case 74: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 82: 
                case 92: 
                case 93: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            SoyNode.StandaloneNode node = this.TemplateBlockItem();
            if (templateBlock.isEmpty()) {
                templateBlock = new ArrayList();
            }
            templateBlock.add(node);
        }
        return templateBlock;
    }

    private final SoyNode.StandaloneNode TemplateBlockItem() throws ParseException {
        SoyNode.StandaloneNode node;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 92: 
            case 93: {
                node = this.RawText();
                break;
            }
            case 44: 
            case 45: 
            case 50: 
            case 53: 
            case 54: 
            case 55: 
            case 59: 
            case 61: 
            case 67: 
            case 71: 
            case 74: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 82: {
                node = this.Stmt();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    private final SoyNode.StatementNode Stmt() throws ParseException {
        SoyNode.StatementNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: 
            case 74: 
            case 76: 
            case 79: 
            case 80: 
            case 82: {
                stmt = this.NonPrintableStmt();
                break;
            }
            case 44: 
            case 45: 
            case 50: 
            case 53: 
            case 54: 
            case 77: 
            case 78: {
                stmt = this.PrintableStmt();
                break;
            }
            case 55: 
            case 61: 
            case 67: 
            case 71: {
                stmt = this.ControlFlowStmt();
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode NonPrintableStmt() throws ParseException {
        AbstractCommandNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 59: {
                stmt = this.LetStmt();
                break;
            }
            case 74: {
                stmt = this.LogStmt();
                break;
            }
            case 76: {
                stmt = this.DebuggerStmt();
                break;
            }
            case 80: {
                stmt = this.VeLogStmt();
                break;
            }
            case 79: {
                stmt = this.KeyStmt();
                break;
            }
            case 82: {
                stmt = this.SkipStmt();
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode PrintableStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                stmt = this.MsgStmt();
                break;
            }
            case 53: {
                stmt = this.XidStmt();
                break;
            }
            case 54: {
                stmt = this.CssStmt();
                break;
            }
            case 44: 
            case 45: {
                stmt = this.CallStmt();
                break;
            }
            case 77: 
            case 78: {
                stmt = this.PrintStmt();
                break;
            }
            default: {
                this.jj_la1[29] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final SoyNode.StatementNode ControlFlowStmt() throws ParseException {
        AbstractSoyNode stmt;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 55: {
                stmt = this.IfStmt();
                break;
            }
            case 67: {
                stmt = this.SwitchStmt();
                break;
            }
            case 61: {
                stmt = this.ForStmt();
                break;
            }
            case 71: {
                stmt = this.ForeachStmt();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return stmt;
    }

    private final MsgFallbackGroupNode MsgStmt() throws ParseException {
        Token tagEnd;
        Object attributes = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(50);
        try {
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        SourceLocation loc = this.createSrcLoc(tagBegin, tagEnd);
        MsgFallbackGroupNode msgGroup = new MsgFallbackGroupNode(this.nodeIdGen.genId(), loc);
        MsgNode msg = new MsgNode(this.nodeIdGen.genId(), loc, "msg", (List<CommandTagAttribute>)attributes, this.errorReporter);
        msgGroup.addChild(msg);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlockForMsg();
        msg.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 51: {
                tagBegin = this.jj_consume_token(51);
                try {
                    attributes = this.Attributes();
                    tagEnd = this.jj_consume_token(83);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
                }
                loc = this.createSrcLoc(tagBegin, tagEnd);
                MsgNode fallback = new MsgNode(this.nodeIdGen.genId(), loc, "fallbackmsg", (List<CommandTagAttribute>)attributes, this.errorReporter);
                msgGroup.addChild(fallback);
                templateBlock = this.TemplateBlockForMsg();
                fallback.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        this.jj_consume_token(52);
        return msgGroup;
    }

    private final List<SoyNode.StandaloneNode> TemplateBlockForMsg() throws ParseException {
        ArrayList<SoyNode.StandaloneNode> templateBlock;
        int pluralOrSelectIndex;
        block23: {
            pluralOrSelectIndex = -1;
            boolean firstNodeIsWhitespace = false;
            templateBlock = new ArrayList<SoyNode.StandaloneNode>();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 92: {
                    RawTextBuilder builder = new RawTextBuilder(this.filePath, this.nodeIdGen, this.whitespaceMode);
                    block17: while (true) {
                        Token tok = this.jj_consume_token(92);
                        builder.addBasic(tok);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 92: {
                                continue block17;
                            }
                        }
                        break;
                    }
                    this.jj_la1[32] = this.jj_gen;
                    RawTextNode rawText = builder.build();
                    if (rawText == null) break;
                    firstNodeIsWhitespace = true;
                    templateBlock.add(rawText);
                    break;
                }
                default: {
                    this.jj_la1[33] = this.jj_gen;
                }
            }
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 59: 
                    case 61: 
                    case 63: 
                    case 65: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 82: 
                    case 92: 
                    case 93: {
                        break;
                    }
                    default: {
                        this.jj_la1[34] = this.jj_gen;
                        break block23;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 63: 
                    case 65: {
                        AbstractParentCommandNode msgPluralOrSelectNode;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 63: {
                                msgPluralOrSelectNode = this.MsgPlural();
                                break;
                            }
                            case 65: {
                                msgPluralOrSelectNode = this.MsgSelect();
                                break;
                            }
                            default: {
                                this.jj_la1[35] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.SkipWhitespace();
                        if (firstNodeIsWhitespace) {
                            templateBlock.remove(0);
                            firstNodeIsWhitespace = false;
                        }
                        if (pluralOrSelectIndex == -1) {
                            pluralOrSelectIndex = templateBlock.size();
                        }
                        templateBlock.add((SoyNode.StandaloneNode)((Object)msgPluralOrSelectNode));
                        continue block18;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 50: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 59: 
                    case 61: 
                    case 67: 
                    case 71: 
                    case 74: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: 
                    case 80: 
                    case 82: 
                    case 92: 
                    case 93: {
                        SoyNode.StandaloneNode stmt = this.TemplateBlockItem();
                        if (stmt == null) continue block18;
                        templateBlock.add(stmt);
                        continue block18;
                    }
                }
                break;
            }
            this.jj_la1[36] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (pluralOrSelectIndex != -1) {
            SoyNode.StandaloneNode pluralOrSelect = (SoyNode.StandaloneNode)templateBlock.get(pluralOrSelectIndex);
            for (int i = 0; i < templateBlock.size(); ++i) {
                if (i == pluralOrSelectIndex) continue;
                this.errorReporter.report(((SoyNode.StandaloneNode)templateBlock.get(i)).getSourceLocation(), i < pluralOrSelectIndex ? UNEXPECTED_CONTENT_BEFORE : UNEXPECTED_CONTENT_AFTER, pluralOrSelect instanceof MsgPluralNode ? "{plural" : "{select");
            }
            return ImmutableList.of((Object)pluralOrSelect);
        }
        return templateBlock;
    }

    private final MsgPluralNode MsgPlural() throws ParseException {
        Token tagEnd;
        ExprNode pluralExpr;
        CommandTagAttribute offsetAttr = null;
        Token tagBegin = this.jj_consume_token(63);
        try {
            pluralExpr = this.Expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 85: 
                case 136: {
                    offsetAttr = this.Attribute();
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                }
            }
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            pluralExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        int offset = 0;
        if (offsetAttr != null) {
            if (pluralExpr.getSourceLocation().isJustBefore(offsetAttr.getName().location())) {
                this.errorReporter.report(offsetAttr.getName().location(), PARSER_ERROR, offsetAttr.getName().identifier(), "whitespace");
            }
            if (!offsetAttr.getName().identifier().equals("offset")) {
                this.errorReporter.report(offsetAttr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY_SINGLE, offsetAttr.getName().identifier(), "plural", "offset");
                offsetAttr = null;
            }
        }
        if (offsetAttr != null && (offset = offsetAttr.valueAsInteger(this.errorReporter, 0)) <= 0) {
            this.errorReporter.report(offsetAttr.getValueLocation(), PLURAL_OFFSET_OUT_OF_BOUNDS, new Object[0]);
            offset = 0;
        }
        MsgPluralNode pluralNode = new MsgPluralNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), pluralExpr, offset);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                int value;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[38] = this.jj_gen;
                        break block10;
                    }
                }
                tagBegin = this.jj_consume_token(69);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(83);
                if (!(caseExpr instanceof IntegerNode)) {
                    this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_MALFORMED, new Object[0]);
                    value = 0;
                } else {
                    value = (int)((IntegerNode)caseExpr).getValue();
                    if (value < 0) {
                        this.errorReporter.report(caseExpr.getSourceLocation(), PLURAL_CASE_OUT_OF_BOUNDS, value);
                        value = 0;
                    }
                }
                MsgPluralCaseNode caseNode = new MsgPluralCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                pluralNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                    this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
                }
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(70);
            MsgPluralDefaultNode defaultNode = new MsgPluralDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            pluralNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            if (templateBlock.size() == 1 && (templateBlock.get(0) instanceof MsgPluralNode || templateBlock.get(0) instanceof MsgSelectNode)) {
                this.errorReporter.report(templateBlock.get(0).getSourceLocation(), PLURAL_AND_SELECT_NOT_ALLOWED_INSIDE_PLURAL_BLOCK, new Object[0]);
            }
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(64);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 64);
        }
        return pluralNode;
    }

    private final MsgSelectNode MsgSelect() throws ParseException {
        Token tagEnd;
        ExprNode selectExpr;
        Token tagBegin = this.jj_consume_token(65);
        try {
            selectExpr = this.Expr();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            selectExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        MsgSelectNode selectNode = new MsgSelectNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), selectExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[39] = this.jj_gen;
                        break block7;
                    }
                }
                tagBegin = this.jj_consume_token(69);
                ExprNode caseExpr = this.Expr();
                tagEnd = this.jj_consume_token(83);
                String value = ParseErrors.validateSelectCaseLabel(caseExpr, this.errorReporter);
                MsgSelectCaseNode caseNode = new MsgSelectCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), value);
                selectNode.addChild(caseNode);
                templateBlock = this.TemplateBlockForMsg();
                caseNode.addChildren(templateBlock);
            }
            Token defaultTag = this.jj_consume_token(70);
            MsgSelectDefaultNode defaultNode = new MsgSelectDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
            selectNode.addChild(defaultNode);
            templateBlock = this.TemplateBlockForMsg();
            defaultNode.addChildren(templateBlock);
            this.jj_consume_token(66);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 66);
        }
        return selectNode;
    }

    private final PrintNode PrintStmt() throws ParseException {
        Token tagEnd;
        boolean isImplicit;
        Token tagBegin;
        ExprNode expr = null;
        Object directives = ImmutableList.of();
        Object attributes = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 77: {
                tagBegin = this.jj_consume_token(77);
                isImplicit = false;
                break;
            }
            case 78: {
                tagBegin = this.jj_consume_token(78);
                isImplicit = true;
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            expr = this.Expr();
            directives = this.PrintDirectives();
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        PrintNode node = new PrintNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), isImplicit, expr, (Iterable<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren((List)directives);
        return node;
    }

    private final List<PrintDirectiveNode> PrintDirectives() throws ParseException {
        Object directives = ImmutableList.of();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                    break block3;
                }
            }
            PrintDirectiveNode node = this.PrintDirective();
            if (directives.isEmpty()) {
                directives = new ArrayList();
            }
            directives.add(node);
        }
        return directives;
    }

    private final PrintDirectiveNode PrintDirective() throws ParseException {
        ImmutableList<ExprNode> args = ImmutableList.of();
        Token vbar = this.jj_consume_token(134);
        Token directive = this.jj_consume_token(136);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                this.jj_consume_token(110);
                args = this.ExprList();
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
            }
        }
        if (!Tokens.areAdjacent(vbar, directive)) {
            this.errorReporter.report(this.createSrcLoc(vbar, new Token[0]), UNEXPECTED_PIPE, new Object[0]);
        }
        SourceLocation loc = this.createSrcLoc(vbar, directive);
        Identifier ident = Identifier.create("|" + directive.image, loc);
        if (!args.isEmpty()) {
            loc.extend(((ExprNode)args.get(args.size() - 1)).getSourceLocation());
        }
        return new PrintDirectiveNode(this.nodeIdGen.genId(), ident, loc, args);
    }

    private final KeyNode KeyStmt() throws ParseException {
        Token tagEnd;
        ExprNode expr = null;
        Token tagBegin = this.jj_consume_token(79);
        try {
            expr = this.Expr();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            if (expr == null) {
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        KeyNode node = new KeyNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), expr);
        return node;
    }

    private final SkipNode SkipStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(82);
        SkipNode node = new SkipNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[0]));
        return node;
    }

    private final LogNode XidStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(53);
        Token tagEnd = this.skipToTemplateToken(83);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        this.errorReporter.report(location, CSS_XID_MIGRATION, "xid", "no longer supported");
        return new LogNode(this.nodeIdGen.genId(), location);
    }

    private final LogNode CssStmt() throws ParseException {
        Token tagBegin = this.jj_consume_token(54);
        Token tagEnd = this.skipToTemplateToken(83);
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        this.errorReporter.report(location, CSS_XID_MIGRATION, "css", "no longer supported");
        return new LogNode(this.nodeIdGen.genId(), location);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final LetNode LetStmt() throws ParseException {
        Token nameTok = null;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(59);
        try {
            nameTok = this.jj_consume_token(137);
        }
        catch (ParseException e) {
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 84, 83);
            SourceLocation loc = this.createSrcLoc(tagBegin, tagEnd);
            return new LetValueNode(-1, loc, "$error", loc, this.errorExpr(tagBegin, new Token[0]));
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                Token tagEnd;
                try {
                    this.jj_consume_token(110);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(84);
                    return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 84, 83);
                    if (valueExpr != null) return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new LetValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), valueExpr);
            }
            case 85: 
            case 136: {
                Token tagEnd;
                try {
                    attr = this.Attribute();
                    tagEnd = this.jj_consume_token(83);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83, 84);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(60);
                if (attr == null) {
                    SourceLocation loc = this.createSrcLoc(tagBegin, tagEnd);
                    return new LetValueNode(-1, loc, "$error", loc, this.errorExpr(tagBegin, new Token[0]));
                }
                LetContentNode node = new LetContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), nameTok.image, this.createSrcLoc(nameTok, new Token[0]), attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[43] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final IfNode IfStmt() throws ParseException {
        Token tagEnd;
        ExprNode ifExpr;
        Token tagBegin = this.jj_consume_token(55);
        try {
            ifExpr = this.Expr();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            ifExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        SourceLocation location = this.createSrcLoc(tagBegin, tagEnd);
        IfNode ifNode = new IfNode(this.nodeIdGen.genId(), location);
        IfCondNode ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "if", ifExpr);
        ifNode.addChild(ifCondNode);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        ifCondNode.addChildren(templateBlock);
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 56: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block10;
                }
            }
            tagBegin = this.jj_consume_token(56);
            try {
                ifExpr = this.Expr();
                tagEnd = this.jj_consume_token(83);
            }
            catch (ParseException e) {
                ifExpr = this.errorExpr(tagBegin, new Token[0]);
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
            }
            location = this.createSrcLoc(tagBegin, tagEnd);
            ifCondNode = new IfCondNode(this.nodeIdGen.genId(), location, "elseif", ifExpr);
            ifNode.addChild(ifCondNode);
            templateBlock = this.TemplateBlock();
            ifCondNode.addChildren(templateBlock);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 57: {
                Token elseTag = this.jj_consume_token(57);
                IfElseNode ifElseNode = new IfElseNode(this.nodeIdGen.genId(), this.createSrcLoc(elseTag, new Token[0]));
                ifNode.addChild(ifElseNode);
                templateBlock = this.TemplateBlock();
                ifElseNode.addChildren(templateBlock);
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(58);
        return ifNode;
    }

    private final VeLogNode VeLogStmt() throws ParseException {
        Token tagEnd;
        ExprNode veDataExpr = null;
        Object attributes = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(80);
        try {
            veDataExpr = this.Expr();
            attributes = this.Attributes();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            if (veDataExpr == null) {
                veDataExpr = this.errorExpr(tagBegin, new Token[0]);
            }
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        this.jj_consume_token(81);
        VeLogNode node = new VeLogNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), veDataExpr, (List<CommandTagAttribute>)attributes, this.errorReporter);
        node.addChildren(templateBlock);
        return node;
    }

    private final SwitchNode SwitchStmt() throws ParseException {
        Token tagEnd;
        ExprNode switchExpr;
        Token tagBegin = this.jj_consume_token(67);
        try {
            switchExpr = this.Expr();
            tagEnd = this.jj_consume_token(83);
        }
        catch (ParseException e) {
            switchExpr = this.errorExpr(tagBegin, new Token[0]);
            tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
        }
        SwitchNode switchNode = new SwitchNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), switchExpr);
        this.SkipWhitespace();
        try {
            List<SoyNode.StandaloneNode> templateBlock;
            block10: while (true) {
                tagBegin = this.jj_consume_token(69);
                ImmutableList<ExprNode> caseExprs = this.ExprList();
                tagEnd = this.jj_consume_token(83);
                SwitchCaseNode caseNode = new SwitchCaseNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), caseExprs);
                switchNode.addChild(caseNode);
                templateBlock = this.TemplateBlock();
                caseNode.addChildren(templateBlock);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 69: {
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[46] = this.jj_gen;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 70: {
                    Token defaultTag = this.jj_consume_token(70);
                    SwitchDefaultNode defaultNode = new SwitchDefaultNode(this.nodeIdGen.genId(), this.createSrcLoc(defaultTag, new Token[0]));
                    switchNode.addChild(defaultNode);
                    templateBlock = this.TemplateBlock();
                    defaultNode.addChildren(templateBlock);
                    break;
                }
                default: {
                    this.jj_la1[47] = this.jj_gen;
                }
            }
            this.jj_consume_token(68);
        }
        catch (ParseException e) {
            this.reportTemplateBodyErrorAndSkipTo(e, 68);
        }
        return switchNode;
    }

    private final ForNode ForStmt() throws ParseException {
        Token tagEnd;
        Token tagBegin;
        SourceLocation nameLocation;
        String name;
        ExprNode expr;
        block6: {
            expr = null;
            name = null;
            nameLocation = null;
            tagBegin = this.jj_consume_token(61);
            try {
                Token nameTok = this.jj_consume_token(137);
                name = nameTok.image;
                nameLocation = this.createSrcLoc(nameTok, new Token[0]);
                this.Keyword("in");
                expr = this.Expr();
                tagEnd = this.jj_consume_token(83);
            }
            catch (ParseException e) {
                tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83);
                if (name == null) {
                    name = "$error";
                    nameLocation = this.createSrcLoc(tagBegin, new Token[0]);
                }
                if (expr != null) break block6;
                expr = this.errorExpr(tagBegin, new Token[0]);
            }
        }
        ForNode forNode = new ForNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), expr);
        ForNonemptyNode nonEmpty = new ForNonemptyNode(this.nodeIdGen.genId(), name, nameLocation);
        forNode.addChild(nonEmpty);
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        nonEmpty.addChildren(templateBlock);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 72: {
                Token ifemptyTag = this.jj_consume_token(72);
                templateBlock = this.TemplateBlock();
                ForIfemptyNode ifempty = new ForIfemptyNode(this.nodeIdGen.genId(), this.createSrcLoc(ifemptyTag, new Token[0]));
                ifempty.addChildren(templateBlock);
                forNode.addChild(ifempty);
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
            }
        }
        this.jj_consume_token(62);
        return forNode;
    }

    private final LogNode ForeachStmt() throws ParseException {
        Token tok = this.jj_consume_token(71);
        SourceLocation location = this.createSrcLoc(tok, new Token[0]);
        this.errorReporter.report(location, FOREACH_IS_DISABLED, new Object[0]);
        this.skipToTemplateToken(73);
        return new LogNode(this.nodeIdGen.genId(), location);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final CallNode CallStmt() throws ParseException {
        calleeName = null;
        attributes /* !! */  = ImmutableList.of();
        params /* !! */  = ImmutableList.of();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 44: {
                tagBegin = this.jj_consume_token(44);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 84: {
                            tagEnd = this.jj_consume_token(84);
                            break;
                        }
                        case 83: {
                            tagEnd = this.jj_consume_token(83);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(46);
                            break;
                        }
                        default: {
                            this.jj_la1[49] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{84, 46});
                    if (calleeName != null) ** GOTO lbl30
                    calleeName = Identifier.create(".error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl30:
                // 3 sources

                fullName = SoyParseUtils.calculateFullCalleeName(calleeName, this.headerInfo, this.errorReporter);
                node = new CallBasicNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName, fullName, (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                return node;
            }
            case 45: {
                tagBegin = this.jj_consume_token(45);
                try {
                    calleeName = this.TemplateName();
                    attributes /* !! */  = this.Attributes();
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 84: {
                            tagEnd = this.jj_consume_token(84);
                            break;
                        }
                        case 83: {
                            tagEnd = this.jj_consume_token(83);
                            params /* !! */  = this.CallParams();
                            this.jj_consume_token(47);
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, new int[]{84, 47});
                    if (calleeName != null) ** GOTO lbl59
                    calleeName = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
                }
lbl59:
                // 3 sources

                if (calleeName.type() == Identifier.Type.DOT_IDENT) {
                    this.errorReporter.report(calleeName.location(), SoyFileParser.INVALID_CALLEE_NAME, new Object[]{calleeName.identifier()});
                }
                node = new CallDelegateNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, new Token[]{tagEnd}), calleeName, (List<CommandTagAttribute>)attributes /* !! */ , this.errorReporter);
                node.addChildren((List)params /* !! */ );
                return node;
            }
        }
        this.jj_la1[51] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final List<CallParamNode> CallParams() throws ParseException {
        Object params = ImmutableList.of();
        this.SkipWhitespace();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    break;
                }
                default: {
                    this.jj_la1[52] = this.jj_gen;
                    break block3;
                }
            }
            CallParamNode paramNode = this.CallParam();
            if (params.isEmpty()) {
                params = new ArrayList();
            }
            params.add(paramNode);
            this.SkipWhitespace();
        }
        return params;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final CallParamNode CallParam() throws ParseException {
        Identifier key;
        ExprNode valueExpr = null;
        CommandTagAttribute attr = null;
        ImmutableList immutableList = ImmutableList.of();
        Token tagBegin = this.jj_consume_token(48);
        try {
            key = this.Identifier();
        }
        catch (ParseException e) {
            Identifier key2 = Identifier.create("error", this.createSrcLoc(tagBegin, new Token[0]));
            Token tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 84, 83);
            return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), key2, this.errorExpr(tagBegin, new Token[0]));
        }
        if (key.type() != Identifier.Type.SINGLE_IDENT) {
            this.errorReporter.report(key.location(), INVALID_PARAM_NAME, key.identifier());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 110: {
                Token tagEnd;
                try {
                    this.jj_consume_token(110);
                    valueExpr = this.Expr();
                    tagEnd = this.jj_consume_token(84);
                    return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 84, 83);
                    if (valueExpr != null) return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
                    valueExpr = this.errorExpr(tagEnd, new Token[0]);
                }
                return new CallParamValueNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, valueExpr);
            }
            case 85: 
            case 136: {
                Token tagEnd;
                try {
                    attr = this.Attribute();
                    tagEnd = this.jj_consume_token(83);
                }
                catch (ParseException e) {
                    tagEnd = this.reportTemplateBodyErrorAndSkipTo(e, 83, 84);
                }
                List<SoyNode.StandaloneNode> list = this.TemplateBlock();
                this.jj_consume_token(49);
                if (attr == null) {
                    return new CallParamValueNode(-1, this.createSrcLoc(tagBegin, tagEnd), key, this.errorExpr(tagBegin, new Token[0]));
                }
                CallParamContentNode node = new CallParamContentNode(this.nodeIdGen.genId(), this.createSrcLoc(tagBegin, tagEnd), key, attr, this.errorReporter);
                node.addChildren((List<? extends SoyNode.StandaloneNode>)list);
                return node;
            }
        }
        this.jj_la1[53] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final LogNode LogStmt() throws ParseException {
        Token open = this.jj_consume_token(74);
        LogNode logNode = new LogNode(this.nodeIdGen.genId(), this.createSrcLoc(open, new Token[0]));
        List<SoyNode.StandaloneNode> templateBlock = this.TemplateBlock();
        logNode.addChildren(templateBlock);
        this.jj_consume_token(75);
        return logNode;
    }

    private final DebuggerNode DebuggerStmt() throws ParseException {
        Token token = this.jj_consume_token(76);
        return new DebuggerNode(this.nodeIdGen.genId(), this.createSrcLoc(token, new Token[0]));
    }

    private final ExprNode ExprInput() throws ParseException {
        ExprNode expr = this.Expr();
        this.jj_consume_token(0);
        return expr;
    }

    private final ImmutableList<ExprNode> ExprList() throws ParseException {
        ImmutableList.Builder exprList = ImmutableList.builder();
        ExprNode expr = this.Expr();
        exprList.add((Object)expr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 131: {
                    break;
                }
                default: {
                    this.jj_la1[54] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(131);
            expr = this.Expr();
            exprList.add((Object)expr);
        }
        return exprList.build();
    }

    private final ExprNode Expr() throws ParseException {
        ExprNode expr = this.PrecExpr1();
        return expr;
    }

    private final ExprNode PrecExpr1() throws ParseException {
        ExprNode expr = this.PrecExpr2();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 109: 
            case 111: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 111: {
                        Token op = this.jj_consume_token(111);
                        ExprNode expr1 = this.PrecExpr1();
                        expr = Operator.NULL_COALESCING.createNode(this.createSrcLoc(op, new Token[0]), expr, expr1);
                        break block0;
                    }
                    case 109: {
                        this.jj_consume_token(109);
                        ExprNode expr1 = this.PrecExpr1();
                        this.jj_consume_token(110);
                        ExprNode expr2 = this.PrecExpr1();
                        expr = Operator.CONDITIONAL.createNode(expr.getSourceLocation().extend(expr2.getSourceLocation()), expr, expr1, expr2);
                        break block0;
                    }
                }
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[56] = this.jj_gen;
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr2() throws ParseException {
        ExprNode expr = this.PrecExpr3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 112: {
                    break;
                }
                default: {
                    this.jj_la1[57] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(112);
            ExprNode rightHand = this.PrecExpr3();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 2, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr3() throws ParseException {
        ExprNode expr = this.PrecExpr4();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 113: {
                    break;
                }
                default: {
                    this.jj_la1[58] = this.jj_gen;
                    break block3;
                }
            }
            Token op = this.jj_consume_token(113);
            ExprNode rightHand = this.PrecExpr4();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 3, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr4() throws ParseException {
        ExprNode expr = this.PrecExpr5();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: 
                case 115: {
                    break;
                }
                default: {
                    this.jj_la1[59] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 114: {
                    op = this.jj_consume_token(114);
                    break;
                }
                case 115: {
                    op = this.jj_consume_token(115);
                    break;
                }
                default: {
                    this.jj_la1[60] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr5();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 4, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr5() throws ParseException {
        ExprNode expr = this.PrecExpr6();
        block9: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    break;
                }
                default: {
                    this.jj_la1[61] = this.jj_gen;
                    break block9;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 116: {
                    op = this.jj_consume_token(116);
                    break;
                }
                case 117: {
                    op = this.jj_consume_token(117);
                    break;
                }
                case 118: {
                    op = this.jj_consume_token(118);
                    break;
                }
                case 119: {
                    op = this.jj_consume_token(119);
                    break;
                }
                default: {
                    this.jj_la1[62] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr6();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 5, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr6() throws ParseException {
        ExprNode expr = this.PrecExpr7();
        block7: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: 
                case 121: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block7;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 120: {
                    op = this.jj_consume_token(120);
                    break;
                }
                case 121: {
                    op = this.jj_consume_token(121);
                    break;
                }
                default: {
                    this.jj_la1[64] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr7();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 6, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr7() throws ParseException {
        ExprNode expr = this.PrecExpr8();
        block8: while (true) {
            Token op;
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 122: 
                case 123: 
                case 124: {
                    break;
                }
                default: {
                    this.jj_la1[65] = this.jj_gen;
                    break block8;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 122: {
                    op = this.jj_consume_token(122);
                    break;
                }
                case 123: {
                    op = this.jj_consume_token(123);
                    break;
                }
                case 124: {
                    op = this.jj_consume_token(124);
                    break;
                }
                default: {
                    this.jj_la1[66] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            ExprNode rightHand = this.PrecExpr8();
            expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 7, expr, rightHand);
        }
        return expr;
    }

    private final ExprNode PrecExpr8() throws ParseException {
        ExprNode expr;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 128: 
            case 132: 
            case 136: 
            case 137: {
                expr = this.PrecExpr9();
                break;
            }
            case 121: 
            case 125: {
                Token op;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 125: {
                        op = this.jj_consume_token(125);
                        break;
                    }
                    case 121: {
                        op = this.jj_consume_token(121);
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                expr = this.PrecExpr8();
                if (op.kind == 121 && expr instanceof IntegerNode) {
                    SourceLocation newLoc = this.createSrcLoc(op, new Token[0]).extend(expr.getSourceLocation());
                    long value = -1L * ((IntegerNode)expr).getValue();
                    expr = new IntegerNode(value, newLoc);
                    break;
                }
                if (op.kind == 121 && expr instanceof FloatNode) {
                    SourceLocation newLoc = this.createSrcLoc(op, new Token[0]).extend(expr.getSourceLocation());
                    double value = -1.0 * ((FloatNode)expr).getValue();
                    expr = new FloatNode(value, newLoc);
                    break;
                }
                expr = Operator.createOperatorNode(this.createSrcLoc(op, new Token[0]), op.image, 8, expr);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return expr;
    }

    private final ExprNode PrecExpr9() throws ParseException {
        ExprNode expr;
        block16: {
            expr = this.Primary();
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 126: 
                    case 127: 
                    case 128: 
                    case 130: {
                        break;
                    }
                    default: {
                        this.jj_la1[69] = this.jj_gen;
                        break block16;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 126: 
                    case 127: {
                        Token op;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 126: {
                                op = this.jj_consume_token(126);
                                break;
                            }
                            case 127: {
                                op = this.jj_consume_token(127);
                                break;
                            }
                            default: {
                                this.jj_la1[70] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        Token ident = this.jj_consume_token(136);
                        expr = new FieldAccessNode(expr, ident.image, this.createSrcLoc(op, ident), op.kind == 127);
                        continue block15;
                    }
                    case 128: 
                    case 130: {
                        Token open;
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 128: {
                                open = this.jj_consume_token(128);
                                break;
                            }
                            case 130: {
                                open = this.jj_consume_token(130);
                                break;
                            }
                            default: {
                                this.jj_la1[71] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        ExprNode keyExpr = this.Expr();
                        Token close = this.jj_consume_token(129);
                        expr = new ItemAccessNode(expr, keyExpr, this.createSrcLoc(open, close), open.kind == 130);
                        continue block15;
                    }
                }
                break;
            }
            this.jj_la1[72] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expr;
    }

    private final ExprNode Primary() throws ParseException {
        ExprNode primary;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 132: {
                this.jj_consume_token(132);
                primary = this.Expr();
                this.jj_consume_token(133);
                break;
            }
            case 137: {
                primary = this.VarRef();
                break;
            }
            case 136: {
                primary = this.GlobalOrFunctionCallLike();
                break;
            }
            case 128: {
                primary = this.ListLiteral();
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                primary = this.Primitive();
                break;
            }
            default: {
                this.jj_la1[73] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primary;
    }

    private final VarRefNode VarRef() throws ParseException {
        Token ident = this.jj_consume_token(137);
        return new VarRefNode(ident.image.substring(1), this.createSrcLoc(ident, new Token[0]), null);
    }

    private final ExprNode GlobalOrFunctionCallLike() throws ParseException {
        Token openParen = null;
        Token closeParen = null;
        ArrayList<ExprNode> params = new ArrayList<ExprNode>();
        Identifier ident = this.Identifier();
        boolean isRecord = "record".equals(ident.identifier());
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 132: {
                openParen = this.jj_consume_token(132);
                if (ident.identifier().equals("map")) {
                    return this.MapLiteral(ident);
                }
                if (ident.identifier().equals("ve")) {
                    return this.VeLiteral(ident);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: 
                    case 95: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 121: 
                    case 125: 
                    case 128: 
                    case 132: 
                    case 136: 
                    case 137: {
                        ExprNode key = this.Expr();
                        if (isRecord || this.getToken((int)1).kind == 110) {
                            this.jj_consume_token(110);
                            ExprNode val = this.Expr();
                            if (!(key instanceof GlobalNode) || !BaseUtils.isIdentifier(((GlobalNode)key).getName())) {
                                this.errorReporter.report(key.getSourceLocation(), INVALID_KEY_NAME, isRecord ? "record key name" : "param name", key.toSourceString(), isRecord ? " A record key must be a valid Soy identifier. Did you mean to use a map?" : "");
                                key = GlobalNode.error(key.getSourceLocation());
                            }
                            HashSet<String> paramNames = new HashSet<String>();
                            ArrayList<Identifier> paramIds = new ArrayList<Identifier>();
                            paramNames.add(((GlobalNode)key).getName());
                            paramIds.add(Identifier.create(((GlobalNode)key).getName(), key.getSourceLocation()));
                            params.add(val);
                            while (this.getToken((int)1).kind == 131 && this.getToken((int)2).kind != 133) {
                                this.jj_consume_token(131);
                                Token paramName = this.jj_consume_token(136);
                                if (!paramNames.add(paramName.image)) {
                                    this.errorReporter.report(this.createSrcLoc(paramName, new Token[0]), DUPLICATE_KEY_NAME, isRecord ? "record key" : "param name", paramName.image);
                                } else {
                                    paramIds.add(Identifier.create(paramName.image, this.createSrcLoc(paramName, new Token[0])));
                                }
                                this.jj_consume_token(110);
                                val = this.Expr();
                                params.add(val);
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 131: {
                                    this.jj_consume_token(131);
                                    break;
                                }
                                default: {
                                    this.jj_la1[74] = this.jj_gen;
                                }
                            }
                            closeParen = this.jj_consume_token(133);
                            SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
                            AbstractParentExprNode node = isRecord ? new RecordLiteralNode(ident, paramIds, loc) : new ProtoInitNode(this.headerInfo.resolveAlias(ident.identifier()), paramIds, loc);
                            node.addChildren((List<? extends ExprNode>)params);
                            return node;
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 131: 
                            case 133: {
                                params.add(key);
                                block16: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                        case 131: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[75] = this.jj_gen;
                                            break block16;
                                        }
                                    }
                                    this.jj_consume_token(131);
                                    ExprNode val = this.Expr();
                                    params.add(val);
                                }
                                closeParen = this.jj_consume_token(133);
                                SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
                                FunctionNode fnNode = new FunctionNode(ident, loc);
                                fnNode.addChildren((List<? extends ExprNode>)params);
                                return fnNode;
                            }
                        }
                        this.jj_la1[76] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[77] = this.jj_gen;
                closeParen = this.jj_consume_token(133);
                break;
            }
            default: {
                this.jj_la1[78] = this.jj_gen;
            }
        }
        if (openParen == null) {
            return new GlobalNode(this.headerInfo.resolveAlias(ident.identifier()), ident.identifier(), ident.location());
        }
        SourceLocation loc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        if (isRecord) {
            return new RecordLiteralNode(ident, (Iterable<Identifier>)ImmutableList.of(), loc);
        }
        return new FunctionNode(ident, loc);
    }

    private final ExprNode MapLiteral(Identifier ident) throws ParseException {
        ImmutableMap.Builder kvPairs = ImmutableMap.builder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 121: 
            case 125: 
            case 128: 
            case 132: 
            case 136: 
            case 137: {
                ExprNode key = this.Expr();
                this.jj_consume_token(110);
                ExprNode val = this.Expr();
                kvPairs.put((Object)key, (Object)val);
                while (this.getToken((int)1).kind == 131 && this.getToken((int)2).kind != 133) {
                    this.jj_consume_token(131);
                    key = this.Expr();
                    this.jj_consume_token(110);
                    val = this.Expr();
                    kvPairs.put((Object)key, (Object)val);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 131: {
                        this.jj_consume_token(131);
                        break block0;
                    }
                }
                this.jj_la1[79] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        Token closeParen = this.jj_consume_token(133);
        SourceLocation srcLoc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        return new MapLiteralNode(ident, (ImmutableMap<ExprNode, ExprNode>)kvPairs.build(), srcLoc);
    }

    private final ExprNode VeLiteral(Identifier ident) throws ParseException {
        Identifier name = this.Identifier();
        Token closeParen = this.jj_consume_token(133);
        SourceLocation srcLoc = ident.location().extend(this.createSrcLoc(closeParen, new Token[0]));
        return new VeLiteralNode(ident, name, srcLoc);
    }

    private final ExprNode ListLiteral() throws ParseException {
        Object items = ImmutableList.of();
        Token begin = this.jj_consume_token(128);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 129: {
                Token end = this.jj_consume_token(129);
                return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 121: 
            case 125: 
            case 128: 
            case 132: 
            case 136: 
            case 137: {
                Token end;
                ExprNode itemExpr = this.Expr();
                items = new ArrayList();
                items.add(itemExpr);
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 110: {
                        end = this.jj_consume_token(110);
                        this.errorReporter.report(this.createSrcLoc(end, new Token[0]), OLD_RECORD_LITERAL_SYNTAX, new Object[0]);
                        this.skipToTemplateToken(new int[0]);
                        break;
                    }
                    default: {
                        this.jj_la1[82] = this.jj_gen;
                        while (this.getToken((int)1).kind == 131 && this.getToken((int)2).kind != 129) {
                            this.jj_consume_token(131);
                            itemExpr = this.Expr();
                            items.add(itemExpr);
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 131: {
                                this.jj_consume_token(131);
                                break block4;
                            }
                        }
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                end = this.jj_consume_token(129);
                return new ListLiteralNode((List<ExprNode>)items, this.createSrcLoc(begin, end));
            }
        }
        this.jj_la1[83] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    private final ExprNode.PrimitiveNode Primitive() throws ParseException {
        AbstractPrimitiveNode primitive;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 94: {
                Token tok = this.jj_consume_token(94);
                primitive = new NullNode(this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 95: {
                Token tok = this.jj_consume_token(95);
                primitive = new BooleanNode(true, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 96: {
                Token tok = this.jj_consume_token(96);
                primitive = new BooleanNode(false, this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 97: {
                Token tok = this.jj_consume_token(97);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image, (int)10);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 98: {
                Token tok = this.jj_consume_token(98);
                SourceLocation loc = this.createSrcLoc(tok, new Token[0]);
                Long parsed = Longs.tryParse((String)tok.image.substring(2), (int)16);
                if (parsed == null || !IntegerNode.isInRange(parsed)) {
                    this.errorReporter.report(loc, INTEGER_OUT_OF_RANGE, new Object[0]);
                    parsed = 0L;
                }
                primitive = new IntegerNode(parsed, loc);
                break;
            }
            case 99: {
                Token tok = this.jj_consume_token(99);
                primitive = new FloatNode(Double.parseDouble(tok.image), this.createSrcLoc(tok, new Token[0]));
                break;
            }
            case 100: 
            case 101: {
                primitive = this.StringLiteral();
                break;
            }
            default: {
                this.jj_la1[84] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return primitive;
    }

    private final StringNode StringLiteral() throws ParseException {
        QuoteStyle quoteStyle;
        Token value;
        Token quote;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 100: {
                quote = this.jj_consume_token(100);
                this.token_source.pushState(11);
                value = this.jj_consume_token(102);
                quoteStyle = QuoteStyle.SINGLE;
                break;
            }
            case 101: {
                quote = this.jj_consume_token(101);
                this.token_source.pushState(12);
                value = this.jj_consume_token(103);
                quoteStyle = QuoteStyle.DOUBLE;
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SourceLocation loc = this.createSrcLoc(quote, value);
        String rawString = value.image.substring(0, value.image.length() - 1);
        String unescaped = SoyParseUtils.unescapeString(rawString, this.errorReporter, loc);
        return new StringNode(unescaped, quoteStyle, loc);
    }

    private final Identifier Identifier() throws ParseException {
        Token next = null;
        StringBuilder sb = null;
        Token first = this.jj_consume_token(136);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 126: {
                    break;
                }
                default: {
                    this.jj_la1[86] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(126);
            next = this.jj_consume_token(136);
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(first.image);
            }
            sb.append('.').append(next.image);
        }
        return sb == null ? Identifier.create(first.image, this.createSrcLoc(first, new Token[0])) : Identifier.create(sb.toString(), this.createSrcLoc(first, next));
    }

    private final Token Keyword(String keyword) throws ParseException {
        Token ident = this.jj_consume_token(136);
        if (!ident.image.equals(keyword)) {
            throw this.generateParseException();
        }
        return ident;
    }

    private final TypeNode TypeExprInput() throws ParseException {
        TypeNode type = this.TypeExpr();
        this.jj_consume_token(0);
        return type;
    }

    private final TypeNode TypeExpr() throws ParseException {
        ArrayList<TypeNode> members = null;
        TypeNode first = this.PrimaryType();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 134: {
                    break;
                }
                default: {
                    this.jj_la1[87] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(134);
            TypeNode next = this.PrimaryType();
            if (members == null) {
                members = new ArrayList<TypeNode>();
                members.add(first);
            }
            members.add(next);
        }
        return members == null ? first : UnionTypeNode.create(members);
    }

    private final TypeNode PrimaryType() throws ParseException {
        TypeNode type;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 136: {
                type = this.NamedType();
                break;
            }
            case 94: {
                type = this.NullType();
                break;
            }
            case 109: {
                type = this.UnknownType();
                break;
            }
            case 128: {
                type = this.RecordType();
                break;
            }
            default: {
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return type;
    }

    private final TypeNode RecordType() throws ParseException {
        Object properties = ImmutableList.of();
        Token open = this.jj_consume_token(128);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 136: {
                RecordTypeNode.Property prop = this.RecordField();
                properties = new ArrayList();
                properties.add(prop);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 131: {
                            break;
                        }
                        default: {
                            this.jj_la1[89] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(131);
                    prop = this.RecordField();
                    properties.add(prop);
                }
            }
            default: {
                this.jj_la1[90] = this.jj_gen;
            }
        }
        Token close = this.jj_consume_token(129);
        return RecordTypeNode.create(this.createSrcLoc(open, close), (Iterable<RecordTypeNode.Property>)properties);
    }

    private final RecordTypeNode.Property RecordField() throws ParseException {
        Token fieldName = this.jj_consume_token(136);
        this.jj_consume_token(110);
        TypeNode fieldType = this.TypeExpr();
        return RecordTypeNode.Property.create(this.createSrcLoc(fieldName, new Token[0]), fieldName.image, fieldType);
    }

    private final TypeNode NullType() throws ParseException {
        Token tok = this.jj_consume_token(94);
        return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), tok.image);
    }

    private final TypeNode NamedType() throws ParseException {
        Object genericArgs = ImmutableList.of();
        Identifier identifier = this.Identifier();
        identifier = Identifier.create(this.headerInfo.resolveAlias(identifier.identifier()), identifier.location());
        SourceLocation fullLocation = identifier.location();
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 116: {
                Token open = this.jj_consume_token(116);
                block3 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 94: 
                    case 109: 
                    case 128: 
                    case 136: {
                        TypeNode arg = this.TypeExpr();
                        genericArgs = new ArrayList();
                        genericArgs.add(arg);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 131: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[91] = this.jj_gen;
                                    break block3;
                                }
                            }
                            this.jj_consume_token(131);
                            arg = this.TypeExpr();
                            genericArgs.add(arg);
                        }
                    }
                    default: {
                        this.jj_la1[92] = this.jj_gen;
                    }
                }
                Token close = this.jj_consume_token(117);
                return GenericTypeNode.create(fullLocation.extend(this.createSrcLoc(close, new Token[0])), identifier, (Iterable<? extends TypeNode>)genericArgs);
            }
        }
        this.jj_la1[93] = this.jj_gen;
        return NamedTypeNode.create(identifier);
    }

    private final TypeNode UnknownType() throws ParseException {
        Token tok = this.jj_consume_token(109);
        return NamedTypeNode.create(this.createSrcLoc(tok, new Token[0]), "?");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{4096, 1024, 0x3800000, 0, 0, 0, 0, 0, 24576, 24576, 24576, 0x3800000, 0, 0, 0, 0, 0, 0, 0, -536870912, 0, -536870912, -536870912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2040, 4088, 4088, 3, 0, 3, 3, 0, 0, 686047224, 686047224, 686043136, 0x8000000, 6565888, 0x20800000, 524288, 0, 0, -1461436424, Integer.MIN_VALUE, -1461436424, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0x2000000, 0, 0, 0, 0, 0, 12288, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0x200000, 0x200000, -1073741824, -1073741824, 0, 0, 0, 0, 0x2200000, 0x2000000, 0x10000000, 0x30000000, 0, 0x30000000, 0x30000000, 0x10000000, 0x10000000, 0x10000000, 0, 0, 0xC00000, 805696648, 805696648, 390280, 365568, 24576, 136, 0, 0x10000000, 0x10000000, 805696650, 2, 805696650, 0x200000, 32, 32, 24576, 0, 0, 0x200000, 0, 0, 32, 64, 256, 0x180000, 0x180000, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1073741824, 0, 0, 0, 0, -1073741824, 0, 0, 0, -1073741824, 0, 0, -1073741824, 0, 0, -1073741824, -1073741824, 0, 0, 0, 0x40000000, 0, 0, 0, 0x40000000, 0};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 0, 570425407, 570425407, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 40960, 40960, 65536, 131072, 786432, 786432, 0xF00000, 0xF00000, 0x3000000, 0x3000000, 0x1C000000, 0x1C000000, 0x22000000, 570425407, -1073741824, -1073741824, 0, -1073741824, 63, 0, 0, 0, 570425407, 0, 0, 570425407, 0, 16384, 570425407, 63, 48, 0x40000000, 0, 8192, 0, 0, 0, 8192, 0x100000};
    }

    private static void jj_la1_init_4() {
        jj_la1_4 = new int[]{0, 0, 0, 256, 256, 256, 785, 785, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 64, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 785, 5, 0, 5, 5, 785, 8, 8, 40, 785, 16, 8, 785, 8, 0, 787, 0, 0, 0, 64, 257, 8, 256, 8, 257, 0};
    }

    public SoyFileParser(InputStream stream) {
        this(stream, null);
    }

    public SoyFileParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SoyFileParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SoyFileParser(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SoyFileParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 94; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[149];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 94; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) == 0) continue;
                la1tokens[128 + j] = true;
            }
        }
        for (i = 0; i < 149; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SoyFileParser.jj_la1_init_0();
        SoyFileParser.jj_la1_init_1();
        SoyFileParser.jj_la1_init_2();
        SoyFileParser.jj_la1_init_3();
        SoyFileParser.jj_la1_init_4();
    }

    private static final class AbortParsingError
    extends Error {
        private AbortParsingError() {
        }
    }
}

