/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import com.ibm.icu.util.ULocale;
import javax.annotation.Nullable;

final class TofuJavaValue
implements JavaValue {
    @Nullable
    private final SoyValue soyValue;
    @Nullable
    private final SourceLocation sourceLocation;
    @Nullable
    private final ULocale locale;
    @Nullable
    private final BidiGlobalDir bidiGlobalDir;

    static TofuJavaValue forSoyValue(SoyValue soyValue, SourceLocation sourceLocation) {
        return new TofuJavaValue((SoyValue)Preconditions.checkNotNull((Object)soyValue), null, null, (SourceLocation)Preconditions.checkNotNull((Object)sourceLocation));
    }

    static TofuJavaValue forULocale(ULocale locale) {
        return new TofuJavaValue(null, (ULocale)Preconditions.checkNotNull((Object)locale), null, null);
    }

    static JavaValue forBidiDir(BidiGlobalDir bidiGlobalDir) {
        return new TofuJavaValue(null, null, (BidiGlobalDir)Preconditions.checkNotNull((Object)bidiGlobalDir), null);
    }

    private TofuJavaValue(SoyValue soyValue, ULocale locale, BidiGlobalDir bidiGlobalDir, SourceLocation sourceLocation) {
        this.soyValue = soyValue;
        this.locale = locale;
        this.bidiGlobalDir = bidiGlobalDir;
        this.sourceLocation = sourceLocation;
    }

    boolean hasSoyValue() {
        return this.soyValue != null;
    }

    SoyValue soyValue() {
        Preconditions.checkState((this.soyValue != null ? 1 : 0) != 0);
        return this.soyValue;
    }

    BidiGlobalDir bidiGlobalDir() {
        Preconditions.checkState((this.bidiGlobalDir != null ? 1 : 0) != 0);
        return this.bidiGlobalDir;
    }

    ULocale locale() {
        Preconditions.checkState((this.locale != null ? 1 : 0) != 0);
        return this.locale;
    }

    @Override
    public TofuJavaValue isNonNull() {
        if (this.soyValue == null) {
            throw RenderException.create("isNonNull is only supported on the 'args' parameters of JavaValueFactory methods");
        }
        return TofuJavaValue.forSoyValue(BooleanData.forValue(!(this.soyValue instanceof UndefinedData) && !(this.soyValue instanceof NullData)), this.sourceLocation);
    }

    @Override
    public TofuJavaValue isNull() {
        if (this.soyValue == null) {
            throw RenderException.create("isNull is only supported on the 'args' parameters of JavaValueFactory methods");
        }
        return TofuJavaValue.forSoyValue(BooleanData.forValue(this.soyValue instanceof UndefinedData || this.soyValue instanceof NullData), this.sourceLocation);
    }

    @Override
    public TofuJavaValue asSoyBoolean() {
        this.checkType(BoolType.getInstance());
        return this;
    }

    @Override
    public TofuJavaValue asSoyFloat() {
        this.checkType(StringType.getInstance());
        return this;
    }

    @Override
    public TofuJavaValue asSoyInt() {
        this.checkType(IntType.getInstance());
        return this;
    }

    @Override
    public TofuJavaValue asSoyString() {
        this.checkType(StringType.getInstance());
        return this;
    }

    @Override
    public JavaValue coerceToSoyBoolean() {
        return TofuJavaValue.forSoyValue(BooleanData.forValue(this.soyValue.coerceToBoolean()), this.sourceLocation);
    }

    @Override
    public JavaValue coerceToSoyString() {
        return TofuJavaValue.forSoyValue(StringData.forValue(this.soyValue.coerceToString()), this.sourceLocation);
    }

    private void checkType(SoyType type) {
        if (!TofuTypeChecks.isInstance(type, this.soyValue, this.sourceLocation)) {
            throw RenderException.create("SoyValue[" + this.soyValue + "] of type: " + this.soyValue.getClass() + " is incompatible with soy type: " + type);
        }
    }

    public String toString() {
        if (this.soyValue != null) {
            return "TofuJavaValue[soyValue=" + this.soyValue + "]";
        }
        if (this.locale != null) {
            return "TofuJavaValue[locale=" + this.locale + "]";
        }
        return "TofuJavaValue[bidiGlobalDir=" + this.bidiGlobalDir + "]";
    }
}

