/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal.gencode;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JavaGenerationUtils {
    private static final Pattern ALL_UPPER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [A-Z]+  (?= [^A-Za-z] | $)", 4);
    private static final Pattern ALL_LOWER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [a-z]+  (?= [^a-z] | $)", 4);
    private static final Pattern NON_LETTER_DIGIT = Pattern.compile("[^A-Za-z0-9]");

    private JavaGenerationUtils() {
    }

    public static void appendJavadoc(IndentedLinesBuilder ilb, String doc, boolean forceMultiline, boolean wrapAt100Chars) {
        if (wrapAt100Chars) {
            int wrapLen = 100 - ilb.getCurrIndentLen() - 7;
            ArrayList wrappedLines = Lists.newArrayList();
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                while (line.length() > wrapLen) {
                    int spaceIndex = line.lastIndexOf(32, wrapLen);
                    if (spaceIndex >= 0) {
                        wrappedLines.add(line.substring(0, spaceIndex));
                        line = line.substring(spaceIndex + 1);
                        continue;
                    }
                    wrappedLines.add(line.substring(0, wrapLen));
                    line = line.substring(wrapLen);
                }
                wrappedLines.add(line);
            }
            doc = Joiner.on((String)"\n").join((Iterable)wrappedLines);
        }
        if (doc.contains("\n") || forceMultiline) {
            ilb.appendLine("/**");
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                ilb.appendLine(" * ", line);
            }
            ilb.appendLine(" */");
        } else {
            ilb.appendLine("/** ", doc, " */");
        }
    }

    public static String makeUpperCamelCase(String str) {
        str = JavaGenerationUtils.makeWordsCapitalized(str, ALL_UPPER_WORD);
        str = JavaGenerationUtils.makeWordsCapitalized(str, ALL_LOWER_WORD);
        str = NON_LETTER_DIGIT.matcher(str).replaceAll("");
        return str;
    }

    private static String makeWordsCapitalized(String str, Pattern wordPattern) {
        StringBuffer sb = new StringBuffer();
        Matcher wordMatcher = wordPattern.matcher(str);
        while (wordMatcher.find()) {
            String oldWord = wordMatcher.group();
            StringBuilder newWord = new StringBuilder();
            int n = oldWord.length();
            for (int i = 0; i < n; ++i) {
                if (i == 0) {
                    newWord.append(Character.toUpperCase(oldWord.charAt(i)));
                    continue;
                }
                newWord.append(Character.toLowerCase(oldWord.charAt(i)));
            }
            wordMatcher.appendReplacement(sb, Matcher.quoteReplacement(newWord.toString()));
        }
        wordMatcher.appendTail(sb);
        return sb.toString();
    }

    public static void appendImmutableList(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        ilb.appendLineStart("");
        JavaGenerationUtils.appendImmutableListInline(ilb, typeParamSnippet, itemSnippets);
    }

    public static void appendImmutableListInline(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "ImmutableList." + typeParamSnippet + "of", itemSnippets);
    }

    public static void appendImmutableSet(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        ilb.appendLineStart("");
        JavaGenerationUtils.appendImmutableSetInline(ilb, typeParamSnippet, itemSnippets);
    }

    public static void appendImmutableSetInline(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        JavaGenerationUtils.appendFunctionCallWithParamsOnNewLines(ilb, "ImmutableSet." + typeParamSnippet + "of", itemSnippets);
    }

    public static void appendImmutableMap(IndentedLinesBuilder ilb, String typeParamSnippet, Map<String, String> entrySnippetPairs) {
        if (entrySnippetPairs.isEmpty()) {
            ilb.appendLineStart("ImmutableMap.", typeParamSnippet, "of()");
        } else {
            ilb.appendLine("ImmutableMap.", typeParamSnippet, "builder()");
            ilb.increaseIndent(2);
            for (Map.Entry<String, String> entrySnippetPair : entrySnippetPairs.entrySet()) {
                ilb.appendLine(".put(", entrySnippetPair.getKey(), ", ", entrySnippetPair.getValue(), ")");
            }
            ilb.appendLineStart(".build()");
            ilb.decreaseIndent(2);
        }
    }

    private static void appendFunctionCallWithParamsOnNewLines(IndentedLinesBuilder ilb, String functionCallSnippet, Collection<String> params) {
        if (params.isEmpty()) {
            ilb.appendParts(functionCallSnippet, "()");
            return;
        }
        ilb.appendLineEnd(functionCallSnippet, "(");
        ilb.increaseIndent(2);
        boolean isFirst = true;
        for (String param : params) {
            if (isFirst) {
                isFirst = false;
            } else {
                ilb.appendLineEnd(",");
            }
            ilb.appendLineStart(param);
        }
        ilb.append(")");
        ilb.decreaseIndent(2);
    }
}

