/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.auto.value.AutoValue;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.internal.AutoValue_SoySimpleScope_Data;
import com.google.template.soy.shared.internal.SoyScopedData;
import java.util.ArrayDeque;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class SoySimpleScope
implements SoyScopedData,
SoyScopedData.Enterable {
    private static final ThreadLocal<ArrayDeque<Data>> scopedValuesTl = new ThreadLocal();

    @Override
    @CheckReturnValue
    public InScope enter(@Nullable SoyMsgBundle msgBundle) {
        return this.enter(msgBundle, null);
    }

    @Override
    @CheckReturnValue
    public InScope enter(@Nullable SoyMsgBundle msgBundle, @Nullable BidiGlobalDir bidiGlobalDir) {
        return this.enter(bidiGlobalDir == null ? BidiGlobalDir.forStaticIsRtl(msgBundle == null ? false : msgBundle.isRtl()) : bidiGlobalDir, msgBundle != null ? msgBundle.getLocaleString() : null);
    }

    @Override
    @CheckReturnValue
    public InScope enter(BidiGlobalDir bidiGlobalDir, @Nullable String locale) {
        ArrayDeque<Data> stack = scopedValuesTl.get();
        if (stack == null) {
            stack = new ArrayDeque();
            scopedValuesTl.set(stack);
        }
        Data data = Data.create(locale, bidiGlobalDir);
        stack.push(data);
        return new InScope(data, stack);
    }

    @Override
    public SoyScopedData.Enterable enterable() {
        return this;
    }

    private Data getScopedData() {
        ArrayDeque<Data> arrayDeque = scopedValuesTl.get();
        if (arrayDeque == null || arrayDeque.isEmpty()) {
            throw new IllegalStateException("Cannot access scoped data outside of a scoping block");
        }
        return arrayDeque.peek();
    }

    @Override
    @Nullable
    public String getLocale() {
        return this.getScopedData().locale();
    }

    @Override
    public BidiGlobalDir getBidiGlobalDir() {
        return this.getScopedData().bidiGlobalDir();
    }

    @Immutable
    @AutoValue
    static abstract class Data {
        Data() {
        }

        @Nullable
        abstract String locale();

        abstract BidiGlobalDir bidiGlobalDir();

        static Data create(@Nullable String locale, BidiGlobalDir bidiGlobalDir) {
            return new AutoValue_SoySimpleScope_Data(locale, bidiGlobalDir);
        }
    }

    private static final class InScope
    implements SoyScopedData.InScope {
        private boolean isClosed;
        private final Thread openThread = Thread.currentThread();
        private final ArrayDeque<Data> deque;
        private final Data data;

        InScope(Data data, ArrayDeque<Data> deque) {
            this.deque = deque;
            this.data = data;
        }

        @Override
        @Nullable
        public String getLocale() {
            return this.data.locale();
        }

        @Override
        public BidiGlobalDir getBidiGlobalDir() {
            return this.data.bidiGlobalDir();
        }

        @Override
        public void close() {
            this.checkOpenAndOnCorrectThread();
            this.isClosed = true;
            this.deque.pop();
        }

        private void checkOpenAndOnCorrectThread() {
            if (this.isClosed) {
                throw new IllegalStateException("called close() more than once!");
            }
            if (Thread.currentThread() != this.openThread) {
                throw new IllegalStateException("cannot move the scope to another thread");
            }
        }
    }
}

