/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.template.soy.basicdirectives.BasicDirectives;
import com.google.template.soy.basicfunctions.BasicFunctions;
import com.google.template.soy.bididirectives.BidiDirectives;
import com.google.template.soy.bidifunctions.BidiFunctions;
import com.google.template.soy.coredirectives.CoreDirectives;
import com.google.template.soy.i18ndirectives.I18nFunctions;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Map;

public final class InternalPlugins {
    private InternalPlugins() {
    }

    public static ImmutableMap<String, SoyFunction> internalLegacyFunctionMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String builtinFunctionName : BuiltinFunction.names()) {
            builder.put((Object)builtinFunctionName, (Object)BuiltinFunction.forFunctionName(builtinFunctionName));
        }
        return builder.build();
    }

    public static ImmutableMap<String, SoyFunction> fromLegacyFunctions(Iterable<? extends SoyFunction> functions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SoyFunction soyFunction : functions) {
            builder.put((Object)soyFunction.getName(), (Object)soyFunction);
        }
        return builder.build();
    }

    public static ImmutableMap<String, SoySourceFunction> internalFunctionMap() {
        return InternalPlugins.fromFunctions(Iterables.concat(BasicFunctions.functions(), BidiFunctions.functions(), I18nFunctions.functions()));
    }

    public static ImmutableMap<String, SoySourceFunction> internalAliasedDirectivesMap() {
        return (ImmutableMap)InternalPlugins.internalFunctionMap().entrySet().stream().filter(e -> ((SoySourceFunction)e.getValue()).getClass().getAnnotation(SoyFunctionSignature.class).callableAsDeprecatedPrintDirective()).collect(ImmutableMap.toImmutableMap(e -> "|" + (String)e.getKey(), Map.Entry::getValue));
    }

    public static ImmutableMap<String, SoySourceFunction> fromFunctions(Iterable<? extends SoySourceFunction> functions) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SoySourceFunction soySourceFunction : functions) {
            SoyFunctionSignature sig = soySourceFunction.getClass().getAnnotation(SoyFunctionSignature.class);
            Preconditions.checkState((sig != null ? 1 : 0) != 0, (String)"Missing @SoyFunctionSignature on %s", soySourceFunction.getClass());
            builder.put((Object)sig.name(), (Object)soySourceFunction);
        }
        return builder.build();
    }

    public static ImmutableMap<String, SoyPrintDirective> internalDirectiveMap(SoyScopedData soyScopedData) {
        Supplier bidiProvider = soyScopedData::getBidiGlobalDir;
        return InternalPlugins.fromDirectives(Iterables.concat(CoreDirectives.directives(), BasicDirectives.directives(), BidiDirectives.directives((Supplier<BidiGlobalDir>)bidiProvider)));
    }

    public static ImmutableMap<String, SoyPrintDirective> fromDirectives(Iterable<? extends SoyPrintDirective> directives) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (SoyPrintDirective soyPrintDirective : directives) {
            builder.put((Object)soyPrintDirective.getName(), (Object)soyPrintDirective);
        }
        return builder.build();
    }
}

