/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class PySrcMain {
    private static final SoyErrorKind DUPLICATE_NAMESPACE_ERROR = SoyErrorKind.of("Multiple files are providing the same namespace: {0}. Soy namespaces must be unique.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyScopedData.Enterable apiCallScope;

    public PySrcMain(SoyScopedData.Enterable apiCallScope) {
        this.apiCallScope = apiCallScope;
    }

    private List<String> genPySrc(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest, ErrorReporter errorReporter) {
        BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromPyOptions(pySrcOptions.getBidiIsRtlFn());
        try (SoyScopedData.InScope inScope = this.apiCallScope.enter(null, bidiGlobalDir);){
            List<String> list = PySrcMain.createVisitor(pySrcOptions, inScope.getBidiGlobalDir(), errorReporter, currentManifest).gen(soyTree, errorReporter);
            return list;
        }
    }

    public void genPyFiles(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, String outputPathFormat, ErrorReporter errorReporter) throws IOException {
        ImmutableList srcsToCompile = ImmutableList.copyOf(soyTree.getChildren());
        List<String> soyNamespaces = this.getSoyNamespaces(soyTree);
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, (ImmutableList<SoyFileNode>)srcsToCompile);
        ImmutableMap<String, String> manifest = PySrcMain.generateManifest(soyNamespaces, outputs, errorReporter);
        List<String> pyFileContents = this.genPySrc(soyTree, pySrcOptions, manifest, errorReporter);
        if (srcsToCompile.size() != pyFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), pyFileContents.size()));
        }
        for (String outputFilePath : outputs.keySet()) {
            BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    out.write(pyFileContents.get(inputFileIndex));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                PySrcMain.$closeResource(throwable, out);
            }
        }
        if (pySrcOptions.namespaceManifestFile() != null) {
            try (BufferedWriter out = Files.newWriter((File)new File(pySrcOptions.namespaceManifestFile()), (Charset)StandardCharsets.UTF_8);){
                for (String namespace : manifest.keySet()) {
                    out.write(String.format("%s=%s\n", namespace, manifest.get((Object)namespace)));
                }
            }
        }
    }

    private static ImmutableMap<String, String> generateManifest(List<String> soyNamespaces, Multimap<String, Integer> outputs, ErrorReporter errorReporter) {
        HashMap<String, String> manifest = new HashMap<String, String>();
        for (String outputFilePath : outputs.keySet()) {
            Iterator iterator = outputs.get((Object)outputFilePath).iterator();
            while (iterator.hasNext()) {
                int inputFileIndex = (Integer)iterator.next();
                String pythonPath = outputFilePath.replace(".py", "").replace('/', '.');
                String namespace = soyNamespaces.get(inputFileIndex);
                if (manifest.containsKey(namespace)) {
                    errorReporter.report(SourceLocation.UNKNOWN, DUPLICATE_NAMESPACE_ERROR, namespace);
                }
                manifest.put(namespace, pythonPath);
            }
        }
        return ImmutableMap.copyOf(manifest);
    }

    private List<String> getSoyNamespaces(SoyFileSetNode soyTree) {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            namespaces.add(soyFile.getNamespace());
        }
        return namespaces;
    }

    @VisibleForTesting
    static GenPyCodeVisitor createVisitor(SoyPySrcOptions pySrcOptions, BidiGlobalDir bidiGlobalDir, ErrorReporter errorReporter, ImmutableMap<String, String> currentManifest) {
        GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsFactory;
        final IsComputableAsPyExprVisitor isComputableAsPyExprs = new IsComputableAsPyExprVisitor();
        final PythonValueFactoryImpl pluginValueFactory = new PythonValueFactoryImpl(errorReporter, bidiGlobalDir);
        class PyCallExprVisitorSupplier
        implements Supplier<GenPyCallExprVisitor> {
            GenPyExprsVisitor.GenPyExprsVisitorFactory factory;

            PyCallExprVisitorSupplier() {
            }

            public GenPyCallExprVisitor get() {
                return new GenPyCallExprVisitor(isComputableAsPyExprs, pluginValueFactory, (GenPyExprsVisitor.GenPyExprsVisitorFactory)Preconditions.checkNotNull((Object)this.factory));
            }
        }
        PyCallExprVisitorSupplier provider = new PyCallExprVisitorSupplier();
        provider.factory = genPyExprsFactory = new GenPyExprsVisitor.GenPyExprsVisitorFactory(isComputableAsPyExprs, pluginValueFactory, provider);
        return new GenPyCodeVisitor(pySrcOptions, currentManifest, isComputableAsPyExprs, genPyExprsFactory, provider.get(), pluginValueFactory);
    }
}

