/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.restricted;

import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public abstract class JavaValueFactory {
    public abstract JavaValue callStaticMethod(Method var1, JavaValue ... var2);

    public abstract JavaValue callStaticMethod(MethodSignature var1, JavaValue ... var2);

    public abstract JavaValue callInstanceMethod(Method var1, JavaValue ... var2);

    public abstract JavaValue callInstanceMethod(MethodSignature var1, JavaValue ... var2);

    public abstract JavaValue listOf(List<JavaValue> var1);

    public abstract JavaValue constant(double var1);

    public abstract JavaValue constant(long var1);

    public abstract JavaValue constant(String var1);

    public abstract JavaValue constant(boolean var1);

    public abstract JavaValue constantNull();

    public static Method createMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        try {
            return clazz.getMethod(methodName, params);
        }
        catch (NoSuchMethodException e) {
            if (params.length == 0) {
                throw new IllegalArgumentException(String.format("No such public method: %s.%s (with no parameters)", clazz.getName(), methodName));
            }
            throw new IllegalArgumentException(String.format("No such public method: %s.%s(%s)", clazz.getName(), methodName, Arrays.stream(params).map(Class::getName).collect(Collectors.joining(","))));
        }
        catch (SecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

