/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.plugin.java.internal.AutoValue_ValidatorFactory_ValidationResult;
import com.google.template.soy.plugin.java.internal.ValidatorErrorReporter;
import com.google.template.soy.plugin.java.internal.ValidatorValue;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.StringType;
import com.google.template.soy.types.UnionType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

final class ValidatorFactory
extends JavaValueFactory {
    private static final ImmutableSet<Class<?>> UNKNOWN_TYPES = ImmutableSet.of(SoyValue.class);
    private static final ImmutableSet<Class<?>> SANITIZED_TYPES = ImmutableSet.of(SoyValue.class, SanitizedContent.class, String.class);
    private static final ImmutableSet<Class<?>> BOOL_TYPES = ImmutableSet.of(SoyValue.class, Boolean.TYPE, BooleanData.class);
    private static final ImmutableSet<Class<?>> FLOAT_TYPES = ImmutableSet.of(SoyValue.class, Double.TYPE, FloatData.class, NumberData.class);
    private static final ImmutableSet<Class<?>> NUMBER_TYPES = ImmutableSet.of(SoyValue.class, Double.TYPE, NumberData.class);
    private static final ImmutableSet<Class<?>> INT_TYPES = ImmutableSet.of(SoyValue.class, Long.TYPE, IntegerData.class, NumberData.class, Integer.TYPE, Double.TYPE, (Object[])new Class[0]);
    private static final ImmutableSet<Class<?>> LEGACY_OBJECT_MAP_TYPES = ImmutableSet.of(SoyValue.class, SoyLegacyObjectMap.class, SoyDict.class);
    private static final ImmutableSet<Class<?>> LIST_TYPES = ImmutableSet.of(SoyValue.class, SoyList.class, List.class);
    private static final ImmutableSet<Class<?>> MAP_TYPES = ImmutableSet.of(SoyValue.class, SoyMap.class, SoyDict.class, SoyRecord.class);
    private static final ImmutableSet<Class<?>> RECORD_TYPES = ImmutableSet.of(SoyValue.class, SoyRecord.class);
    private static final ImmutableSet<Class<?>> STRING_TYPES = ImmutableSet.of(SoyValue.class, String.class, StringData.class);
    private static final ImmutableSet<Class<?>> NULL_TYPES = ImmutableSet.of(SoyValue.class, NullData.class);
    private static final ImmutableSet<Class<?>> PROTO_TYPES = ImmutableSet.of(SoyValue.class, Message.class, SoyProtoValue.class);
    private static final ImmutableSet<Class<?>> PROTO_ENUM_TYPES = ImmutableSet.of(SoyValue.class, Integer.TYPE);
    private final ValidatorErrorReporter reporter;

    ValidatorFactory(ValidatorErrorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public ValidatorValue callStaticMethod(Method method, JavaValue ... params) {
        if (method == null) {
            this.reporter.nullMethod("callStaticMethod");
            return this.errorValue();
        }
        MethodSignature methodSignature = ValidatorFactory.toMethodSignature(method);
        if (!Modifier.isStatic(method.getModifiers())) {
            this.reporter.staticMismatch(methodSignature, false);
            return this.errorValue();
        }
        if (!this.validateParams(methodSignature, params, "callStaticMethod")) {
            return this.errorValue();
        }
        return ValidatorValue.forMethodReturnType(methodSignature, this.reporter);
    }

    @Override
    public JavaValue callStaticMethod(MethodSignature methodSignature, JavaValue ... params) {
        if (methodSignature == null) {
            this.reporter.nullMethod("callStaticMethod");
            return this.errorValue();
        }
        if (!this.validateParams(methodSignature, params, "callStaticMethod")) {
            return this.errorValue();
        }
        return ValidatorValue.forMethodReturnType(methodSignature, this.reporter);
    }

    @Override
    public ValidatorValue callInstanceMethod(Method method, JavaValue ... params) {
        if (method == null) {
            this.reporter.nullMethod("callInstanceMethod");
            return this.errorValue();
        }
        MethodSignature methodSignature = ValidatorFactory.toMethodSignature(method);
        if (Modifier.isStatic(method.getModifiers())) {
            this.reporter.staticMismatch(methodSignature, true);
            return this.errorValue();
        }
        return ValidatorValue.forMethodReturnType(methodSignature, this.reporter);
    }

    @Override
    public ValidatorValue callInstanceMethod(MethodSignature methodSignature, JavaValue ... params) {
        if (methodSignature == null) {
            this.reporter.nullMethod("callInstanceMethod");
            return this.errorValue();
        }
        if (!this.validateParams(methodSignature, params, "callInstanceMethod")) {
            return this.errorValue();
        }
        return ValidatorValue.forMethodReturnType(methodSignature, this.reporter);
    }

    private static MethodSignature toMethodSignature(Method method) {
        return MethodSignature.create(method.getDeclaringClass().getName(), method.getName(), method.getReturnType(), method.getParameterTypes());
    }

    @Override
    public ValidatorValue listOf(List<JavaValue> args) {
        return ValidatorValue.forClazz(List.class, this.reporter);
    }

    @Override
    public ValidatorValue constant(boolean value) {
        return ValidatorValue.forSoyType(BoolType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue constant(double value) {
        return ValidatorValue.forSoyType(FloatType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue constant(long value) {
        return ValidatorValue.forSoyType(IntType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue constant(String value) {
        return ValidatorValue.forSoyType(StringType.getInstance(), this.reporter);
    }

    @Override
    public ValidatorValue constantNull() {
        return ValidatorValue.forConstantNull(this.reporter);
    }

    private boolean validateParams(MethodSignature method, JavaValue[] userParams, String callerMethodName) {
        if (userParams == null) {
            this.reporter.nullParamArray(method, callerMethodName);
            return false;
        }
        ImmutableList<Class<?>> methodParams = method.arguments();
        if (methodParams.size() != userParams.length) {
            this.reporter.invalidParameterLength(method, userParams);
            return false;
        }
        block4: for (int i = 0; i < userParams.length; ++i) {
            Class methodParam = (Class)methodParams.get(i);
            if (userParams[i] == null) {
                this.reporter.nullParam(method, i + 1, methodParam);
                continue;
            }
            ValidatorValue userValue = (ValidatorValue)userParams[i];
            switch (userValue.valueType().type()) {
                case CLAZZ: {
                    if (methodParam.isAssignableFrom(userValue.valueType().clazz())) continue block4;
                    this.reporter.invalidParameterType(method, i, methodParam, userValue.valueType().clazz());
                    continue block4;
                }
                case CONSTANT_NULL: 
                case SOY_TYPE: {
                    this.validateParameter(method, i, methodParam, userValue);
                }
            }
        }
        return true;
    }

    private void validateParameter(MethodSignature method, int paramIdx, Class<?> expectedParamType, ValidatorValue value) {
        ValidationResult validationResult = value.isConstantNull() ? (Primitives.allPrimitiveTypes().contains(expectedParamType) ? ValidationResult.forNullToPrimitive(NullType.getInstance()) : ValidationResult.valid()) : this.isValidClassForType(expectedParamType, value.valueType().soyType());
        if (validationResult.result() != ValidationResult.Result.VALID) {
            this.reporter.invalidParameterType(method, paramIdx, expectedParamType, validationResult);
        }
    }

    private ValidationResult isValidClassForType(Class<?> clazz, SoyType type) {
        if (SoyTypes.isNullable(type) && Primitives.allPrimitiveTypes().contains(clazz)) {
            return ValidationResult.forNullToPrimitive(type);
        }
        if (SoyTypes.isKindOrUnionOfKind(type, SoyType.Kind.VE) || SoyTypes.isKindOrUnionOfKind(type, SoyType.Kind.VE_DATA)) {
            return ValidationResult.ve(type);
        }
        ImmutableSet<Class<?>> expectedClasses = null;
        Descriptors.Descriptor expectedDescriptor = null;
        type = SoyTypes.tryRemoveNull(type);
        switch (type.getKind()) {
            case ANY: 
            case UNKNOWN: {
                expectedClasses = UNKNOWN_TYPES;
                break;
            }
            case ATTRIBUTES: 
            case CSS: 
            case HTML: 
            case URI: 
            case TRUSTED_RESOURCE_URI: 
            case JS: {
                expectedClasses = SANITIZED_TYPES;
                break;
            }
            case BOOL: {
                expectedClasses = BOOL_TYPES;
                break;
            }
            case FLOAT: {
                expectedClasses = FLOAT_TYPES;
                break;
            }
            case INT: {
                expectedClasses = INT_TYPES;
                break;
            }
            case LEGACY_OBJECT_MAP: {
                expectedClasses = LEGACY_OBJECT_MAP_TYPES;
                break;
            }
            case LIST: {
                expectedClasses = LIST_TYPES;
                break;
            }
            case MAP: {
                expectedClasses = MAP_TYPES;
                break;
            }
            case RECORD: {
                expectedClasses = RECORD_TYPES;
                break;
            }
            case STRING: {
                expectedClasses = STRING_TYPES;
                break;
            }
            case NULL: {
                expectedClasses = NULL_TYPES;
                break;
            }
            case PROTO: {
                expectedClasses = PROTO_TYPES;
                expectedDescriptor = ((SoyProtoType)type).getDescriptor();
                break;
            }
            case PROTO_ENUM: {
                expectedClasses = PROTO_ENUM_TYPES;
                expectedDescriptor = ((SoyProtoEnumType)type).getDescriptor();
                break;
            }
            case UNION: {
                if (type.equals(SoyTypes.NUMBER_TYPE)) {
                    expectedClasses = NUMBER_TYPES;
                    break;
                }
                ValidationResult result = ValidationResult.valid();
                for (SoyType member : ((UnionType)type).getMembers()) {
                    result.merge(this.isValidClassForType(clazz, member));
                }
                return result;
            }
            case VE: 
            case VE_DATA: {
                throw new IllegalStateException("This should have been caught above");
            }
            case ERROR: {
                throw new IllegalStateException("Cannot have error type from function signature");
            }
        }
        Preconditions.checkState((expectedClasses != null ? 1 : 0) != 0, (Object)"expectedClass not set!");
        if (expectedClasses.contains(clazz)) {
            return ValidationResult.valid();
        }
        ImmutableSet expectedDescriptorNames = ImmutableSet.of();
        if (expectedDescriptor instanceof Descriptors.Descriptor) {
            expectedDescriptorNames = ImmutableSet.of((Object)JavaQualifiedNames.getClassName(expectedDescriptor));
            if (this.matchesProtoDescriptor(Message.class, clazz, (Descriptors.GenericDescriptor)expectedDescriptor)) {
                return ValidationResult.valid();
            }
        }
        if (expectedDescriptor instanceof Descriptors.EnumDescriptor) {
            expectedDescriptorNames = ImmutableSet.of((Object)JavaQualifiedNames.getClassName((Descriptors.EnumDescriptor)expectedDescriptor));
            if (clazz.isEnum() && this.matchesProtoDescriptor(ProtocolMessageEnum.class, clazz, (Descriptors.GenericDescriptor)expectedDescriptor)) {
                return ValidationResult.valid();
            }
        }
        return ValidationResult.invalid((Set)Stream.concat(expectedClasses.stream().map(Class::getName), expectedDescriptorNames.stream()).collect(ImmutableSet.toImmutableSet()));
    }

    private boolean matchesProtoDescriptor(Class<?> expectedSupertype, Class<?> actualParamClass, Descriptors.GenericDescriptor expectedDescriptor) {
        if (!expectedSupertype.isAssignableFrom(actualParamClass)) {
            return false;
        }
        return ValidatorFactory.nameFromDescriptor(actualParamClass).orElse("").equals(expectedDescriptor.getFullName());
    }

    static Optional<String> nameFromDescriptor(Class<?> protoType) {
        Descriptors.GenericDescriptor actualDescriptor;
        try {
            actualDescriptor = (Descriptors.GenericDescriptor)protoType.getDeclaredMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException roe) {
            return Optional.empty();
        }
        return Optional.of(actualDescriptor.getFullName());
    }

    private ValidatorValue errorValue() {
        return ValidatorValue.forError(BoolType.getInstance(), this.reporter);
    }

    @AutoValue
    static abstract class ValidationResult {
        ValidationResult() {
        }

        abstract Result result();

        @Nullable
        abstract SoyType allowedSoyType();

        abstract ImmutableSet<String> allowedTypes();

        ValidationResult merge(ValidationResult other) {
            if (other.result() == Result.VALID) {
                return this;
            }
            switch (this.result()) {
                case VALID: {
                    return other;
                }
                case NULL_TO_PRIMITIVE: 
                case VE: {
                    throw new IllegalStateException("unexpected merge " + this + " w/ " + other);
                }
                case INVALID: {
                    return ValidationResult.invalid((Set<String>)Sets.intersection(this.allowedTypes(), other.allowedTypes()));
                }
            }
            throw new AssertionError((Object)"above switch is exhaustive");
        }

        static ValidationResult valid() {
            return new AutoValue_ValidatorFactory_ValidationResult(Result.VALID, null, (ImmutableSet<String>)ImmutableSet.of());
        }

        static ValidationResult forNullToPrimitive(SoyType type) {
            return new AutoValue_ValidatorFactory_ValidationResult(Result.NULL_TO_PRIMITIVE, type, (ImmutableSet<String>)ImmutableSet.of());
        }

        static ValidationResult invalid(Set<String> allowedTypes) {
            return new AutoValue_ValidatorFactory_ValidationResult(Result.INVALID, null, (ImmutableSet<String>)ImmutableSet.copyOf(allowedTypes));
        }

        static ValidationResult ve(SoyType type) {
            return new AutoValue_ValidatorFactory_ValidationResult(Result.VE, type, (ImmutableSet<String>)ImmutableSet.of());
        }

        static enum Result {
            VALID,
            NULL_TO_PRIMITIVE,
            INVALID,
            VE;

        }
    }
}

