/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.plugin.java.internal.AutoValue_PluginAnalyzer_PluginMetadata;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PluginAnalyzer {
    private PluginAnalyzer() {
    }

    public static PluginMetadata analyze(SoyJavaSourceFunction ssf) {
        FinderFactory factory = new FinderFactory();
        FinderContext context = new FinderContext();
        SoyFunctionSignature fnSig = ssf.getClass().getAnnotation(SoyFunctionSignature.class);
        for (Signature sig : fnSig.value()) {
            List<JavaValue> args = Collections.nCopies(sig.parameterTypes().length, FinderValue.INSTANCE);
            ssf.applyForJavaSource(factory, args, context);
        }
        return PluginMetadata.create(context.accessed, factory.instances, factory.instanceMethodSigs, factory.staticMethodSigs);
    }

    public static PluginMetadata analyze(SoyJavaSourceFunction ssf, int argCount) {
        FinderFactory factory = new FinderFactory();
        FinderContext context = new FinderContext();
        List<JavaValue> args = Collections.nCopies(argCount, FinderValue.INSTANCE);
        ssf.applyForJavaSource(factory, args, context);
        return PluginMetadata.create(context.accessed, factory.instances, factory.instanceMethodSigs, factory.staticMethodSigs);
    }

    private static final class FinderValue
    implements JavaValue {
        static final FinderValue INSTANCE = new FinderValue();

        private FinderValue() {
        }

        @Override
        public JavaValue isNonNull() {
            return this;
        }

        @Override
        public JavaValue isNull() {
            return this;
        }

        @Override
        public JavaValue asSoyBoolean() {
            return this;
        }

        @Override
        public JavaValue asSoyString() {
            return this;
        }

        @Override
        public JavaValue asSoyInt() {
            return this;
        }

        @Override
        public JavaValue asSoyFloat() {
            return this;
        }

        @Override
        public JavaValue coerceToSoyBoolean() {
            return this;
        }

        @Override
        public JavaValue coerceToSoyString() {
            return this;
        }
    }

    private static final class FinderContext
    implements JavaPluginContext {
        boolean accessed;

        private FinderContext() {
        }

        @Override
        public JavaValue getBidiDir() {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue getULocale() {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue getAllRequiredCssNamespaces(JavaValue template) {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue getRenderedCssNamespaces() {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }
    }

    private static class FinderFactory
    extends JavaValueFactory {
        Set<String> instances = new LinkedHashSet<String>();
        Set<MethodSignature> instanceMethodSigs = new LinkedHashSet<MethodSignature>();
        Set<MethodSignature> staticMethodSigs = new LinkedHashSet<MethodSignature>();

        private FinderFactory() {
        }

        @Override
        public JavaValue callInstanceMethod(MethodSignature methodSig, JavaValue ... params) {
            if (methodSig != null) {
                this.instances.add(methodSig.fullyQualifiedClassName());
                this.instanceMethodSigs.add(methodSig);
            }
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue callInstanceMethod(Method method, JavaValue ... params) {
            if (method != null) {
                this.instances.add(method.getDeclaringClass().getName());
            }
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue callStaticMethod(MethodSignature methodSig, JavaValue ... params) {
            if (methodSig != null) {
                this.staticMethodSigs.add(methodSig);
            }
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue callStaticMethod(Method method, JavaValue ... params) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue listOf(List<JavaValue> args) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(boolean value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(double value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(long value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(String value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constantNull() {
            return FinderValue.INSTANCE;
        }
    }

    @AutoValue
    public static abstract class PluginMetadata {
        static PluginMetadata create(boolean accessesContext, Iterable<String> pluginInstances, Iterable<MethodSignature> instanceMethodSignatures, Iterable<MethodSignature> staticMethodSignatures) {
            return new AutoValue_PluginAnalyzer_PluginMetadata(accessesContext, (ImmutableSet<String>)ImmutableSet.copyOf(pluginInstances), (ImmutableSet<MethodSignature>)ImmutableSet.copyOf(instanceMethodSignatures), (ImmutableSet<MethodSignature>)ImmutableSet.copyOf(staticMethodSignatures));
        }

        public abstract boolean accessesContext();

        public abstract ImmutableSet<String> pluginInstanceNames();

        public abstract ImmutableSet<MethodSignature> instanceMethodSignatures();

        public abstract ImmutableSet<MethodSignature> staticMethodSignatures();
    }
}

