/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.plugin.java.internal.AutoValue_CompiledJarsPluginSignatureReader_PartialSignature;
import com.google.template.soy.plugin.java.internal.PluginSignatureReader;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class CompiledJarsPluginSignatureReader
implements PluginSignatureReader {
    private static final Logger logger = Logger.getLogger(CompiledJarsPluginSignatureReader.class.getName());
    private final ImmutableList<File> pluginRuntimeJars;
    private final ConcurrentMap<String, ClassSignatures> readMethodsPerClass;

    CompiledJarsPluginSignatureReader(List<File> pluginRuntimeJars) {
        this.pluginRuntimeJars = ImmutableList.copyOf(pluginRuntimeJars);
        this.readMethodsPerClass = new ConcurrentHashMap<String, ClassSignatures>();
    }

    @Override
    @Nullable
    public PluginSignatureReader.ReadMethodData findMethod(MethodSignature methodSignature) {
        String className = methodSignature.fullyQualifiedClassName();
        ClassSignatures readMethods = this.readMethodsPerClass.computeIfAbsent(className, k -> this.index((String)k));
        MethodSignatures methodsForSig = readMethods.forPartial(PartialSignature.create(methodSignature));
        if (methodsForSig.hasReturnType(methodSignature.returnType().getName())) {
            return methodsForSig.forReturnType(methodSignature.returnType().getName());
        }
        if (!methodsForSig.isEmpty()) {
            return methodsForSig.allSignatures().iterator().next();
        }
        return null;
    }

    /*
     * Loose catch block
     */
    private ClassSignatures index(String runtimeClassName) {
        TypeInfo owner = TypeInfo.create(runtimeClassName);
        for (File f : this.pluginRuntimeJars) {
            ClassSignatures classSignatures;
            Throwable throwable;
            InputStream in;
            Throwable throwable2;
            ZipFile jar;
            block16: {
                ZipEntry entry;
                block15: {
                    jar = new ZipFile(f);
                    throwable2 = null;
                    entry = jar.getEntry(owner.internalName() + ".class");
                    if (entry != null) break block15;
                    CompiledJarsPluginSignatureReader.$closeResource(throwable2, jar);
                    continue;
                }
                in = jar.getInputStream(entry);
                throwable = null;
                ClassReader reader = new ClassReader(in);
                Visitor visitor = new Visitor();
                reader.accept((ClassVisitor)visitor, 7);
                classSignatures = visitor.signatures.build();
                if (in == null) break block16;
                CompiledJarsPluginSignatureReader.$closeResource(throwable, in);
            }
            CompiledJarsPluginSignatureReader.$closeResource(throwable2, jar);
            return classSignatures;
            {
                catch (Throwable throwable3) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable3;
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    if (in != null) {
                                        CompiledJarsPluginSignatureReader.$closeResource(throwable, in);
                                    }
                                    throw throwable4;
                                }
                            }
                            catch (Throwable throwable5) {
                                throwable2 = throwable5;
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable6) {
                            CompiledJarsPluginSignatureReader.$closeResource(throwable2, jar);
                            throw throwable6;
                        }
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        logger.log(Level.WARNING, e, () -> "Unable to read class: " + runtimeClassName);
                    }
                }
            }
        }
        return CompiledJarsPluginSignatureReader.indexReflectively(runtimeClassName);
    }

    private static ClassSignatures indexReflectively(String runtimeClassName) {
        try {
            Class<?> clazz = Class.forName(runtimeClassName);
            Method[] declaredMethods = clazz.getDeclaredMethods();
            ClassSignatures.Builder signatures = new ClassSignatures.Builder();
            for (Method m : declaredMethods) {
                if (!Modifier.isPublic(m.getModifiers())) continue;
                signatures.add(PartialSignature.create(m), PluginSignatureReader.ReadMethodData.create(!Modifier.isStatic(m.getModifiers()), clazz.isInterface(), m.getReturnType().getName()));
            }
            return signatures.build();
        }
        catch (ClassNotFoundException | SecurityException e) {
            return ClassSignatures.EMPTY;
        }
    }

    private static /* synthetic */ /* end resource */ void $closeResource(Throwable x0, AutoCloseable x1) {
        if (x0 != null) {
            try {
                x1.close();
            }
            catch (Throwable throwable) {
                x0.addSuppressed(throwable);
            }
        } else {
            x1.close();
        }
    }

    @AutoValue
    static abstract class PartialSignature {
        PartialSignature() {
        }

        abstract String methodName();

        abstract ImmutableList<String> arguments();

        static PartialSignature create(Method method) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(method.getName(), (ImmutableList<String>)((ImmutableList)Arrays.stream(method.getParameterTypes()).map(Class::getName).collect(ImmutableList.toImmutableList())));
        }

        static PartialSignature create(MethodSignature methodSignature) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(methodSignature.methodName(), (ImmutableList<String>)((ImmutableList)methodSignature.arguments().stream().map(Class::getName).collect(ImmutableList.toImmutableList())));
        }

        static PartialSignature create(String methodName, Type methodType) {
            return new AutoValue_CompiledJarsPluginSignatureReader_PartialSignature(methodName, (ImmutableList<String>)((ImmutableList)Arrays.stream(methodType.getArgumentTypes()).map(Type::getClassName).collect(ImmutableList.toImmutableList())));
        }
    }

    static class MethodSignatures {
        static final MethodSignatures EMPTY = new Builder().build();
        final ImmutableMap<String, PluginSignatureReader.ReadMethodData> signaturesPerReturnType;

        MethodSignatures(Builder builder) {
            this.signaturesPerReturnType = builder.signaturesBuilder.build();
        }

        Iterable<PluginSignatureReader.ReadMethodData> allSignatures() {
            return this.signaturesPerReturnType.values();
        }

        boolean isEmpty() {
            return this.signaturesPerReturnType.isEmpty();
        }

        PluginSignatureReader.ReadMethodData forReturnType(String type) {
            return (PluginSignatureReader.ReadMethodData)this.signaturesPerReturnType.get((Object)type);
        }

        boolean hasReturnType(String type) {
            return this.signaturesPerReturnType.containsKey((Object)type);
        }

        static class Builder {
            final ImmutableMap.Builder<String, PluginSignatureReader.ReadMethodData> signaturesBuilder = ImmutableMap.builder();

            Builder() {
            }

            void add(PluginSignatureReader.ReadMethodData data) {
                this.signaturesBuilder.put((Object)data.returnType(), (Object)data);
            }

            MethodSignatures build() {
                return new MethodSignatures(this);
            }
        }
    }

    static class ClassSignatures {
        static final ClassSignatures EMPTY = new Builder().build();
        final ImmutableMap<PartialSignature, MethodSignatures> methods;

        ClassSignatures(Builder builder) {
            this.methods = (ImmutableMap)builder.methodsBuilder.entrySet().stream().collect(ImmutableMap.toImmutableMap(e -> (PartialSignature)e.getKey(), e -> ((MethodSignatures.Builder)e.getValue()).build()));
        }

        MethodSignatures forPartial(PartialSignature partial) {
            return (MethodSignatures)this.methods.getOrDefault((Object)partial, (Object)MethodSignatures.EMPTY);
        }

        static class Builder {
            final Map<PartialSignature, MethodSignatures.Builder> methodsBuilder = new LinkedHashMap<PartialSignature, MethodSignatures.Builder>();

            Builder() {
            }

            void add(PartialSignature partialSig, PluginSignatureReader.ReadMethodData data) {
                this.methodsBuilder.computeIfAbsent(partialSig, k -> new MethodSignatures.Builder()).add(data);
            }

            ClassSignatures build() {
                return new ClassSignatures(this);
            }
        }
    }

    private static class Visitor
    extends ClassVisitor {
        final ClassSignatures.Builder signatures = new ClassSignatures.Builder();
        boolean classIsInterface;

        Visitor() {
            super(458752);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classIsInterface = Modifier.isInterface(access);
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            if (!Modifier.isPublic(access)) {
                return null;
            }
            Type methodType = Type.getMethodType((String)descriptor);
            this.signatures.add(PartialSignature.create(name, methodType), PluginSignatureReader.ReadMethodData.create(!Modifier.isStatic(access), this.classIsInterface, methodType.getReturnType().getClassName()));
            return null;
        }
    }
}

