/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;

final class ValidateSkipNodesPass
extends CompilerFilePass {
    private static final SoyErrorKind SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Skip element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    public ValidateSkipNodesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            int id = 0;
            for (SkipNode skipNode : SoyTreeUtils.getAllNodesOfType(template, SkipNode.class)) {
                HtmlOpenTagNode openTag = (HtmlOpenTagNode)skipNode.getParent();
                if (!openTag.isSelfClosing() && openTag.getTaggedPairs().size() > 1) {
                    this.errorReporter.report(openTag.getSourceLocation(), SOY_SKIP_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                    continue;
                }
                skipNode.setSkipId(template.getTemplateName() + "-" + id++);
            }
        }
    }
}

