/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class V1ExpressionPass
extends CompilerFilePass {
    private static final SoyErrorKind INCORRECT_V1_EXPRESSION_USE = SoyErrorKind.of("The ''v1Expression'' function can only be used in legacy JS only templates.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind USING_IJ_VARIABLE = SoyErrorKind.of("''v1Expression'' does not support using the ''$ij'' variable.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$([a-zA-Z_][a-zA-Z_0-9]*)");
    private final boolean allowV1Expression;
    private final ErrorReporter errorReporter;

    V1ExpressionPass(boolean allowV1Expression, ErrorReporter errorReporter) {
        this.allowV1Expression = allowV1Expression;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.V1_EXPRESSION)) {
            if (!this.allowV1Expression) {
                this.errorReporter.report(fn.getSourceLocation(), INCORRECT_V1_EXPRESSION_USE, new Object[0]);
            }
            ExprNode param = fn.getChild(0);
            SourceLocation paramLocation = param.getSourceLocation();
            String expression = param.toSourceString();
            Matcher matcher = VARIABLE_PATTERN.matcher(expression);
            while (matcher.find()) {
                SourceLocation varLocation = paramLocation.offsetStartCol(matcher.start()).offsetEndCol(matcher.end() - expression.length());
                if (matcher.group(1).equals("ij")) {
                    this.errorReporter.report(varLocation, USING_IJ_VARIABLE, new Object[0]);
                    continue;
                }
                fn.addChild(new VarRefNode(matcher.group(1), varLocation, null));
            }
        }
    }
}

