/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class UnknownJsGlobalPass
extends CompilerFilePass {
    private static final SoyErrorKind INCORRECT_UNKNOWN_JS_GLOBAL_USE = SoyErrorKind.of("The ''unknownJsGlobal'' function can only be used in legacy JS only templates.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_JS_GLOBAL_VALUE = SoyErrorKind.of("Parameters to ''unknownJsGlobal'' must be valid dotted identifiers.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    private final boolean allowFunction;

    UnknownJsGlobalPass(boolean allowFunction, ErrorReporter errorReporter) {
        this.allowFunction = allowFunction;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.UNKNOWN_JS_GLOBAL)) {
            String parameter;
            ExprNode child;
            if (!this.allowFunction) {
                this.errorReporter.report(fn.getSourceLocation(), INCORRECT_UNKNOWN_JS_GLOBAL_USE, new Object[0]);
            }
            if (fn.numChildren() != 1 || !((child = fn.getChild(0)) instanceof StringNode) || BaseUtils.isDottedIdentifier(parameter = ((StringNode)child).getValue())) continue;
            this.errorReporter.report(child.getSourceLocation(), INVALID_JS_GLOBAL_VALUE, new Object[0]);
        }
    }
}

