/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.List;
import java.util.Optional;

final class ResolvePluginsPass
extends CompilerFilePass {
    private static final SoyErrorKind NOT_FIRST_PRINT_DIRECTIVE = SoyErrorKind.of("Function ''{0}'' cannot be called as a print directive when preceded by print directive ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final PluginResolver resolver;
    private final SoyTypeRegistry typeRegistry;
    private final ErrorReporter errorReporter;

    ResolvePluginsPass(PluginResolver resolver, SoyTypeRegistry typeRegistry, ErrorReporter errorReporter) {
        this.resolver = resolver;
        this.typeRegistry = typeRegistry;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        String name;
        for (FunctionNode function : SoyTreeUtils.getAllNodesOfType(file, FunctionNode.class)) {
            String resolvedName;
            SoyType type;
            if (function.numChildren() == 0 && (type = this.typeRegistry.getType(resolvedName = file.resolveAlias(name = function.getFunctionName()))) != null && type.getKind() == SoyType.Kind.PROTO) {
                ProtoInitNode protoInit = new ProtoInitNode(resolvedName, (Iterable<Identifier>)ImmutableList.of(), function.getSourceLocation());
                function.getParent().replaceChild(function, protoInit);
                continue;
            }
            function.setSoyFunction(this.resolver.lookupSoyFunction(function.getFunctionName(), function.numChildren(), function.getSourceLocation()));
        }
        for (PrintDirectiveNode directiveNode : SoyTreeUtils.getAllNodesOfType(file, PrintDirectiveNode.class)) {
            name = directiveNode.getName();
            Optional<SoySourceFunction> aliasedFunction = this.resolver.getFunctionCallableAsPrintDirective(name, directiveNode.getSourceLocation());
            if (aliasedFunction.isPresent()) {
                this.rewritePrintDirectiveAsFunction(directiveNode, aliasedFunction.get());
                continue;
            }
            directiveNode.setPrintDirective(this.resolver.lookupPrintDirective(name, directiveNode.getExprList().size(), directiveNode.getSourceLocation()));
        }
    }

    private void rewritePrintDirectiveAsFunction(PrintDirectiveNode directiveNode, SoySourceFunction function) {
        PrintNode printNode = (PrintNode)directiveNode.getParent();
        String functionName = function.getClass().getAnnotation(SoyFunctionSignature.class).name();
        int directiveIndex = printNode.getChildIndex(directiveNode);
        if (directiveIndex != 0) {
            this.errorReporter.report(directiveNode.getSourceLocation(), NOT_FIRST_PRINT_DIRECTIVE, functionName, ((PrintDirectiveNode)printNode.getChild(directiveIndex - 1)).getName());
            return;
        }
        ExprRootNode originalExprRoot = printNode.getExpr();
        ExprNode originalExpr = originalExprRoot.getRoot();
        FunctionNode newExpr = new FunctionNode(Identifier.create(functionName, directiveNode.getNameLocation()), function, originalExpr.getSourceLocation().extend(directiveNode.getSourceLocation()));
        newExpr.addChild(originalExpr);
        newExpr.addChildren((List<? extends ExprNode>)directiveNode.getArgs());
        originalExprRoot.addChild(newExpr);
        printNode.removeChild(directiveIndex);
    }
}

