/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyDeprecated;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class PluginResolver {
    private static final SoyErrorKind UNKNOWN_PLUGIN = SoyErrorKind.of("Unknown {0} ''{1}''.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind DEPRECATED_PLUGIN = SoyErrorKind.of("{0} is deprecated: {1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION, SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind INCORRECT_NUM_ARGS = SoyErrorKind.of("{0} called with {1} arguments (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PLUGIN_NAME_NOT_ALLOWED = SoyErrorKind.of("Plugins named ''{0}'' are not allowed, since they conflict with Soy''s {0}() literal syntax.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DIFFERENT_IMPLS_REGISTERED = SoyErrorKind.of("Plugin named ''{0}'' has two different implementations registered: ''{1}'' and ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_FUNCTION_SIGNATURE = SoyErrorKind.of("Plugin class ''{0}'' has no @SoyFunctionSignature annotation. Classes implementing SoySourceFunction must be annotated with @SoyFunctionSignature.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MULTIPLE_PLUGIN_INSTANCES = SoyErrorKind.of("Plugin class ''{0}'' uses callInstanceMethod for methods on multiple classes {1}. SoyJavaSourceFunctions must only use a single class for callInstanceMethod.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FUNCTION_PRINT_DIRECTIVE_COLLISION = SoyErrorKind.of("Plugin ''{0}'' named ''{1}'' collides with print directive ''{2}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind FUNCTION_NOT_CALLABLE = SoyErrorKind.of("Function ''{0}'' cannot be called as a print directive.", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSet<String> COLLISION_WHITELIST = ImmutableSet.builder().build();
    private static final SoySourceFunction ERROR_PLACEHOLDER_FUNCTION = new SoySourceFunction(){};
    private final Mode mode;
    private final ImmutableMap<String, SoyPrintDirective> printDirectives;
    private final ImmutableMap<String, Object> functions;
    private final ErrorReporter reporter;

    public static PluginResolver nullResolver(Mode mode, ErrorReporter reporter) {
        return new PluginResolver(mode, (ImmutableMap<String, SoyPrintDirective>)ImmutableMap.of(), (ImmutableMap<String, SoyFunction>)ImmutableMap.of(), (ImmutableMap<String, SoySourceFunction>)ImmutableMap.of(), reporter);
    }

    public PluginResolver(Mode mode, ImmutableMap<String, SoyPrintDirective> soyPrintDirectives, ImmutableMap<String, SoyFunction> soyFunctions, ImmutableMap<String, SoySourceFunction> sourceFunctions, ErrorReporter reporter) {
        this.mode = (Mode)((Object)Preconditions.checkNotNull((Object)((Object)mode)));
        this.printDirectives = (ImmutableMap)Preconditions.checkNotNull(soyPrintDirectives);
        this.reporter = (ErrorReporter)Preconditions.checkNotNull((Object)reporter);
        for (String illegalName : BaseUtils.ILLEGAL_PLUGIN_NAMES) {
            if (!soyFunctions.containsKey((Object)illegalName) && !sourceFunctions.containsKey((Object)illegalName)) continue;
            reporter.report(SourceLocation.UNKNOWN, PLUGIN_NAME_NOT_ALLOWED, illegalName);
        }
        ImmutableMap.Builder mergedFunctions = ImmutableMap.builder();
        for (Map.Entry entry : soyFunctions.entrySet()) {
            SoySourceFunction source = (SoySourceFunction)sourceFunctions.get(entry.getKey());
            if (source != null) {
                if (source == entry.getValue()) continue;
                reporter.report(SourceLocation.UNKNOWN, DIFFERENT_IMPLS_REGISTERED, entry.getKey(), entry.getValue(), source);
                continue;
            }
            mergedFunctions.put((Object)((String)entry.getKey()), entry.getValue());
        }
        mergedFunctions.putAll(sourceFunctions);
        this.functions = mergedFunctions.build();
        for (Object function : this.functions.values()) {
            ImmutableSet<String> instances;
            if (!(function instanceof SoySourceFunction)) continue;
            if (!function.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                reporter.report(SourceLocation.UNKNOWN, MISSING_FUNCTION_SIGNATURE, function.getClass().getName());
                continue;
            }
            if (!(function instanceof SoyJavaSourceFunction) || (instances = PluginAnalyzer.analyze((SoyJavaSourceFunction)function).pluginInstanceNames()).size() <= 1) continue;
            reporter.report(SourceLocation.UNKNOWN, MULTIPLE_PLUGIN_INSTANCES, function.getClass().getName(), instances);
        }
        for (String pdName : soyPrintDirectives.keySet()) {
            String functionName = PluginResolver.getFunctionNameEquivalentToPrintDirectiveName(pdName);
            if (COLLISION_WHITELIST.contains((Object)functionName) || !this.functions.containsKey((Object)functionName)) continue;
            reporter.report(SourceLocation.UNKNOWN, FUNCTION_PRINT_DIRECTIVE_COLLISION, this.functions.get((Object)functionName).getClass().getName(), functionName, ((SoyPrintDirective)soyPrintDirectives.get((Object)pdName)).getClass().getName());
        }
    }

    public SoyPrintDirective lookupPrintDirective(String name, int numArgs, SourceLocation location) {
        SoyPrintDirective soyPrintDirective = (SoyPrintDirective)this.printDirectives.get((Object)name);
        if (soyPrintDirective == null) {
            this.reportMissing(location, "print directive", name, (Set<String>)this.printDirectives.keySet());
            soyPrintDirective = PluginResolver.createPlaceholderPrintDirective(name, numArgs);
        }
        this.checkNumArgs("print directive", soyPrintDirective.getValidArgsSizes(), numArgs, location);
        this.warnIfDeprecated(name, soyPrintDirective, location);
        return soyPrintDirective;
    }

    Optional<SoySourceFunction> getFunctionCallableAsPrintDirective(String directiveName, SourceLocation sourceLocation) {
        SoyFunctionSignature signature;
        if (this.printDirectives.containsKey((Object)directiveName)) {
            return Optional.empty();
        }
        String functionName = PluginResolver.getFunctionNameEquivalentToPrintDirectiveName(directiveName);
        if (COLLISION_WHITELIST.contains((Object)functionName)) {
            return Optional.empty();
        }
        Object function = this.functions.get((Object)functionName);
        if (function == null) {
            return Optional.empty();
        }
        if (function instanceof SoySourceFunction && (signature = function.getClass().getAnnotation(SoyFunctionSignature.class)).callableAsDeprecatedPrintDirective()) {
            return Optional.of((SoySourceFunction)function);
        }
        this.reporter.report(sourceLocation, FUNCTION_NOT_CALLABLE, functionName);
        return Optional.empty();
    }

    public Object lookupSoyFunction(String name, int numArgs, SourceLocation location) {
        Object soyFunction = this.functions.get((Object)name);
        if (soyFunction == null) {
            this.reportMissing(location, "function", name, (Set<String>)this.functions.keySet());
            return ERROR_PLACEHOLDER_FUNCTION;
        }
        Set<Integer> validArgsSize = PluginResolver.getValidArgsSizes(soyFunction);
        this.checkNumArgs("function", validArgsSize, numArgs, location);
        this.warnIfDeprecated(name, soyFunction, location);
        return soyFunction;
    }

    private void reportMissing(SourceLocation location, String type, String name, Set<String> alternatives) {
        String didYouMean = SoyErrors.getDidYouMeanMessage(alternatives, name);
        switch (this.mode) {
            case REQUIRE_DEFINITIONS: {
                this.reporter.report(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
            case ALLOW_UNDEFINED_AND_WARN: {
                this.reporter.warn(location, UNKNOWN_PLUGIN, type, name, didYouMean);
                break;
            }
        }
    }

    private static Set<Integer> getValidArgsSizes(Object soyFunction) {
        if (soyFunction instanceof SoyFunction) {
            return ((SoyFunction)soyFunction).getValidArgsSizes();
        }
        SoyFunctionSignature signature = soyFunction.getClass().getAnnotation(SoyFunctionSignature.class);
        Preconditions.checkArgument((signature != null ? 1 : 0) != 0);
        return PluginResolver.getValidArgsSizes(signature.value());
    }

    private static Set<Integer> getValidArgsSizes(Signature[] signatures) {
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        for (Signature signature : signatures) {
            builder.add((Object)signature.parameterTypes().length);
        }
        return builder.build();
    }

    private void checkNumArgs(String pluginKind, Set<Integer> arities, int actualNumArgs, SourceLocation location) {
        if (!arities.contains(actualNumArgs)) {
            this.reporter.report(location, INCORRECT_NUM_ARGS, pluginKind, actualNumArgs, Joiner.on((String)" or ").join(arities));
        }
    }

    private void warnIfDeprecated(String name, Object plugin, SourceLocation location) {
        SoyDeprecated deprecatedNotice = plugin.getClass().getAnnotation(SoyDeprecated.class);
        if (deprecatedNotice != null) {
            this.reporter.warn(location, DEPRECATED_PLUGIN, name, deprecatedNotice.value());
        }
    }

    private static SoyPrintDirective createPlaceholderPrintDirective(final String name, int arity) {
        final ImmutableSet validArgSizes = ImmutableSet.of((Object)arity);
        return new SoyPrintDirective(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return validArgSizes;
            }
        };
    }

    static String getFunctionNameEquivalentToPrintDirectiveName(String printDirectiveName) {
        Preconditions.checkArgument((boolean)printDirectiveName.startsWith("|"));
        return printDirectiveName.substring(1);
    }

    public static enum Mode {
        ALLOW_UNDEFINED,
        ALLOW_UNDEFINED_AND_WARN,
        REQUIRE_DEFINITIONS;

    }
}

