/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlAttributeValueNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.ast.NamedTypeNode;
import javax.annotation.Nullable;

public final class ContentSecurityPolicyNonceInjectionPass
extends CompilerFilePass {
    public static final String CSP_NONCE_VARIABLE_NAME = "csp_nonce";
    private static final SoyErrorKind IJ_CSP_NONCE_REFERENCE = SoyErrorKind.of("Found a use of the injected parameter ''csp_nonce''. This parameter is reserved by the Soy compiler for Content Security Policy support.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MANUAL_NONCE = SoyErrorKind.of("Found a ''nonce'' attribute on a tag that is supported by Soy auto-nonce support. Instead of manually adding nonces you should just supply the ''csp_nonce'' injected parameter and rely on the Soy compiler to add nonce attributes.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    ContentSecurityPolicyNonceInjectionPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            for (TemplateParam param : template.getAllParams()) {
                if (!param.isInjected() || !param.name().equals(CSP_NONCE_VARIABLE_NAME)) continue;
                this.errorReporter.report(param.nameLocation(), IJ_CSP_NONCE_REFERENCE, new Object[0]);
            }
        }
        for (TemplateNode template : file.getChildren()) {
            TemplateParam defn = null;
            for (HtmlOpenTagNode openTag : SoyTreeUtils.getAllNodesOfType(template, HtmlOpenTagNode.class)) {
                if (!this.isTagNonceable(openTag)) continue;
                if (defn == null) {
                    defn = this.createDefn();
                    template.addCspNonceParam(defn);
                }
                SourceLocation insertionLocation = openTag.getSourceLocation().getEndPoint().offset(0, openTag.isSelfClosing() ? -2 : -1).asLocation(openTag.getSourceLocation().getFilePath());
                openTag.addChild(ContentSecurityPolicyNonceInjectionPass.createCspInjection(insertionLocation, nodeIdGen, defn));
            }
        }
    }

    private TemplateParam createDefn() {
        return new TemplateParam(CSP_NONCE_VARIABLE_NAME, SourceLocation.UNKNOWN, NamedTypeNode.create(SourceLocation.UNKNOWN, "any"), false, true, "Created by ContentSecurityPolicyNonceInjectionPass.", null);
    }

    private boolean isTagNonceable(HtmlOpenTagNode tag) {
        TagName nameObj = tag.getTagName();
        if (!nameObj.isStatic()) {
            return false;
        }
        String name = nameObj.getStaticTagNameAsLowerCase();
        if (name.equals("script") || name.equals("style") || name.equals("link") && this.isNonceableLink(tag)) {
            HtmlAttributeNode manualNonce = tag.getDirectAttributeNamed("nonce");
            if (manualNonce != null) {
                this.errorReporter.report(manualNonce.getSourceLocation(), MANUAL_NONCE, new Object[0]);
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private String getStaticDirectAttributeValue(HtmlOpenTagNode tag, String attribute) {
        HtmlAttributeNode attr = tag.getDirectAttributeNamed(attribute);
        return attr == null ? null : attr.getStaticContent();
    }

    private boolean isNonceableLink(HtmlOpenTagNode tag) {
        String relAttrValue = this.getStaticDirectAttributeValue(tag, "rel");
        if (relAttrValue == null) {
            return false;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)"import", (CharSequence)relAttrValue)) {
            return true;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)"preload", (CharSequence)relAttrValue)) {
            String asAttrValue = this.getStaticDirectAttributeValue(tag, "as");
            if (asAttrValue == null) {
                return false;
            }
            return Ascii.equalsIgnoreCase((CharSequence)asAttrValue, (CharSequence)"script") || Ascii.equalsIgnoreCase((CharSequence)asAttrValue, (CharSequence)"style");
        }
        return false;
    }

    private static IfNode createCspInjection(SourceLocation insertionLocation, IdGenerator nodeIdGen, TemplateParam defn) {
        IfNode ifNode = new IfNode(nodeIdGen.genId(), insertionLocation);
        IfCondNode ifCondNode = new IfCondNode(nodeIdGen.genId(), insertionLocation, "if", ContentSecurityPolicyNonceInjectionPass.referenceCspNonce(insertionLocation, defn));
        ifNode.addChild(ifCondNode);
        HtmlAttributeNode nonceAttribute = new HtmlAttributeNode(nodeIdGen.genId(), insertionLocation, insertionLocation.getBeginPoint());
        ifCondNode.addChild(nonceAttribute);
        nonceAttribute.addChild(new RawTextNode(nodeIdGen.genId(), "nonce", insertionLocation));
        HtmlAttributeValueNode attributeValue = new HtmlAttributeValueNode(nodeIdGen.genId(), insertionLocation, HtmlAttributeValueNode.Quotes.DOUBLE);
        nonceAttribute.addChild(attributeValue);
        PrintNode printNode = new PrintNode(nodeIdGen.genId(), insertionLocation, true, ContentSecurityPolicyNonceInjectionPass.referenceCspNonce(insertionLocation, defn), (Iterable<CommandTagAttribute>)ImmutableList.of(), ErrorReporter.exploding());
        attributeValue.addChild(printNode);
        return ifNode;
    }

    private static VarRefNode referenceCspNonce(SourceLocation insertionLocation, TemplateParam defn) {
        return new VarRefNode(CSP_NONCE_VARIABLE_NAME, insertionLocation, defn);
    }
}

