/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;

public final class CombineConsecutiveRawTextNodesPass
extends CompilerFileSetPass {
    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            for (TemplateNode template : file.getChildren()) {
                this.run(template);
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    public void run(SoyNode.ParentSoyNode<?> node) {
        this.visit(node);
    }

    private void visit(SoyNode.ParentSoyNode<?> node) {
        int i;
        int start = -1;
        int lastNonEmptyRawTextNode = -1;
        for (i = 0; i < node.numChildren(); ++i) {
            SoyNode child = (SoyNode)node.getChild(i);
            if (child instanceof RawTextNode) {
                RawTextNode childAsRawText = (RawTextNode)child;
                if (start == -1) {
                    if (childAsRawText.getRawText().isEmpty()) {
                        node.removeChild(i);
                        --i;
                        continue;
                    }
                    start = i;
                    lastNonEmptyRawTextNode = i;
                    continue;
                }
                if (childAsRawText.getRawText().isEmpty()) continue;
                lastNonEmptyRawTextNode = i;
                continue;
            }
            i = this.mergeRange(node, start, lastNonEmptyRawTextNode, i);
            start = -1;
            if (!(child instanceof SoyNode.ParentSoyNode)) continue;
            this.visit((SoyNode.ParentSoyNode)child);
        }
        this.mergeRange(node, start, lastNonEmptyRawTextNode, i);
    }

    private int mergeRange(SoyNode.ParentSoyNode<?> parent, int start, int lastNonEmptyRawTextNode, int end) {
        Preconditions.checkArgument((start < end ? 1 : 0) != 0);
        if (start == -1 || end == start + 1) {
            return end;
        }
        RawTextNode newNode = RawTextNode.concat(parent.getChildren().subList(start, lastNonEmptyRawTextNode + 1));
        parent.replaceChild(start, newNode);
        for (int i = end - 1; i > start; --i) {
            parent.removeChild(i);
        }
        return start + 1;
    }
}

