/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgBundleImpl;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ExtractMsgsVisitor
extends AbstractSoyNodeVisitor<SoyMsgBundle> {
    private List<SoyMsg> msgs;

    @Override
    public SoyMsgBundle exec(SoyNode node) {
        Preconditions.checkArgument((node instanceof SoyFileSetNode || node instanceof SoyFileNode ? 1 : 0) != 0);
        this.msgs = Lists.newArrayList();
        this.visit(node);
        Collections.sort(this.msgs, Comparator.comparing(m -> (SourceLocation)Iterables.getOnlyElement(m.getSourceLocations())));
        return new SoyMsgBundleImpl(null, this.msgs);
    }

    @Override
    protected void visitMsgNode(MsgNode node) {
        MsgUtils.MsgPartsAndIds msgPartsAndIds = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(node);
        SoyMsg.Builder builder = SoyMsg.builder().setId(msgPartsAndIds.id);
        if (node.getMeaning() != null) {
            builder.setMeaning(node.getMeaning());
        }
        SoyMsg msg = builder.setDesc(node.getDesc()).setIsHidden(node.isHidden()).setContentType(node.getContentType()).addSourceLocation(node.getSourceLocation()).setIsPlrselMsg(node.isPlrselMsg()).setParts((Iterable<? extends SoyMsgPart>)msgPartsAndIds.parts).build();
        this.msgs.add(msg);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

