/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.Descriptors;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.SoyJsPluginUtils;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.internal.JavaScriptValueFactoryImpl;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.jssrc.internal.JsType;
import com.google.template.soy.jssrc.internal.NullSafeAccumulator;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.internal.TranslationContext;
import com.google.template.soy.jssrc.internal.Truthiness;
import com.google.template.soy.jssrc.internal.V1JsExprTranslator;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class TranslateExprNodeVisitor
extends AbstractReturningExprNodeVisitor<Expression> {
    private static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private static final SoyErrorKind UNION_ACCESSOR_MISMATCH = SoyErrorKind.of("Cannot access field ''{0}'' of type ''{1}'', because the different union member types have different access methods.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_JS_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Function ''{0}'' implemented by ''{1}'' does not have a JavaScript implementation.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyToJsVariableMappings variableMappings;
    private final JavaScriptValueFactoryImpl javascriptValueFactory;
    private final ErrorReporter errorReporter;
    private final CodeChunk.Generator codeGenerator;

    public TranslateExprNodeVisitor(JavaScriptValueFactoryImpl javascriptValueFactory, TranslationContext translationContext, ErrorReporter errorReporter) {
        this.javascriptValueFactory = javascriptValueFactory;
        this.errorReporter = errorReporter;
        this.variableMappings = translationContext.soyToJsVariableMappings();
        this.codeGenerator = translationContext.codeGenerator();
    }

    Expression genCodeForParamAccess(String paramName, VarDefn varDefn) {
        Expression source = JsRuntime.OPT_DATA;
        if (varDefn.isInjected()) {
            if (paramName.equals("csp_nonce")) {
                return JsRuntime.OPT_IJ_DATA.and(JsRuntime.OPT_IJ_DATA.dotAccess(paramName), this.codeGenerator);
            }
            source = JsRuntime.OPT_IJ_DATA;
        } else if (varDefn.kind() == VarDefn.Kind.STATE) {
            return this.genCodeForStateAccess(paramName, (TemplateStateVar)varDefn);
        }
        return source.dotAccess(paramName);
    }

    protected Expression genCodeForStateAccess(String paramName, TemplateStateVar stateVar) {
        return Expression.id(paramName);
    }

    @Override
    protected Expression visitExprRootNode(ExprRootNode node) {
        return (Expression)this.visit(node.getRoot());
    }

    @Override
    protected Expression visitBooleanNode(BooleanNode node) {
        return node.getValue() ? Expression.LITERAL_TRUE : Expression.LITERAL_FALSE;
    }

    @Override
    protected Expression visitFloatNode(FloatNode node) {
        return Expression.number(node.getValue());
    }

    @Override
    protected Expression visitIntegerNode(IntegerNode node) {
        return Expression.number(node.getValue());
    }

    @Override
    protected Expression visitNullNode(NullNode node) {
        return Expression.LITERAL_NULL;
    }

    @Override
    protected Expression visitStringNode(StringNode node) {
        return Expression.stringLiteral(node.getValue());
    }

    @Override
    protected Expression visitListLiteralNode(ListLiteralNode node) {
        return Expression.arrayLiteral(this.visitChildren(node));
    }

    @Override
    protected Expression visitRecordLiteralNode(RecordLiteralNode node) {
        LinkedHashMap<String, Expression> objLiteral = new LinkedHashMap<String, Expression>();
        for (int i = 0; i < node.numChildren(); ++i) {
            objLiteral.put(node.getKey(i).identifier(), (Expression)this.visit(node.getChild(i)));
        }
        return Expression.objectLiteral(objLiteral);
    }

    @Override
    protected Expression visitMapLiteralNode(MapLiteralNode node) {
        Expression map = this.codeGenerator.declarationBuilder().setRhs(Expression.construct(Expression.id("Map"), new Expression[0])).build().ref();
        ImmutableList.Builder setCalls = ImmutableList.builder();
        for (int i = 0; i < node.numChildren(); i += 2) {
            ExprNode keyNode = node.getChild(i);
            Expression key = JsRuntime.SOY_CHECK_NOT_NULL.call(this.genMapKeyCode(keyNode));
            Expression value = (Expression)this.visit(node.getChild(i + 1));
            setCalls.add((Object)map.dotAccess("set").call(key, value).asStatement());
        }
        return map.withInitialStatements((Iterable<? extends Statement>)setCalls.build());
    }

    private Expression genMapKeyCode(ExprNode keyNode) {
        return (Expression)this.visit(keyNode);
    }

    @Override
    protected Expression visitVarRefNode(VarRefNode node) {
        Expression translation = this.variableMappings.maybeGet(node.getName());
        if (translation != null) {
            return translation;
        }
        return this.genCodeForParamAccess(node.getName(), node.getDefnDecl());
    }

    @Override
    protected Expression visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node).result(this.codeGenerator);
    }

    protected Expression sanitizedContentToProtoConverterFunction(Descriptors.Descriptor messageType) {
        return (Expression)JsRuntime.JS_TO_PROTO_PACK_FN.get((Object)messageType.getFullName());
    }

    private NullSafeAccumulator visitNullSafeNode(ExprNode node) {
        switch (node.getKind()) {
            case FIELD_ACCESS_NODE: {
                FieldAccessNode fieldAccess = (FieldAccessNode)node;
                NullSafeAccumulator base = this.visitNullSafeNode(fieldAccess.getBaseExprChild());
                NullSafeAccumulator.FieldAccess access = this.genCodeForFieldAccess(fieldAccess.getBaseExprChild().getType(), fieldAccess, fieldAccess.getFieldName());
                return base.dotAccess(access, fieldAccess.isNullSafe());
            }
            case ITEM_ACCESS_NODE: {
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                NullSafeAccumulator base = this.visitNullSafeNode(itemAccess.getBaseExprChild());
                ExprNode keyNode = itemAccess.getKeyExprChild();
                SoyType baseType = itemAccess.getBaseExprChild().getType();
                return SoyTypes.isKindOrUnionOfKind(SoyTypes.removeNull(baseType), SoyType.Kind.MAP) ? base.mapGetAccess(this.genMapKeyCode(keyNode), itemAccess.isNullSafe()) : base.bracketAccess(((Expression)this.visit(keyNode)).castAs("?"), itemAccess.isNullSafe());
            }
        }
        return new NullSafeAccumulator((Expression)this.visit(node));
    }

    private NullSafeAccumulator.FieldAccess genCodeForFieldAccess(SoyType baseType, FieldAccessNode fieldAccessNode, String fieldName) {
        Preconditions.checkNotNull((Object)baseType);
        if (baseType.getKind() == SoyType.Kind.UNION) {
            UnionType unionType = (UnionType)baseType;
            NullSafeAccumulator.FieldAccess fieldAccess = null;
            for (SoyType memberType : unionType.getMembers()) {
                if (memberType.getKind() == SoyType.Kind.NULL) continue;
                NullSafeAccumulator.FieldAccess fieldAccessForType = this.genCodeForFieldAccess(memberType, fieldAccessNode, fieldName);
                if (fieldAccess == null) {
                    fieldAccess = fieldAccessForType;
                    continue;
                }
                if (fieldAccess.equals(fieldAccessForType)) continue;
                this.errorReporter.report(fieldAccessNode.getSourceLocation(), UNION_ACCESSOR_MISMATCH, fieldName, baseType);
            }
            return fieldAccess;
        }
        if (baseType.getKind() == SoyType.Kind.PROTO) {
            SoyProtoType protoType = (SoyProtoType)baseType;
            Descriptors.FieldDescriptor desc = protoType.getFieldDescriptor(fieldName);
            Preconditions.checkNotNull((Object)desc, (String)"Error in proto %s, field not found: %s", (Object)protoType.getDescriptor().getFullName(), (Object)fieldName);
            return NullSafeAccumulator.FieldAccess.protoCall(fieldName, desc);
        }
        return NullSafeAccumulator.FieldAccess.id(fieldName);
    }

    @Override
    protected Expression visitGlobalNode(GlobalNode node) {
        if (node.isResolved()) {
            return (Expression)this.visit(node.getValue());
        }
        return Expression.dottedIdNoRequire(node.getName());
    }

    @Override
    protected Expression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List operands = this.visitChildren(node);
        Expression consequent = (Expression)operands.get(0);
        Expression alternate = (Expression)operands.get(1);
        if (!consequent.isCheap()) {
            consequent = this.codeGenerator.declarationBuilder().setRhs(consequent).build().ref();
        }
        return Expression.ifExpression(consequent.doubleNotEquals(Expression.LITERAL_NULL), consequent).setElse(alternate).build(this.codeGenerator);
    }

    @Override
    protected Expression visitAndOpNode(OperatorNodes.AndOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = Truthiness.maybeCoerce(lhOperand.getType(), (Expression)this.visit(lhOperand));
        Expression rhChunk = Truthiness.maybeCoerce(rhOperand.getType(), (Expression)this.visit(rhOperand));
        return lhChunk.and(rhChunk, this.codeGenerator);
    }

    @Override
    protected Expression visitOrOpNode(OperatorNodes.OrOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 2 ? 1 : 0) != 0);
        ExprNode lhOperand = node.getChild(0);
        ExprNode rhOperand = node.getChild(1);
        Expression lhChunk = Truthiness.maybeCoerce(lhOperand.getType(), (Expression)this.visit(lhOperand));
        Expression rhChunk = Truthiness.maybeCoerce(rhOperand.getType(), (Expression)this.visit(rhOperand));
        return lhChunk.or(rhChunk, this.codeGenerator);
    }

    @Override
    protected Expression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Preconditions.checkArgument((node.numChildren() == 3 ? 1 : 0) != 0);
        return this.codeGenerator.conditionalExpression((Expression)this.visit(node.getChild(0)), (Expression)this.visit(node.getChild(1)), (Expression)this.visit(node.getChild(2)));
    }

    @Override
    protected Expression visitOperatorNode(ExprNode.OperatorNode node) {
        return Expression.operation(node.getOperator(), this.visitChildren(node));
    }

    private Expression visitEqualNodeHelper(ExprNode.OperatorNode node) {
        for (ExprNode c : node.getChildren()) {
            SoyType type = c.getType();
            if ((SoyTypes.isNumericPrimitive(type) || type.getKind() == SoyType.Kind.BOOL) && type.getKind() != SoyType.Kind.UNKNOWN && type.getKind() != SoyType.Kind.ANY) continue;
            return JsRuntime.SOY_EQUALS.call(this.visitChildren(node));
        }
        return Expression.operation(Operator.EQUAL, this.visitChildren(node));
    }

    @Override
    protected Expression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.visitEqualNodeHelper(node);
    }

    @Override
    protected Expression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return Expression.not(this.visitEqualNodeHelper(node));
    }

    @Override
    protected Expression visitProtoInitNode(ProtoInitNode node) {
        SoyProtoType type = (SoyProtoType)node.getType();
        Expression proto = Expression.construct(JsRuntime.protoConstructor(type), new Expression[0]);
        for (int i = 0; i < node.numChildren(); ++i) {
            String fieldName = node.getParamName(i).identifier();
            Descriptors.FieldDescriptor fieldDesc = type.getFieldDescriptor(fieldName);
            Expression fieldValue = (Expression)this.visit(node.getChild(i));
            if (ProtoUtils.isSanitizedContentField(fieldDesc)) {
                Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(fieldDesc.getMessageType());
                Expression expression = fieldValue = fieldDesc.isRepeated() ? JsRuntime.GOOG_ARRAY_MAP.call(fieldValue, sanitizedContentPackFn) : sanitizedContentPackFn.call(fieldValue);
            }
            if (fieldDesc.getType() == Descriptors.FieldDescriptor.Type.ENUM && !fieldDesc.isRepeated()) {
                fieldValue = fieldValue.castAs((fieldDesc.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3 ? "!" : "?") + ProtoUtils.calculateJsEnumName(fieldDesc.getEnumType()));
            }
            if (fieldDesc.isExtension()) {
                Expression extInfo = JsRuntime.extensionField(fieldDesc);
                proto = proto.dotAccess("setExtension").call(extInfo, fieldValue);
                continue;
            }
            if (fieldDesc.isMapField()) {
                String getFn = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                Expression protoVar = this.codeGenerator.declarationBuilder().setRhs(proto).build().ref();
                if (ProtoUtils.isSanitizedContentMap(fieldDesc)) {
                    Expression sanitizedContentPackFn = this.sanitizedContentToProtoConverterFunction(ProtoUtils.getMapValueMessageType(fieldDesc));
                    fieldValue = JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(fieldValue, sanitizedContentPackFn);
                }
                proto = JsRuntime.SOY_MAP_POPULATE.call(protoVar, protoVar.dotAccess(getFn).call(new Expression[0]), fieldValue);
                continue;
            }
            String setFn = "set" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
            proto = proto.dotAccess(setFn).call(fieldValue);
        }
        return proto;
    }

    @Override
    protected Expression visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            switch ((BuiltinFunction)soyFunction) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node);
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case UNKNOWN_JS_GLOBAL: {
                    return this.visitUnknownJsGlobal(node);
                }
                case V1_EXPRESSION: {
                    return this.visitV1ExpressionFunction(node);
                }
                case IS_PRIMARY_MSG_IN_USE: {
                    return this.visitIsPrimaryMsgInUseFunction(node);
                }
                case TO_FLOAT: {
                    return (Expression)this.visit(node.getChild(0));
                }
                case DEBUG_SOY_TEMPLATE_INFO: {
                    return JsRuntime.GOOG_DEBUG.and(JsRuntime.SOY_DEBUG_SOY_TEMPLATE_INFO, this.codeGenerator);
                }
                case VE_DATA: {
                    return this.visitVeDataFunction(node);
                }
                case REMAINDER: 
                case MSG_WITH_ID: {
                    throw new AssertionError();
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof LoggingFunction) {
            return Expression.stringLiteral(((LoggingFunction)soyFunction).getPlaceholder());
        }
        if (soyFunction instanceof SoyJavaScriptSourceFunction) {
            return this.javascriptValueFactory.applyFunction(node.getSourceLocation(), node.getFunctionName(), (SoyJavaScriptSourceFunction)soyFunction, this.visitChildren(node), this.codeGenerator);
        }
        if (!(soyFunction instanceof SoyJsSrcFunction)) {
            this.errorReporter.report(node.getSourceLocation(), SOY_JS_SRC_FUNCTION_NOT_FOUND, node.getFunctionName(), soyFunction == null ? "missing implementation" : soyFunction.getClass().getName());
            soyFunction = TranslateExprNodeVisitor.getUnknownFunction(node.getFunctionName(), node.numChildren());
        }
        return SoyJsPluginUtils.applySoyFunction((SoyJsSrcFunction)soyFunction, this.visitChildren(node), node.getSourceLocation(), this.errorReporter);
    }

    protected JsType jsTypeFor(SoyType type) {
        return JsType.forJsSrcStrict(type);
    }

    private Expression visitCheckNotNullFunction(FunctionNode node) {
        return JsRuntime.SOY_CHECK_NOT_NULL.call((Expression)this.visit(node.getChild(0))).castAs(this.jsTypeFor(SoyTypes.tryRemoveNull(node.getChild(0).getType())).typeExpr());
    }

    private Expression visitIsFirstFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isFirst");
    }

    private Expression visitIsLastFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__isLast");
    }

    private Expression visitIndexFunction(FunctionNode node) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.variableMappings.get(varName + "__index");
    }

    private Expression visitCssFunction(FunctionNode node) {
        return JsRuntime.GOOG_GET_CSS_NAME.call(this.visitChildren(node));
    }

    private Expression visitXidFunction(FunctionNode node) {
        return JsRuntime.XID.call(this.visitChildren(node));
    }

    private Expression visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        MsgFallbackGroupNode msgNode = (MsgFallbackGroupNode)((LetContentNode)((LocalVar)((VarRefNode)node.getChild(0)).getDefnDecl()).declaringNode()).getChild(0);
        return this.variableMappings.isPrimaryMsgInUse(msgNode);
    }

    private Expression visitV1ExpressionFunction(FunctionNode node) {
        StringNode expr = (StringNode)node.getChild(0);
        JsExpr jsExpr = V1JsExprTranslator.translateToJsExpr(expr.getValue(), expr.getSourceLocation(), this.variableMappings, this.errorReporter);
        return Expression.fromExpr(jsExpr, (Iterable<GoogRequire>)ImmutableList.of());
    }

    private Expression visitUnknownJsGlobal(FunctionNode node) {
        StringNode expr = (StringNode)node.getChild(0);
        return this.codeGenerator.declarationBuilder().setRhs(Expression.dottedIdNoRequire(expr.getValue())).setJsDoc(JsDoc.builder().addParameterizedAnnotation("suppress", "missingRequire").build()).build().ref();
    }

    private Expression visitVeDataFunction(FunctionNode node) {
        return Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT_DATA, (Expression)this.visit(node.getChild(0)), (Expression)this.visit(node.getChild(1)));
    }

    private static SoyJsSrcFunction getUnknownFunction(final String name, final int argSize) {
        return new SoyJsSrcFunction(){

            @Override
            public JsExpr computeForJsSrc(List<JsExpr> args) {
                ArrayList<String> argStrings = new ArrayList<String>();
                for (JsExpr arg : args) {
                    argStrings.add(arg.getText());
                }
                return new JsExpr(name + "(" + COMMA_JOINER.join(argStrings) + ")", Integer.MAX_VALUE);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public Set<Integer> getValidArgsSizes() {
                return ImmutableSet.of((Object)argSize);
            }
        };
    }

    @Override
    protected Expression visitVeLiteralNode(VeLiteralNode node) {
        return Expression.ifExpression(JsRuntime.GOOG_DEBUG, Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT, Expression.number(node.getId()), Expression.stringLiteral(node.getName().identifier()))).setElse(Expression.construct(JsRuntime.SOY_VISUAL_ELEMENT, Expression.number(node.getId()))).build(this.codeGenerator);
    }
}

