/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Call;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_Id;
import com.google.template.soy.jssrc.internal.AutoValue_NullSafeAccumulator_ProtoCall;
import com.google.template.soy.jssrc.internal.JsRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

final class NullSafeAccumulator {
    private final Expression base;
    private final List<ChainAccess> chain;
    @Nullable
    private Expression unpackFunction;
    @Nullable
    private AccessType accessType;

    NullSafeAccumulator(Expression base) {
        this.base = base;
        this.chain = new ArrayList<ChainAccess>();
    }

    NullSafeAccumulator dotAccess(FieldAccess access, boolean nullSafe) {
        ProtoCall protoCall;
        Expression maybeUnpack;
        if (access instanceof ProtoCall && (maybeUnpack = (protoCall = (ProtoCall)access).unpackFunction()) != null) {
            Preconditions.checkState((this.unpackFunction == null ? 1 : 0) != 0, (String)"this chain will already unpack with %s", (Object)this.unpackFunction);
            this.unpackFunction = maybeUnpack;
            this.accessType = protoCall.accessType();
        }
        this.chain.add(access.toChainAccess(nullSafe));
        return this;
    }

    NullSafeAccumulator mapGetAccess(Expression mapKeyCode, boolean nullSafe) {
        this.chain.add(FieldAccess.call("get", mapKeyCode).toChainAccess(nullSafe));
        this.accessType = AccessType.SINGULAR;
        return this;
    }

    NullSafeAccumulator bracketAccess(Expression arg, boolean nullSafe) {
        this.chain.add(new Bracket(arg, nullSafe));
        this.accessType = AccessType.SINGULAR;
        return this;
    }

    Expression result(CodeChunk.Generator codeGenerator) {
        Expression accessChain = NullSafeAccumulator.buildAccessChain(this.base, codeGenerator, this.chain.iterator());
        if (this.unpackFunction == null) {
            return accessChain;
        }
        return this.accessType.unpackResult(accessChain, this.unpackFunction);
    }

    private static Expression buildAccessChain(Expression base, CodeChunk.Generator generator, Iterator<ChainAccess> chain) {
        if (!chain.hasNext()) {
            return base;
        }
        ChainAccess link = chain.next();
        if (link.nullSafe) {
            if (!base.isCheap()) {
                base = generator.declarationBuilder().setRhs(base).build().ref();
            }
            return Expression.ifExpression(base.doubleEqualsNull(), Expression.LITERAL_NULL).setElse(NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain)).build(generator);
        }
        return NullSafeAccumulator.buildAccessChain(link.extend(base), generator, chain);
    }

    static enum AccessType {
        SINGULAR{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return unpackFunction.call(accessChain);
            }
        }
        ,
        REPEATED{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.GOOG_ARRAY_MAP.call(accessChain, unpackFunction);
            }
        }
        ,
        MAP{

            @Override
            Expression unpackResult(Expression accessChain, Expression unpackFunction) {
                return JsRuntime.SOY_NEWMAPS_TRANSFORM_VALUES.call(accessChain, unpackFunction);
            }
        };


        abstract Expression unpackResult(Expression var1, Expression var2);

        private static AccessType get(Descriptors.FieldDescriptor desc) {
            if (desc.isMapField()) {
                return MAP;
            }
            if (desc.isRepeated()) {
                return REPEATED;
            }
            return SINGULAR;
        }
    }

    @AutoValue
    static abstract class ProtoCall
    extends FieldAccess {
        ProtoCall() {
        }

        abstract String getter();

        @Nullable
        abstract Expression getterArg();

        @Nullable
        abstract AccessType accessType();

        @Nullable
        abstract Expression unpackFunction();

        static ProtoCall create(String fieldName, Descriptors.FieldDescriptor desc) {
            Expression arg;
            String getter;
            if (desc.isExtension()) {
                getter = "getExtension";
                arg = JsRuntime.extensionField(desc);
            } else {
                getter = "get" + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, fieldName);
                arg = null;
            }
            Expression unpackFunction = ProtoCall.getUnpackFunction(desc);
            return new AutoValue_NullSafeAccumulator_ProtoCall(getter, arg, unpackFunction == null ? null : AccessType.get(desc), unpackFunction);
        }

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.getterArg(), nullSafe);
        }

        @Nullable
        private static Expression getUnpackFunction(Descriptors.FieldDescriptor desc) {
            if (ProtoUtils.isSanitizedContentField(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(desc.getMessageType());
            }
            if (ProtoUtils.isSanitizedContentMap(desc)) {
                return JsRuntime.protoToSanitizedContentConverterFunction(ProtoUtils.getMapValueMessageType(desc));
            }
            return null;
        }
    }

    @AutoValue
    static abstract class Call
    extends FieldAccess {
        Call() {
        }

        abstract String getter();

        @Nullable
        abstract Expression arg();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new DotCall(this.getter(), this.arg(), nullSafe);
        }
    }

    @AutoValue
    static abstract class Id
    extends FieldAccess {
        Id() {
        }

        abstract String fieldName();

        @Override
        ChainAccess toChainAccess(boolean nullSafe) {
            return new Dot(this.fieldName(), nullSafe);
        }
    }

    static abstract class FieldAccess {
        FieldAccess() {
        }

        @ForOverride
        abstract ChainAccess toChainAccess(boolean var1);

        static FieldAccess id(String fieldName) {
            return new AutoValue_NullSafeAccumulator_Id(fieldName);
        }

        static FieldAccess call(String getter, Expression arg) {
            return new AutoValue_NullSafeAccumulator_Call(getter, arg);
        }

        static FieldAccess protoCall(String fieldName, Descriptors.FieldDescriptor desc) {
            return ProtoCall.create(fieldName, desc);
        }
    }

    private static final class DotCall
    extends ChainAccess {
        final String getter;
        @Nullable
        final Expression arg;

        DotCall(String getter, @Nullable Expression arg, boolean nullSafe) {
            super(nullSafe);
            this.getter = getter;
            this.arg = arg;
        }

        @Override
        Expression extend(Expression prevTip) {
            return this.arg == null ? prevTip.dotAccess(this.getter).call(new Expression[0]) : prevTip.dotAccess(this.getter).call(this.arg);
        }
    }

    private static final class Dot
    extends ChainAccess {
        final String id;

        Dot(String id, boolean nullSafe) {
            super(nullSafe);
            this.id = id;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.dotAccess(this.id);
        }
    }

    private static final class Bracket
    extends ChainAccess {
        final Expression value;

        Bracket(Expression value, boolean nullSafe) {
            super(nullSafe);
            this.value = value;
        }

        @Override
        Expression extend(Expression prevTip) {
            return prevTip.bracketAccess(this.value);
        }
    }

    private static abstract class ChainAccess {
        final boolean nullSafe;

        abstract Expression extend(Expression var1);

        ChainAccess(boolean nullSafe) {
            this.nullSafe = nullSafe;
        }
    }
}

