/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;

@AutoValue
abstract class FunctionDeclaration
extends Expression {
    FunctionDeclaration() {
    }

    abstract JsDoc jsDoc();

    abstract Statement body();

    abstract boolean isArrowFunction();

    static FunctionDeclaration create(JsDoc jsDoc, Statement body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<Statement>)ImmutableList.of(), jsDoc, body, false);
    }

    static FunctionDeclaration createArrowFunction(JsDoc jsDoc, Statement body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<Statement>)ImmutableList.of(), jsDoc, body, true);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.body().collectRequires(collector);
        this.jsDoc().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (!this.isArrowFunction()) {
            ctx.append("function");
        }
        ctx.append("(");
        ctx.append(CodeChunkUtils.generateParamList(this.jsDoc()));
        ctx.append(") ");
        if (this.isArrowFunction()) {
            ctx.append("=> ");
        }
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.body());
        }
    }
}

