/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.ArrayLiteral;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.Bracket;
import com.google.template.soy.jssrc.dsl.Call;
import com.google.template.soy.jssrc.dsl.Cast;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.ConditionalExpressionBuilder;
import com.google.template.soy.jssrc.dsl.Dot;
import com.google.template.soy.jssrc.dsl.ExpressionStatement;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Leaf;
import com.google.template.soy.jssrc.dsl.New;
import com.google.template.soy.jssrc.dsl.ObjectLiteral;
import com.google.template.soy.jssrc.dsl.PrefixUnaryOperation;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.StringLiteral;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@Immutable
public abstract class Expression
extends CodeChunk {
    public static final Expression LITERAL_TRUE = Expression.id("true");
    public static final Expression LITERAL_FALSE = Expression.id("false");
    public static final Expression LITERAL_NULL = Expression.id("null");
    public static final Expression LITERAL_UNDEFINED = Expression.id("undefined");
    public static final Expression LITERAL_EMPTY_STRING = Leaf.create("''", true);
    public static final Expression EMPTY_OBJECT_LITERAL = Leaf.create("{}", false);
    public static final Expression THIS = Expression.id("this");

    Expression() {
    }

    public static ConditionalExpressionBuilder ifExpression(Expression predicate, Expression consequent) {
        return new ConditionalExpressionBuilder(predicate, consequent);
    }

    public static Expression fromExpr(JsExpr expr, Iterable<GoogRequire> requires) {
        return Leaf.create(expr, false, requires);
    }

    public static Expression id(String id) {
        CodeChunkUtils.checkId(id);
        return Leaf.create(id, true);
    }

    static Expression id(String id, Iterable<GoogRequire> requires) {
        CodeChunkUtils.checkId(id);
        return Leaf.create(id, true, requires);
    }

    public static Expression dottedIdNoRequire(String dotSeparatedIdentifiers) {
        return Expression.dottedIdWithRequires(dotSeparatedIdentifiers, (Iterable<GoogRequire>)ImmutableSet.of());
    }

    static Expression dottedIdWithRequires(String dotSeparatedIdentifiers, Iterable<GoogRequire> requires) {
        List ids = Splitter.on((char)'.').splitToList((CharSequence)dotSeparatedIdentifiers);
        Preconditions.checkState((!ids.isEmpty() ? 1 : 0) != 0, (String)"not a dot-separated sequence of JavaScript identifiers: %s", (Object)dotSeparatedIdentifiers);
        Expression tip = Expression.id((String)ids.get(0), requires);
        for (int i = 1; i < ids.size(); ++i) {
            tip = tip.dotAccess((String)ids.get(i));
        }
        return tip;
    }

    public static Expression stringLiteral(String contents) {
        return StringLiteral.create(contents);
    }

    public static Expression regexLiteral(String contents) {
        int lastSlash;
        int firstSlash = contents.indexOf(47);
        Preconditions.checkArgument((firstSlash < (lastSlash = contents.lastIndexOf(47)) && firstSlash != -1 ? 1 : 0) != 0, (String)"expected regex to start with a '/' and have a second '/' near the end, got %s", (Object)contents);
        return Leaf.create(contents, false);
    }

    public static Expression number(long value) {
        Preconditions.checkArgument((boolean)IntegerNode.isInRange(value), (String)"Number is outside JS safe integer range: %s", (long)value);
        return Leaf.create(Long.toString(value), true);
    }

    public static Expression number(double value) {
        return Leaf.create(Double.toString(value), true);
    }

    public static Expression function(JsDoc parameters, Statement body) {
        return FunctionDeclaration.create(parameters, body);
    }

    public static Expression arrowFunction(JsDoc parameters, Statement body) {
        return FunctionDeclaration.createArrowFunction(parameters, body);
    }

    public static Expression not(Expression arg) {
        return PrefixUnaryOperation.create(Operator.NOT, arg);
    }

    public static Expression construct(Expression ctor, Expression ... args) {
        return New.create(ctor).call(args);
    }

    public static Expression operation(Operator op, List<Expression> operands) {
        Preconditions.checkArgument((operands.size() == op.getNumOperands() ? 1 : 0) != 0);
        Preconditions.checkArgument((op != Operator.AND && op != Operator.OR && op != Operator.CONDITIONAL ? 1 : 0) != 0);
        switch (op.getNumOperands()) {
            case 1: {
                return PrefixUnaryOperation.create(op, operands.get(0));
            }
            case 2: {
                return BinaryOperation.create(op, operands.get(0), operands.get(1));
            }
        }
        throw new AssertionError();
    }

    public static Expression arrayLiteral(Iterable<? extends Expression> elements) {
        return ArrayLiteral.create((ImmutableList<? extends Expression>)ImmutableList.copyOf(elements));
    }

    public static Expression objectLiteral(Map<String, Expression> object) {
        return ObjectLiteral.create(object);
    }

    public static Expression objectLiteralWithQuotedKeys(Map<String, Expression> object) {
        return ObjectLiteral.createWithQuotedKeys(object);
    }

    public static Expression dontTrustPrecedenceOf(JsExpr couldHaveWrongPrecedence, Iterable<GoogRequire> requires) {
        return Group.create(Expression.fromExpr(couldHaveWrongPrecedence, requires));
    }

    public final Statement asStatement() {
        return ExpressionStatement.of(this);
    }

    public final Statement asStatement(JsDoc jsDoc) {
        return ExpressionStatement.of(this, jsDoc);
    }

    public final Expression plus(Expression rhs) {
        return BinaryOperation.create(Operator.PLUS, this, rhs);
    }

    public final Expression minus(Expression rhs) {
        return BinaryOperation.create(Operator.MINUS, this, rhs);
    }

    public final Expression plusEquals(Expression rhs) {
        return BinaryOperation.create("+=", 0, Operator.Associativity.RIGHT, this, rhs);
    }

    public final Expression doubleEquals(Expression rhs) {
        return BinaryOperation.create(Operator.EQUAL, this, rhs);
    }

    public final Expression doubleNotEquals(Expression rhs) {
        return BinaryOperation.create(Operator.NOT_EQUAL, this, rhs);
    }

    public final Expression tripleEquals(Expression rhs) {
        return BinaryOperation.create("===", Operator.EQUAL.getPrecedence(), Operator.EQUAL.getAssociativity(), this, rhs);
    }

    public final Expression tripleNotEquals(Expression rhs) {
        return BinaryOperation.create("!==", Operator.EQUAL.getPrecedence(), Operator.EQUAL.getAssociativity(), this, rhs);
    }

    public final Expression doubleEqualsNull() {
        return this.doubleEquals(LITERAL_NULL);
    }

    public final Expression times(Expression rhs) {
        return BinaryOperation.create(Operator.TIMES, this, rhs);
    }

    public final Expression divideBy(Expression rhs) {
        return BinaryOperation.create(Operator.DIVIDE_BY, this, rhs);
    }

    public final Expression and(Expression rhs, CodeChunk.Generator codeGenerator) {
        return BinaryOperation.and(this, rhs, codeGenerator);
    }

    public final Expression or(Expression rhs, CodeChunk.Generator codeGenerator) {
        return BinaryOperation.or(this, rhs, codeGenerator);
    }

    public final Expression op(Operator op, Expression rhs) {
        return Expression.operation(op, (List<Expression>)ImmutableList.of((Object)this, (Object)rhs));
    }

    public final Expression dotAccess(String identifier) {
        return Dot.create(this, Expression.id(identifier));
    }

    public final Expression bracketAccess(Expression arg) {
        return Bracket.create(this, arg);
    }

    public final Expression call(Expression ... args) {
        return this.call(Arrays.asList(args));
    }

    public final Expression call(Iterable<? extends Expression> args) {
        return Call.create(this, (ImmutableList<Expression>)ImmutableList.copyOf(args));
    }

    public final Expression castAs(String typeExpression) {
        return Cast.create(this, typeExpression);
    }

    public final Expression castAs(String typeExpression, ImmutableSet<GoogRequire> googRequires) {
        return Cast.create(this, typeExpression, googRequires);
    }

    public final Expression instanceOf(Expression identifier) {
        return BinaryOperation.create("instanceof", Operator.LESS_THAN.getPrecedence(), Operator.Associativity.LEFT, this, identifier);
    }

    public final Expression assign(Expression rhs) {
        return BinaryOperation.create("=", 0, Operator.Associativity.RIGHT, this, rhs);
    }

    public final Expression withInitialStatements(Iterable<? extends Statement> initialStatements) {
        if (Iterables.isEmpty(initialStatements)) {
            return this;
        }
        return Composite.create((ImmutableList<Statement>)ImmutableList.copyOf(initialStatements), this);
    }

    public final Expression withInitialStatement(Statement initialStatement) {
        return this.withInitialStatements((Iterable<? extends Statement>)ImmutableList.of((Object)initialStatement));
    }

    final boolean isRepresentableAsSingleExpression() {
        return this.initialStatements().isEmpty();
    }

    public abstract JsExpr singleExprOrName();

    abstract void doFormatOutputExpr(FormattingContext var1);

    public abstract ImmutableList<Statement> initialStatements();

    public boolean isCheap() {
        return false;
    }

    public Optional<String> asStringLiteral() {
        return Optional.empty();
    }
}

