/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Concatenation;
import com.google.template.soy.jssrc.dsl.BinaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Statement;

@Immutable
@AutoValue
abstract class Concatenation
extends Operation {
    Concatenation() {
    }

    static Concatenation create(Iterable<? extends Expression> parts) {
        ImmutableList.Builder initialStatements = ImmutableList.builder();
        ImmutableList.Builder partsBuilder = ImmutableList.builder();
        for (Expression expression : parts) {
            initialStatements.addAll(expression.initialStatements());
            if (expression instanceof Concatenation) {
                partsBuilder.addAll(((Concatenation)expression).parts());
                continue;
            }
            if (expression instanceof BinaryOperation) {
                BinaryOperation binaryOp = (BinaryOperation)expression;
                if (binaryOp.operator().equals(Operator.PLUS.getTokenString())) {
                    partsBuilder.add((Object)binaryOp.arg1());
                    partsBuilder.add((Object)binaryOp.arg2());
                    continue;
                }
                partsBuilder.add((Object)expression);
                continue;
            }
            partsBuilder.add((Object)expression);
        }
        return new AutoValue_Concatenation((ImmutableList<Statement>)initialStatements.build(), (ImmutableList<Expression>)partsBuilder.build());
    }

    abstract ImmutableList<Expression> parts();

    @Override
    int precedence() {
        return Operator.PLUS.getPrecedence();
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.PLUS.getAssociativity();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (Expression part : this.parts()) {
            part.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        if (this.parts().isEmpty()) {
            ctx.append("''");
        } else if (this.parts().size() == 1) {
            ctx.appendOutputExpression((Expression)this.parts().get(0));
        } else {
            this.formatOperand((Expression)this.parts().get(0), OperandPosition.LEFT, ctx);
            for (int i = 1; i < this.parts().size(); ++i) {
                ctx.append(" + ");
                this.formatOperand((Expression)this.parts().get(i), OperandPosition.RIGHT, ctx);
            }
        }
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (Expression part : this.parts()) {
            ctx.appendInitialStatements(part);
        }
    }
}

