/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Concatenation;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.Group;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class CodeChunkUtils {
    private static final Pattern ID = Pattern.compile("[A-Za-z_$][\\w$]*");

    private CodeChunkUtils() {
    }

    static void checkId(String id) {
        if (!ID.matcher(id).matches()) {
            throw new IllegalArgumentException(String.format("not a valid js identifier: %s", id));
        }
    }

    public static Expression concatChunks(List<? extends Expression> chunks) {
        return Concatenation.create(chunks);
    }

    public static Expression concatChunksForceString(List<? extends Expression> chunks) {
        if (!chunks.isEmpty() && chunks.get(0).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(0).assertExprAndCollectRequires(CodeChunk.RequiresCollector.NULL))) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        if (chunks.size() > 1 && chunks.get(1).isRepresentableAsSingleExpression() && JsExprUtils.isStringLiteral(chunks.get(1).assertExprAndCollectRequires(CodeChunk.RequiresCollector.NULL))) {
            return CodeChunkUtils.concatChunks(chunks);
        }
        return CodeChunkUtils.concatChunks((List<? extends Expression>)ImmutableList.of((Object)Expression.LITERAL_EMPTY_STRING, (Object)Group.create(CodeChunkUtils.concatChunks(chunks))));
    }

    static String generateParamList(JsDoc jsDoc) {
        ImmutableList<JsDoc.Param> params = jsDoc.params();
        ArrayList<String> functionParameters = new ArrayList<String>();
        for (JsDoc.Param param : params) {
            if (!"param".equals(param.annotationType())) continue;
            functionParameters.add(param.paramTypeName());
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < functionParameters.size(); ++i) {
            sb.append((String)functionParameters.get(i));
            if (i + 1 >= functionParameters.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

