/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.jssrc.dsl.AutoValue_ClassExpression;
import com.google.template.soy.jssrc.dsl.AutoValue_ClassExpression_MethodDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.CodeChunkUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;
import javax.annotation.Nullable;

@AutoValue
public abstract class ClassExpression
extends Expression {
    @Nullable
    abstract Expression baseClass();

    abstract ImmutableList<MethodDeclaration> methods();

    public static ClassExpression create(Expression baseClass, ImmutableList<MethodDeclaration> methods) {
        return new AutoValue_ClassExpression((ImmutableList<Statement>)ImmutableList.of(), baseClass, methods);
    }

    public static ClassExpression create(ImmutableList<MethodDeclaration> methods) {
        return new AutoValue_ClassExpression((ImmutableList<Statement>)ImmutableList.of(), null, methods);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        if (this.baseClass() != null) {
            this.baseClass().collectRequires(collector);
        }
        for (MethodDeclaration method : this.methods()) {
            method.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append("class");
        if (this.baseClass() != null) {
            ctx.append(" extends ");
            ctx.appendOutputExpression(this.baseClass());
        }
        ctx.append(" ");
        try (FormattingContext ignored = ctx.enterBlock();){
            for (int i = 0; i < this.methods().size(); ++i) {
                if (i > 0) {
                    ctx.append('\n');
                    ctx.endLine();
                }
                ((MethodDeclaration)this.methods().get(i)).doFormatOutputExpr(ctx);
            }
        }
    }

    @AutoValue
    public static abstract class MethodDeclaration
    extends Expression {
        abstract String name();

        abstract JsDoc jsDoc();

        abstract Statement body();

        public static MethodDeclaration create(String name, JsDoc jsDoc, Statement body) {
            return new AutoValue_ClassExpression_MethodDeclaration((ImmutableList<Statement>)ImmutableList.of(), name, jsDoc, body);
        }

        @Override
        public JsExpr singleExprOrName() {
            FormattingContext ctx = new FormattingContext();
            ctx.appendOutputExpression(this);
            return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
        }

        @Override
        void doFormatInitialStatements(FormattingContext ctx) {
        }

        @Override
        public void collectRequires(CodeChunk.RequiresCollector collector) {
            this.body().collectRequires(collector);
            this.jsDoc().collectRequires(collector);
        }

        @Override
        void doFormatOutputExpr(FormattingContext ctx) {
            ctx.append(this.jsDoc());
            ctx.endLine();
            ctx.append(this.name() + "(");
            ctx.append(CodeChunkUtils.generateParamList(this.jsDoc()));
            ctx.append(") ");
            try (FormattingContext ignored = ctx.enterBlock();){
                ctx.appendAll(this.body());
            }
        }
    }
}

