/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.shared;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.TemplateMetadata;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public final class CompiledTemplates {
    private final ClassLoader loader;
    private final ConcurrentHashMap<String, TemplateData> templateNameToFactory = new ConcurrentHashMap();
    private final DelTemplateSelector<TemplateData> selector;

    public CompiledTemplates(ImmutableSet<String> delTemplateNames, ClassLoader loader) {
        this.loader = (ClassLoader)Preconditions.checkNotNull((Object)loader);
        DelTemplateSelector.Builder<TemplateData> builder = new DelTemplateSelector.Builder<TemplateData>();
        for (String delTemplateImplName : delTemplateNames) {
            TemplateData data = this.getTemplateData(delTemplateImplName);
            if (!data.delTemplateName.isPresent()) {
                throw new IllegalArgumentException("Expected " + delTemplateImplName + " to be a deltemplate");
            }
            String delTemplateName = data.delTemplateName.get();
            if (data.delPackage.isPresent()) {
                String delpackage = data.delPackage.get();
                TemplateData prev = builder.add(delTemplateName, delpackage, data.variant, data);
                if (prev == null) continue;
                throw new IllegalArgumentException(String.format("Found multiple deltemplates with the same name (%s) and package (%s). %s and %s", delTemplateName, delpackage, delTemplateImplName, prev.soyTemplateName()));
            }
            TemplateData prev = builder.addDefault(delTemplateName, data.variant, data);
            if (prev == null) continue;
            throw new IllegalArgumentException(String.format("Found multiple default deltemplates with the same name (%s). %s and %s", delTemplateName, delTemplateImplName, prev.soyTemplateName()));
        }
        this.selector = builder.build();
    }

    public SanitizedContent.ContentKind getTemplateContentKind(String name) {
        return this.getTemplateData((String)name).kind;
    }

    public CompiledTemplate.Factory getTemplateFactory(String name) {
        CompiledTemplate.Factory factory = this.getTemplateData((String)name).factory;
        if (factory == null) {
            throw new IllegalArgumentException("cannot get a factory for the private template: " + name);
        }
        return factory;
    }

    public void loadAll(Iterable<String> templateNames) {
        for (String templateName : templateNames) {
            this.getTemplateData(templateName);
        }
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        TemplateData templateData = this.getTemplateData(templateName);
        ImmutableSortedSet transitiveIjParams = templateData.transitiveIjParams;
        if (transitiveIjParams != null) {
            return transitiveIjParams;
        }
        HashSet<TemplateData> all = new HashSet<TemplateData>();
        this.collectTransitiveCallees(templateData, all);
        ImmutableSortedSet.Builder ijs = ImmutableSortedSet.naturalOrder();
        for (TemplateData callee : all) {
            ijs.addAll(callee.injectedParams);
        }
        templateData.transitiveIjParams = transitiveIjParams = ijs.build();
        return transitiveIjParams;
    }

    public ImmutableList<String> getRequiredCssNamespaces(String templateName) {
        return this.getTemplateData((String)templateName).requiredCssNamespaces.asList();
    }

    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        TemplateData templateData = this.getTemplateData(templateName);
        LinkedHashSet orderedTemplateCalls = Sets.newLinkedHashSet();
        LinkedHashSet visited = Sets.newLinkedHashSet();
        this.collectTransitiveCallees(templateData, orderedTemplateCalls, visited, enabledDelpackages, collectCssFromDelvariants);
        LinkedHashSet requiredNamespaces = Sets.newLinkedHashSet();
        for (TemplateData callee : orderedTemplateCalls) {
            requiredNamespaces.addAll(callee.requiredCssNamespaces);
        }
        ImmutableList allRequiredCssNamespaces = ImmutableList.copyOf((Collection)requiredNamespaces);
        return allRequiredCssNamespaces;
    }

    @Nullable
    CompiledTemplate.Factory selectDelTemplate(String delTemplateName, String variant, Predicate<String> activeDelPackageSelector) {
        TemplateData selectedTemplate = this.selector.selectTemplate(delTemplateName, variant, activeDelPackageSelector);
        if (selectedTemplate == null) {
            return null;
        }
        if (selectedTemplate.factory == null) {
            throw new IllegalArgumentException("cannot get a factory for the private template: " + selectedTemplate.soyTemplateName());
        }
        return selectedTemplate.factory;
    }

    private TemplateData getTemplateData(String name) {
        TemplateData old;
        Preconditions.checkNotNull((Object)name);
        TemplateData template = this.templateNameToFactory.get(name);
        if (template == null && (old = this.templateNameToFactory.putIfAbsent(name, template = CompiledTemplates.loadFactory(name, this.loader))) != null) {
            return old;
        }
        return template;
    }

    private static TemplateData loadFactory(String name, ClassLoader loader) {
        Class<CompiledTemplate> templateClass;
        try {
            String templateName = Names.javaClassNameFromSoyTemplateName(name);
            templateClass = Class.forName(templateName, true, loader).asSubclass(CompiledTemplate.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("No class was compiled for template: " + name, e);
        }
        return new TemplateData(templateClass);
    }

    private void collectTransitiveCallees(TemplateData templateData, Set<TemplateData> visited) {
        if (!visited.add(templateData)) {
            return;
        }
        for (String callee : templateData.callees) {
            this.collectTransitiveCallees(this.getTemplateData(callee), visited);
        }
        for (String delCallee : templateData.delCallees) {
            for (TemplateData potentialCallee : this.selector.delTemplateNameToValues().get((Object)delCallee)) {
                this.collectTransitiveCallees(potentialCallee, visited);
            }
        }
    }

    private void collectTransitiveCallees(TemplateData templateData, Set<TemplateData> orderedTemplateCalls, Set<TemplateData> visited, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        if (templateData == null || visited.contains(templateData)) {
            return;
        }
        visited.add(templateData);
        for (String callee : templateData.callees) {
            this.collectTransitiveCallees(this.getTemplateData(callee), orderedTemplateCalls, visited, enabledDelpackages, collectCssFromDelvariants);
        }
        for (String delCallee : templateData.delCallees) {
            this.selector.delTemplateNameToValues().get((Object)delCallee).stream().map(tmpl -> tmpl.variant).filter(variant -> collectCssFromDelvariants || variant.isEmpty()).distinct().forEach(variant -> this.collectTransitiveCallees(this.selector.selectTemplate(delCallee, (String)variant, enabledDelpackages), orderedTemplateCalls, visited, enabledDelpackages, collectCssFromDelvariants));
        }
        orderedTemplateCalls.add(templateData);
    }

    @Immutable
    private static final class TemplateData {
        final Class<? extends CompiledTemplate> templateClass;
        @Nullable
        final CompiledTemplate.Factory factory;
        final SanitizedContent.ContentKind kind;
        final ImmutableSet<String> callees;
        final ImmutableSet<String> delCallees;
        final ImmutableSet<String> injectedParams;
        final ImmutableSet<String> requiredCssNamespaces;
        final Optional<String> delTemplateName;
        final Optional<String> delPackage;
        final String variant;
        @LazyInit
        ImmutableSortedSet<String> transitiveIjParams;

        TemplateData(Class<? extends CompiledTemplate> template) {
            this.templateClass = template;
            CompiledTemplate.Factory localFactory = null;
            for (Class<?> innerClass : template.getClasses()) {
                if (!innerClass.getSimpleName().equals("Factory")) continue;
                try {
                    localFactory = innerClass.asSubclass(CompiledTemplate.Factory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new AssertionError((Object)e);
                }
            }
            this.factory = localFactory;
            TemplateMetadata annotation = template.getAnnotation(TemplateMetadata.class);
            String contentKind = annotation.contentKind();
            this.kind = SanitizedContent.ContentKind.valueOf(contentKind);
            this.callees = ImmutableSet.copyOf((Object[])annotation.callees());
            this.delCallees = ImmutableSet.copyOf((Object[])annotation.delCallees());
            this.injectedParams = ImmutableSet.copyOf((Object[])annotation.injectedParams());
            this.requiredCssNamespaces = ImmutableSet.copyOf((Object[])annotation.requiredCssNames());
            TemplateMetadata.DelTemplateMetadata deltemplateMetadata = annotation.deltemplateMetadata();
            this.variant = deltemplateMetadata.variant();
            if (!deltemplateMetadata.name().isEmpty()) {
                this.delTemplateName = Optional.of(deltemplateMetadata.name());
                this.delPackage = deltemplateMetadata.delPackage().isEmpty() ? Optional.empty() : Optional.of(deltemplateMetadata.delPackage());
            } else {
                this.delTemplateName = Optional.empty();
                this.delPackage = Optional.empty();
            }
        }

        String soyTemplateName() {
            return Names.soyTemplateNameFromJavaClassName(this.templateClass.getName());
        }
    }
}

