/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_SaveRestoreState;
import com.google.template.soy.jbcsrc.AutoValue_TemplateVariableManager_VarKey;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class TemplateVariableManager
implements LocalVariableManager {
    private final FieldManager fields;
    private final SimpleLocalVariableManager delegate;
    private final Map<VarKey, AbstractVariable> variablesByKey = new LinkedHashMap<VarKey, AbstractVariable>();
    private final LocalVariable thisVar;
    private int numberOfActiveTemporaries;

    TemplateVariableManager(FieldManager fields, LocalVariable thisVar, Method method) {
        this.fields = fields;
        this.thisVar = thisVar;
        this.delegate = new SimpleLocalVariableManager(method, false);
    }

    @Override
    public Scope enterScope() {
        final LocalVariableManager.Scope delegateScope = this.delegate.enterScope();
        return new Scope(){
            final List<VarKey> activeVariables = new ArrayList<VarKey>();
            int activeTemporariesInThisScope;

            @Override
            void createTrivial(String name, Expression expression) {
                this.putVariable(VarKey.create(name), new TrivialVariable(expression));
            }

            @Override
            Variable createSynthetic(SyntheticVarName varName, Expression initExpr, SaveStrategy strategy) {
                return this.doCreate("$" + varName.name(), initExpr, VarKey.create(varName), strategy);
            }

            @Override
            Variable create(String name, Expression initExpr, SaveStrategy strategy) {
                return this.doCreate(name, initExpr, VarKey.create(name), strategy);
            }

            @Override
            public LocalVariable createLocal(String name, Type type) {
                TemplateVariableManager.this.numberOfActiveTemporaries++;
                ++this.activeTemporariesInThisScope;
                return delegateScope.createLocal(name, type);
            }

            @Override
            public Statement exitScope() {
                TemplateVariableManager.this.numberOfActiveTemporaries -= this.activeTemporariesInThisScope;
                for (VarKey key : this.activeVariables) {
                    AbstractVariable var = (AbstractVariable)TemplateVariableManager.this.variablesByKey.remove(key);
                    if (var != null) continue;
                    throw new IllegalStateException("no variable active for key: " + key);
                }
                return delegateScope.exitScope();
            }

            private Variable doCreate(String proposedName, Expression initExpr, VarKey key, SaveStrategy strategy) {
                Variable var;
                switch (strategy) {
                    case DERIVED: {
                        var = new DerivedVariable(initExpr, delegateScope.createLocal(proposedName, initExpr.resultType()));
                        break;
                    }
                    case STORE: {
                        var = new FieldSavedVariable(proposedName, initExpr, delegateScope.createLocal(proposedName, initExpr.resultType()));
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                this.putVariable(key, var);
                return var;
            }

            private void putVariable(VarKey key, AbstractVariable var) {
                AbstractVariable old = TemplateVariableManager.this.variablesByKey.put(key, var);
                if (old != null) {
                    throw new IllegalStateException("multiple variables active for key: " + key);
                }
                this.activeVariables.add(key);
            }
        };
    }

    @Override
    public void generateTableEntries(CodeBuilder ga) {
        this.delegate.generateTableEntries(ga);
    }

    Expression getVariable(String name) {
        return this.getVariable(VarKey.create(name));
    }

    Expression getVariable(SyntheticVarName name) {
        return this.getVariable(VarKey.create(name));
    }

    private Expression getVariable(VarKey varKey) {
        AbstractVariable var = this.variablesByKey.get(varKey);
        if (var != null) {
            return var.accessor();
        }
        throw new IllegalArgumentException("No variable: '" + varKey + "' is bound");
    }

    SaveRestoreState saveRestoreState() {
        if (this.numberOfActiveTemporaries > 0) {
            throw new IllegalStateException("Can't generate save/restore state when there are active non-saved temporary variables: " + this.numberOfActiveTemporaries);
        }
        ArrayList<Statement> saves = new ArrayList<Statement>();
        ArrayList<Statement> restores = new ArrayList<Statement>();
        for (AbstractVariable var : this.variablesByKey.values()) {
            saves.add(var.save());
            restores.add(var.restore());
        }
        return new AutoValue_TemplateVariableManager_SaveRestoreState(Statement.concat(saves), Statement.concat(restores));
    }

    @AutoValue
    static abstract class SaveRestoreState {
        SaveRestoreState() {
        }

        abstract Statement save();

        abstract Statement restore();
    }

    private static final class DerivedVariable
    extends Variable {
        private DerivedVariable(Expression initExpression, LocalVariable local) {
            super(initExpression, local);
        }

        @Override
        Statement save() {
            return Statement.NULL_STATEMENT;
        }

        @Override
        Statement restore() {
            return this.local.store(this.initExpression);
        }
    }

    private final class FieldSavedVariable
    extends Variable {
        final String originalProposedName;
        FieldRef field;

        private FieldSavedVariable(String originalProposedName, Expression initExpression, LocalVariable local) {
            super(initExpression, local);
            this.originalProposedName = originalProposedName;
        }

        FieldRef getField() {
            if (this.field == null) {
                this.field = TemplateVariableManager.this.fields.addGeneratedField(this.originalProposedName, this.local.resultType());
            }
            return this.field;
        }

        @Override
        Statement save() {
            return this.getField().putInstanceField(TemplateVariableManager.this.thisVar, this.local);
        }

        @Override
        Statement restore() {
            Expression fieldValue = this.getField().accessor(TemplateVariableManager.this.thisVar);
            return this.local.store(fieldValue);
        }
    }

    static abstract class Variable
    extends AbstractVariable {
        protected final Expression initExpression;
        protected final LocalVariable local;
        private final Statement initializer;

        private Variable(Expression initExpression, LocalVariable local) {
            this.initExpression = initExpression;
            this.local = local;
            this.initializer = local.store(initExpression, local.start());
        }

        final Statement initializer() {
            return this.initializer;
        }

        @Override
        final Expression accessor() {
            return this.local();
        }

        final LocalVariable local() {
            return this.local;
        }
    }

    private static final class TrivialVariable
    extends AbstractVariable {
        final Expression accessor;

        TrivialVariable(Expression accessor) {
            this.accessor = accessor;
        }

        @Override
        Statement save() {
            return Statement.NULL_STATEMENT;
        }

        @Override
        Statement restore() {
            return Statement.NULL_STATEMENT;
        }

        @Override
        Expression accessor() {
            return this.accessor;
        }
    }

    private static abstract class AbstractVariable {
        private AbstractVariable() {
        }

        abstract Statement save();

        abstract Statement restore();

        abstract Expression accessor();
    }

    @AutoValue
    static abstract class VarKey {
        VarKey() {
        }

        static VarKey create(String proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.USER_DEFINED, proposedName);
        }

        static VarKey create(SyntheticVarName proposedName) {
            return new AutoValue_TemplateVariableManager_VarKey(Kind.SYNTHETIC, proposedName);
        }

        abstract Kind kind();

        abstract Object name();

        static enum Kind {
            USER_DEFINED,
            SYNTHETIC;

        }
    }

    static abstract class Scope
    implements LocalVariableManager.Scope {
        private Scope() {
        }

        abstract void createTrivial(String var1, Expression var2);

        abstract Variable createSynthetic(SyntheticVarName var1, Expression var2, SaveStrategy var3);

        abstract Variable create(String var1, Expression var2, SaveStrategy var3);
    }

    static enum SaveStrategy {
        DERIVED,
        STORE;

    }
}

