/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.internal.UniqueNameGenerator;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.internal.JbcSrcNameGenerators;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class SimpleLocalVariableManager
implements LocalVariableManager {
    private final UniqueNameGenerator localNames = JbcSrcNameGenerators.forFieldNames();
    private final List<LocalVariable> allVariables = new ArrayList<LocalVariable>();
    private final BitSet availableSlots = new BitSet();
    private boolean generated;

    SimpleLocalVariableManager(Method method, boolean isStatic) {
        if (!isStatic) {
            this.reserveSlotFor(BytecodeUtils.OBJECT.type());
            this.localNames.claimName("this");
        }
        for (Type type : method.getArgumentTypes()) {
            this.reserveSlotFor(type);
        }
    }

    @Override
    public void generateTableEntries(CodeBuilder cb) {
        this.generated = true;
        for (LocalVariable var : this.allVariables) {
            try {
                var.tableEntry(cb);
            }
            catch (Throwable t) {
                throw new RuntimeException("unable to write table entry for: " + var, t);
            }
        }
    }

    @Override
    public LocalVariableManager.Scope enterScope() {
        Preconditions.checkState((!this.generated ? 1 : 0) != 0);
        final ArrayList frame = new ArrayList();
        return new LocalVariableManager.Scope(){
            final Label scopeExit = new Label();
            boolean exited;

            @Override
            public LocalVariable createLocal(String proposedName, Type type) {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                String name = SimpleLocalVariableManager.this.localNames.generateName(proposedName);
                int slot = SimpleLocalVariableManager.this.reserveSlotFor(type);
                LocalVariable var = LocalVariable.createLocal(name, slot, type, new Label(), this.scopeExit);
                frame.add(var);
                return var;
            }

            @Override
            public Statement exitScope() {
                Preconditions.checkState((!SimpleLocalVariableManager.this.generated ? 1 : 0) != 0);
                Preconditions.checkState((!this.exited ? 1 : 0) != 0);
                this.exited = true;
                for (LocalVariable var : frame) {
                    SimpleLocalVariableManager.this.availableSlots.clear(var.index(), var.index() + var.resultType().getSize());
                }
                return new Statement(){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        adapter.mark(scopeExit);
                    }
                };
            }
        };
    }

    private int reserveSlotFor(Type type) {
        int size = type.getSize();
        Preconditions.checkArgument((size == 1 || size == 2 ? 1 : 0) != 0);
        int start = 0;
        while (start < 65536) {
            int nextClear = this.availableSlots.nextClearBit(start);
            if (size == 1 || size == 2 && !this.availableSlots.get(nextClear + 1)) {
                this.availableSlots.set(nextClear, nextClear + size);
                return nextClear;
            }
            start = nextClear + 1;
        }
        throw new RuntimeException("too many local variables");
    }
}

