/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.jbcsrc.AbstractTemplateParameterLookup;
import com.google.template.soy.jbcsrc.AppendableExpression;
import com.google.template.soy.jbcsrc.AutoValue_LazyClosureCompiler_LazyClosure;
import com.google.template.soy.jbcsrc.AutoValue_LazyClosureCompiler_ParentCapture;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionToSoyValueProviderCompiler;
import com.google.template.soy.jbcsrc.ExtraCodeCompiler;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.RenderContextExpression;
import com.google.template.soy.jbcsrc.SimpleLocalVariableManager;
import com.google.template.soy.jbcsrc.SoyNodeCompiler;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.ConstructorRef;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.runtime.DetachableContentProvider;
import com.google.template.soy.jbcsrc.runtime.DetachableSoyValueProvider;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class LazyClosureCompiler {
    private static final int LAZY_CLOSURE_ACCESS = 16;
    private static final Method DO_RESOLVE;
    private static final Method DO_RENDER;
    private static final Method DETACHABLE_CONTENT_PROVIDER_INIT;
    private static final FieldRef RESOLVED_VALUE;
    private static final TypeInfo DETACHABLE_CONTENT_PROVIDER_TYPE;
    private static final TypeInfo DETACHABLE_VALUE_PROVIDER_TYPE;
    private final CompiledTemplateRegistry registry;
    private final InnerClasses innerClasses;
    private final AbstractTemplateParameterLookup parentVariableLookup;
    private final ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler;
    private final ExpressionCompiler.BasicExpressionCompiler parentConstantCompiler;
    private final FieldManager parentFields;
    private final ErrorReporter reporter;
    private final SoyTypeRegistry typeRegistry;

    LazyClosureCompiler(CompiledTemplateRegistry registry, InnerClasses innerClasses, AbstractTemplateParameterLookup parentVariableLookup, FieldManager parentFields, ExpressionToSoyValueProviderCompiler expressionToSoyValueProviderCompiler, ExpressionCompiler.BasicExpressionCompiler parentConstantCompiler, ErrorReporter reporter, SoyTypeRegistry typeRegistry) {
        this.registry = registry;
        this.innerClasses = innerClasses;
        this.parentVariableLookup = parentVariableLookup;
        this.parentFields = parentFields;
        this.parentConstantCompiler = parentConstantCompiler;
        this.expressionToSoyValueProviderCompiler = expressionToSoyValueProviderCompiler;
        this.reporter = reporter;
        this.typeRegistry = typeRegistry;
    }

    LazyClosure compileLazyExpression(String namePrefix, SoyNode declaringNode, String varName, ExprRootNode exprNode) {
        if (ExpressionCompiler.canCompileToConstant(exprNode)) {
            SoyExpression expression = this.parentConstantCompiler.compile(exprNode);
            return LazyClosure.create(varName, this.parentFields.addStaticField(this.getProposedName(namePrefix, varName), expression.boxAsSoyValueProvider()).accessor(), true);
        }
        Optional<Expression> asSoyValueProvider = this.expressionToSoyValueProviderCompiler.compileAvoidingDetaches(exprNode);
        if (asSoyValueProvider.isPresent()) {
            Expression svp = asSoyValueProvider.get();
            return LazyClosure.create(varName, svp, exprNode.getRoot().getKind() == ExprNode.Kind.VAR_REF_NODE);
        }
        TypeInfo type = this.innerClasses.registerInnerClassWithGeneratedName(this.getProposedName(namePrefix, varName), 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_VALUE_PROVIDER_TYPE).sourceFileName(declaringNode.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(writer, type, DETACHABLE_VALUE_PROVIDER_TYPE, declaringNode).compileExpression(exprNode);
        this.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.innerClasses.add(writer.toClassData());
        return LazyClosure.create(varName, expr, false);
    }

    LazyClosure compileLazyContent(String namePrefix, SoyNode.RenderUnitNode renderUnit, String varName) {
        return this.compileLazyContent(namePrefix, renderUnit, varName, ExtraCodeCompiler.NO_OP, ExtraCodeCompiler.NO_OP);
    }

    LazyClosure compileLazyContent(String namePrefix, SoyNode.RenderUnitNode renderUnit, String varName, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
        Optional asRawText;
        String proposedName = this.getProposedName(namePrefix, varName);
        Optional<Object> optional = asRawText = prefix != ExtraCodeCompiler.NO_OP && suffix != ExtraCodeCompiler.NO_OP ? this.asRawTextOnly(proposedName, renderUnit) : Optional.empty();
        if (asRawText.isPresent()) {
            return LazyClosure.create(varName, (Expression)asRawText.get(), true);
        }
        TypeInfo type = this.innerClasses.registerInnerClassWithGeneratedName(proposedName, 16);
        SoyClassWriter writer = SoyClassWriter.builder(type).setAccess(16).extending(DETACHABLE_CONTENT_PROVIDER_TYPE).sourceFileName(renderUnit.getSourceLocation().getFileName()).build();
        Expression expr = new CompilationUnit(writer, type, DETACHABLE_CONTENT_PROVIDER_TYPE, renderUnit).compileRenderable(renderUnit, prefix, suffix);
        this.innerClasses.registerAsInnerClass(writer, type);
        writer.visitEnd();
        this.innerClasses.add(writer.toClassData());
        return LazyClosure.create(varName, expr, false);
    }

    private Optional<Expression> asRawTextOnly(String name, SoyNode.RenderUnitNode renderUnit) {
        StringBuilder builder = null;
        ArrayList children = new ArrayList(renderUnit.getChildren());
        for (int i = 0; i < children.size(); ++i) {
            SoyNode child = (SoyNode)children.get(i);
            if (child instanceof MsgHtmlTagNode) {
                children.addAll(i + 1, ((MsgHtmlTagNode)child).getChildren());
                continue;
            }
            if (child instanceof RawTextNode) {
                if (builder == null) {
                    builder = new StringBuilder();
                }
                builder.append(((RawTextNode)child).getRawText());
                continue;
            }
            return Optional.empty();
        }
        Expression value = BytecodeUtils.constant(builder == null ? "" : builder.toString(), this.parentFields);
        SanitizedContentKind kind = renderUnit.getContentKind();
        value = kind == SanitizedContentKind.TEXT ? MethodRef.STRING_DATA_FOR_VALUE.invoke(value) : MethodRef.ORDAIN_AS_SAFE.invoke(value, BytecodeUtils.constantSanitizedContentKindAsContentKind(kind));
        FieldRef staticField = this.parentFields.addStaticField(name, value);
        return Optional.of(staticField.accessor());
    }

    private String getProposedName(String prefix, String varName) {
        return prefix + "_" + varName;
    }

    static {
        RESOLVED_VALUE = FieldRef.instanceFieldReference(DetachableSoyValueProvider.class, "resolvedValue");
        DETACHABLE_CONTENT_PROVIDER_TYPE = TypeInfo.create(DetachableContentProvider.class);
        DETACHABLE_VALUE_PROVIDER_TYPE = TypeInfo.create(DetachableSoyValueProvider.class);
        try {
            DO_RESOLVE = Method.getMethod((java.lang.reflect.Method)DetachableSoyValueProvider.class.getDeclaredMethod("doResolve", new Class[0]));
            DO_RENDER = Method.getMethod((java.lang.reflect.Method)DetachableContentProvider.class.getDeclaredMethod("doRender", LoggingAdvisingAppendable.class));
            DETACHABLE_CONTENT_PROVIDER_INIT = Method.getMethod(DetachableContentProvider.class.getDeclaredConstructor(SanitizedContent.ContentKind.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static final class LazyClosureParameterLookup
    extends AbstractTemplateParameterLookup {
        private final CompilationUnit params;
        private final AbstractTemplateParameterLookup parentParameterLookup;
        private final TemplateVariableManager variableSet;
        private final Expression thisVar;
        private final Map<LocalVar, ParentCapture> localFields = new LinkedHashMap<LocalVar, ParentCapture>();
        private final Map<SyntheticVarName, ParentCapture> syntheticFields = new LinkedHashMap<SyntheticVarName, ParentCapture>();
        private ParentCapture renderContextCapture;
        private ParentCapture templateCapture;

        LazyClosureParameterLookup(CompilationUnit params, AbstractTemplateParameterLookup parentParameterLookup, TemplateVariableManager variableSet, Expression thisVar) {
            this.params = params;
            this.parentParameterLookup = parentParameterLookup;
            this.variableSet = variableSet;
            this.thisVar = thisVar;
        }

        @Override
        public FieldRef getParamField(TemplateParam param) {
            return this.parentParameterLookup.getParamField(param);
        }

        @Override
        public Expression getLocal(LocalVar local) {
            if (SoyTreeUtils.isDescendantOf(local.declaringNode(), this.params.node)) {
                return this.variableSet.getVariable(local.name());
            }
            ParentCapture capturedField = this.localFields.get(local);
            if (capturedField == null) {
                Expression expression = this.parentParameterLookup.getLocal(local);
                FieldRef field = this.params.fields.addGeneratedFinalField(local.name(), expression.resultType());
                capturedField = ParentCapture.create(field, expression);
                this.localFields.put(local, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        @Override
        public Expression getLocal(SyntheticVarName varName) {
            if (SoyTreeUtils.isDescendantOf(varName.declaringNode(), this.params.node)) {
                return this.variableSet.getVariable(varName);
            }
            ParentCapture capturedField = this.syntheticFields.get(varName);
            if (capturedField == null) {
                Expression expression = this.parentParameterLookup.getLocal(varName);
                FieldRef field = this.params.fields.addGeneratedFinalField(varName.name(), expression.resultType());
                capturedField = ParentCapture.create(field, expression);
                this.syntheticFields.put(varName, capturedField);
            }
            return capturedField.field().accessor(this.thisVar);
        }

        Iterable<ParentCapture> getCapturedFields() {
            return Iterables.concat((Iterable)Iterables.filter(Arrays.asList(this.renderContextCapture, this.templateCapture), Objects::nonNull), this.localFields.values(), this.syntheticFields.values());
        }

        @Override
        public RenderContextExpression getRenderContext() {
            if (this.renderContextCapture == null) {
                this.renderContextCapture = ParentCapture.create(this.params.fields.addFinalField("$renderContext", BytecodeUtils.RENDER_CONTEXT_TYPE), this.parentParameterLookup.getRenderContext());
            }
            return new RenderContextExpression(this.renderContextCapture.field().accessor(this.thisVar));
        }

        @Override
        Expression getCompiledTemplate() {
            if (this.templateCapture == null) {
                Expression compiledTemplate = this.parentParameterLookup.getCompiledTemplate();
                this.templateCapture = ParentCapture.create(this.params.fields.addFinalField("$template", compiledTemplate.resultType()), compiledTemplate);
            }
            return this.templateCapture.field().accessor(this.thisVar);
        }

        @Override
        FieldRef getParamsRecordField() {
            return this.parentParameterLookup.getParamsRecordField();
        }

        @Override
        FieldRef getIjRecordField() {
            return this.parentParameterLookup.getIjRecordField();
        }
    }

    @AutoValue
    static abstract class ParentCapture {
        ParentCapture() {
        }

        static ParentCapture create(FieldRef captureField, Expression parentExpression) {
            if (parentExpression.isNonNullable()) {
                captureField = captureField.asNonNull();
            }
            return new AutoValue_LazyClosureCompiler_ParentCapture(captureField, parentExpression);
        }

        abstract FieldRef field();

        abstract Expression parentExpression();
    }

    private final class CompilationUnit {
        final FieldManager fields;
        final TypeInfo type;
        final TypeInfo baseClass;
        final SoyNode node;
        final SoyClassWriter writer;

        CompilationUnit(SoyClassWriter writer, TypeInfo type, TypeInfo baseClass, SoyNode node) {
            this.writer = writer;
            this.fields = new FieldManager(type);
            this.type = type;
            this.baseClass = baseClass;
            this.node = node;
        }

        Expression compileExpression(ExprNode exprNode) {
            final Label start = new Label();
            final Label end = new Label();
            LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            TemplateVariableManager variableSet = new TemplateVariableManager(this.fields, thisVar, DO_RESOLVE);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, LazyClosureCompiler.this.parentVariableLookup, variableSet, thisVar);
            SoyExpression compile = ExpressionCompiler.createBasicCompiler(lookup, variableSet, this.fields, LazyClosureCompiler.this.reporter, LazyClosureCompiler.this.typeRegistry).compile(exprNode);
            SoyExpression expression = compile.box();
            final Statement storeExpr = RESOLVED_VALUE.putInstanceField(thisVar, expression);
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement doResolveImpl = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    storeExpr.gen(adapter);
                    returnDone.gen(adapter);
                    adapter.mark(end);
                }
            };
            Expression constructExpr = this.generateConstructor(new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    adapter.invokeConstructor(CompilationUnit.this.baseClass.type(), BytecodeUtils.NULLARY_INIT);
                }
            }, lookup.getCapturedFields());
            doResolveImpl.writeMethod(4, DO_RESOLVE, this.writer);
            this.fields.defineFields(this.writer);
            this.fields.defineStaticInitializer(this.writer);
            return constructExpr;
        }

        Expression compileRenderable(SoyNode.RenderUnitNode renderUnit, ExtraCodeCompiler prefix, ExtraCodeCompiler suffix) {
            final Label start = new Label();
            final Label end = new Label();
            final LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            final LocalVariable appendableVar = LocalVariable.createLocal("appendable", 1, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, start, end).asNonNullable();
            ExpressionCompiler.BasicExpressionCompiler constantCompiler = ExpressionCompiler.createConstantCompiler(new SimpleLocalVariableManager(BytecodeUtils.CLASS_INIT, true), this.fields, LazyClosureCompiler.this.reporter, LazyClosureCompiler.this.typeRegistry);
            final TemplateVariableManager variableSet = new TemplateVariableManager(this.fields, thisVar, DO_RENDER);
            LazyClosureParameterLookup lookup = new LazyClosureParameterLookup(this, LazyClosureCompiler.this.parentVariableLookup, variableSet, thisVar);
            SoyNodeCompiler soyNodeCompiler = SoyNodeCompiler.create(LazyClosureCompiler.this.registry, LazyClosureCompiler.this.innerClasses, thisVar, AppendableExpression.forLocal(appendableVar), variableSet, lookup, this.fields, constantCompiler, LazyClosureCompiler.this.reporter, LazyClosureCompiler.this.typeRegistry);
            SoyNodeCompiler.CompiledMethodBody compileChildren = soyNodeCompiler.compile(renderUnit, prefix, suffix);
            this.writer.setNumDetachStates(compileChildren.numberOfDetachStates());
            final Statement nodeBody = compileChildren.body();
            final Statement returnDone = Statement.returnExpression(MethodRef.RENDER_RESULT_DONE.invoke(new Expression[0]));
            Statement fullMethodBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.mark(start);
                    nodeBody.gen(adapter);
                    adapter.mark(end);
                    returnDone.gen(adapter);
                    thisVar.tableEntry(adapter);
                    appendableVar.tableEntry(adapter);
                    variableSet.generateTableEntries(adapter);
                }
            };
            SanitizedContentKind kind = renderUnit.getContentKind();
            final Expression contentKind = BytecodeUtils.constantSanitizedContentKindAsContentKind(kind);
            Statement superClassContstructor = new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.loadThis();
                    contentKind.gen(adapter);
                    adapter.invokeConstructor(CompilationUnit.this.baseClass.type(), DETACHABLE_CONTENT_PROVIDER_INIT);
                }
            };
            Expression constructExpr = this.generateConstructor(superClassContstructor, lookup.getCapturedFields());
            this.fields.defineFields(this.writer);
            fullMethodBody.writeMethod(4, DO_RENDER, this.writer);
            this.fields.defineStaticInitializer(this.writer);
            return constructExpr;
        }

        Expression generateConstructor(final Statement superClassConstructorInvocation, Iterable<ParentCapture> captures) {
            final Label start = new Label();
            final Label end = new Label();
            final LocalVariable thisVar = LocalVariable.createThisVar(this.type, start, end);
            final ArrayList<LocalVariable> params = new ArrayList<LocalVariable>();
            ArrayList<Type> paramTypes = new ArrayList<Type>();
            final ArrayList<Statement> assignments = new ArrayList<Statement>();
            ArrayList<Expression> argExpressions = new ArrayList<Expression>();
            int index = 1;
            for (ParentCapture capture : captures) {
                FieldRef field = capture.field();
                LocalVariable var = LocalVariable.createLocal(field.name(), index, field.type(), start, end);
                assignments.add(field.putInstanceField(thisVar, var));
                argExpressions.add(capture.parentExpression());
                params.add(var);
                paramTypes.add(field.type());
                index += field.type().getSize();
            }
            Statement constructorBody = new Statement(){

                @Override
                protected void doGen(CodeBuilder cb) {
                    cb.mark(start);
                    superClassConstructorInvocation.gen(cb);
                    for (Statement assignment : assignments) {
                        assignment.gen(cb);
                    }
                    cb.returnValue();
                    cb.mark(end);
                    thisVar.tableEntry(cb);
                    for (LocalVariable local : params) {
                        local.tableEntry(cb);
                    }
                }
            };
            ConstructorRef constructor = ConstructorRef.create(this.type, paramTypes);
            constructorBody.writeMethod(1, constructor.method(), this.writer);
            return constructor.construct(argExpressions);
        }
    }

    @AutoValue
    static abstract class LazyClosure {
        LazyClosure() {
        }

        static LazyClosure create(String name, Expression soyValueProvider, boolean isTrivial) {
            soyValueProvider.checkAssignableTo(BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
            return new AutoValue_LazyClosureCompiler_LazyClosure(name, soyValueProvider, isTrivial);
        }

        abstract String name();

        abstract Expression soyValueProvider();

        abstract boolean isTrivial();
    }
}

