/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.MethodSignature;
import javax.annotation.Nullable;

final class JbcSrcJavaValue
implements JavaValue {
    private final Expression expr;
    @Nullable
    private final MethodSignature methodSignature;
    private final boolean constantNull;

    static JbcSrcJavaValue of(Expression expr) {
        return new JbcSrcJavaValue(expr, null, false);
    }

    static JbcSrcJavaValue of(Expression expr, MethodSignature methodSignature) {
        Preconditions.checkNotNull((Object)methodSignature);
        return new JbcSrcJavaValue(expr, methodSignature, false);
    }

    static JbcSrcJavaValue ofConstantNull() {
        return new JbcSrcJavaValue(SoyExpression.NULL, null, true);
    }

    private JbcSrcJavaValue(Expression expr, MethodSignature methodSignature, boolean constantNull) {
        this.expr = (Expression)Preconditions.checkNotNull((Object)expr);
        this.methodSignature = methodSignature;
        this.constantNull = constantNull;
    }

    Expression expr() {
        return this.expr;
    }

    public boolean isConstantNull() {
        return this.constantNull;
    }

    @Nullable
    MethodSignature methodInfo() {
        return this.methodSignature;
    }

    @Override
    public JbcSrcJavaValue isNonNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNonNull(this.expr));
    }

    @Override
    public JbcSrcJavaValue isNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNull(this.expr));
    }

    @Override
    public JbcSrcJavaValue asSoyBoolean() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyFloat() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyInt() {
        return this;
    }

    @Override
    public JbcSrcJavaValue asSoyString() {
        return this;
    }

    @Override
    public JbcSrcJavaValue coerceToSoyBoolean() {
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToBoolean(), this.methodSignature, false);
    }

    @Override
    public JbcSrcJavaValue coerceToSoyString() {
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToString(), this.methodSignature, false);
    }

    public String toString() {
        String methodStr = this.methodSignature == null ? "" : ", methodSignature= " + this.methodSignature;
        return "JbcSrcJavaValue[expr=" + this.expr + methodStr + "]";
    }
}

