/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.TemplateVariableManager;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class ExpressionToSoyValueProviderCompiler {
    private final TemplateParameterLookup variables;
    private final ExpressionCompiler exprCompiler;
    private final TemplateVariableManager varManager;

    static ExpressionToSoyValueProviderCompiler create(TemplateVariableManager varManager, ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        return new ExpressionToSoyValueProviderCompiler(varManager, exprCompiler, variables);
    }

    private ExpressionToSoyValueProviderCompiler(TemplateVariableManager varManager, ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        this.exprCompiler = exprCompiler;
        this.variables = variables;
        this.varManager = varManager;
    }

    Optional<Expression> compileAvoidingBoxing(ExprNode node, Label reattachPoint) {
        Preconditions.checkNotNull((Object)node);
        return (Optional)new CompilerVisitor(this.variables, this.varManager, null, this.exprCompiler.asBasicCompiler(reattachPoint)).exec(node);
    }

    Optional<Expression> compileAvoidingDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        return (Optional)new CompilerVisitor(this.variables, this.varManager, this.exprCompiler, null).exec(node);
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<Optional<Expression>> {
        final TemplateParameterLookup variables;
        final TemplateVariableManager varManager;
        @Nullable
        final ExpressionCompiler exprCompiler;
        @Nullable
        final ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler;

        CompilerVisitor(TemplateParameterLookup variables, TemplateVariableManager varManager, @Nullable ExpressionCompiler exprCompiler, @Nullable ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler) {
            this.variables = variables;
            Preconditions.checkArgument((exprCompiler == null != (detachingExprCompiler == null) ? 1 : 0) != 0);
            this.exprCompiler = exprCompiler;
            this.detachingExprCompiler = detachingExprCompiler;
            this.varManager = varManager;
        }

        private boolean allowsBoxing() {
            return this.exprCompiler != null;
        }

        private boolean allowsDetaches() {
            return this.detachingExprCompiler != null;
        }

        @Override
        protected final Optional<Expression> visitExprRootNode(ExprRootNode node) {
            return (Optional)this.visit(node.getRoot());
        }

        @Override
        protected Optional<Expression> visitNullNode(NullNode node) {
            return Optional.of(FieldRef.NULL_PROVIDER.accessor());
        }

        @Override
        protected Optional<Expression> visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            if (this.allowsDetaches()) {
                Optional right = (Optional)this.visit(node.getRightChild());
                if (!right.isPresent()) {
                    return Optional.empty();
                }
                Expression left = this.detachingExprCompiler.compile(node.getLeftChild()).box().checkedCast(SoyValueProvider.class);
                return Optional.of(BytecodeUtils.firstNonNull(left, (Expression)right.get()));
            }
            return this.visitExprNode(node);
        }

        @Override
        protected final Optional<Expression> visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            if (this.allowsDetaches()) {
                Optional trueBranch = (Optional)this.visit(node.getChild(1));
                Optional falseBranch = (Optional)this.visit(node.getChild(2));
                if (!trueBranch.isPresent() || !falseBranch.isPresent()) {
                    return Optional.empty();
                }
                SoyExpression condition = this.detachingExprCompiler.compile(node.getChild(0)).coerceToBoolean();
                return Optional.of(BytecodeUtils.ternary(condition, (Expression)trueBranch.get(), (Expression)falseBranch.get()));
            }
            return this.visitExprNode(node);
        }

        @Override
        Optional<Expression> visitForLoopVar(VarRefNode varRef, LocalVar local) {
            Expression loopVar = this.variables.getLocal(local);
            if (loopVar.resultType().equals((Object)Type.LONG_TYPE)) {
                if (this.allowsBoxing()) {
                    return Optional.of(SoyExpression.forInt(loopVar).box());
                }
                return Optional.empty();
            }
            return Optional.of(loopVar);
        }

        @Override
        Optional<Expression> visitParam(VarRefNode varRef, TemplateParam param) {
            return Optional.of(this.variables.getParam(param));
        }

        @Override
        Optional<Expression> visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            return Optional.of(this.variables.getLocal(local));
        }

        @Override
        protected Optional<Expression> visitDataAccessNode(DataAccessNode node) {
            return this.visitExprNode(node);
        }

        @Override
        protected final Optional<Expression> visitExprNode(ExprNode node) {
            Optional<SoyExpression> compileWithNoDetaches;
            if (this.allowsBoxing() && (compileWithNoDetaches = this.exprCompiler.compileWithNoDetaches(node)).isPresent()) {
                return Optional.of(compileWithNoDetaches.get().boxAsSoyValueProvider());
            }
            return Optional.empty();
        }
    }
}

