/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.FieldManager;
import com.google.template.soy.jbcsrc.JbcSrcValueFactory;
import com.google.template.soy.jbcsrc.LocalVariableManager;
import com.google.template.soy.jbcsrc.ProtoUtils;
import com.google.template.soy.jbcsrc.SyntheticVarName;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.FieldRef;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class ExpressionCompiler {
    @Nullable
    private final TemplateParameterLookup parameters;
    private final LocalVariableManager varManager;
    private final FieldManager fields;
    private final ExpressionDetacher.Factory detacherFactory;
    private final ErrorReporter reporter;
    private final SoyTypeRegistry registry;

    static ExpressionCompiler create(ExpressionDetacher.Factory detacherFactory, TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry) {
        return new ExpressionCompiler(detacherFactory, (TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters), varManager, fields, reporter, registry);
    }

    static BasicExpressionCompiler createConstantCompiler(LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry) {
        return new BasicExpressionCompiler(new CompilerVisitor(null, varManager, fields, ExpressionDetacher.NullDetatcher.INSTANCE, reporter, registry));
    }

    static BasicExpressionCompiler createBasicCompiler(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry) {
        return new BasicExpressionCompiler((TemplateParameterLookup)Preconditions.checkNotNull((Object)parameters), varManager, fields, reporter, registry);
    }

    static boolean canCompileToConstant(ExprNode expr) {
        return (Boolean)CanCompileToConstantVisitor.INSTANCE.exec(expr);
    }

    private ExpressionCompiler(ExpressionDetacher.Factory detacherFactory, @Nullable TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry) {
        this.detacherFactory = detacherFactory;
        this.parameters = parameters;
        this.varManager = (LocalVariableManager)Preconditions.checkNotNull((Object)varManager);
        this.fields = (FieldManager)Preconditions.checkNotNull((Object)fields);
        this.reporter = reporter;
        this.registry = registry;
    }

    SoyExpression compile(ExprNode node, Label reattachPoint) {
        return this.asBasicCompiler(reattachPoint).compile(node);
    }

    SoyExpression compile(ExprNode node) {
        Label reattachPoint = new Label();
        SoyExpression exec = this.compile(node, reattachPoint);
        return exec.withSource(exec.labelStart(reattachPoint));
    }

    Optional<SoyExpression> compileWithNoDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        if (((Boolean)RequiresDetachVisitor.INSTANCE.exec(node)).booleanValue()) {
            return Optional.empty();
        }
        return Optional.of((SoyExpression)new CompilerVisitor(this.parameters, this.varManager, this.fields, null, this.reporter, this.registry).exec(node));
    }

    BasicExpressionCompiler asBasicCompiler(Label reattachPoint) {
        return new BasicExpressionCompiler(new CompilerVisitor(this.parameters, this.varManager, this.fields, this.detacherFactory.createExpressionDetacher(reattachPoint), this.reporter, this.registry));
    }

    private static final class RequiresDetachVisitor
    extends EnhancedAbstractExprNodeVisitor<Boolean> {
        static final RequiresDetachVisitor INSTANCE = new RequiresDetachVisitor();

        private RequiresDetachVisitor() {
        }

        @Override
        Boolean visitForLoopVar(VarRefNode varRef, LocalVar local) {
            return true;
        }

        @Override
        Boolean visitParam(VarRefNode varRef, TemplateParam param) {
            return true;
        }

        @Override
        Boolean visitLetNodeVar(VarRefNode node, LocalVar local) {
            return true;
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return true;
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            for (Boolean i : this.visitChildren(node)) {
                if (!i.booleanValue()) continue;
                return true;
            }
            SoyProtoType protoType = (SoyProtoType)node.getType();
            for (Identifier paramName : node.getParamNames()) {
                if (!protoType.getFieldDescriptor(paramName.identifier()).isRepeated()) continue;
                return true;
            }
            return false;
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                for (Boolean i : this.visitChildren((ExprNode.ParentExprNode)node)) {
                    if (!i.booleanValue()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private static final class CanCompileToConstantVisitor
    extends AbstractReturningExprNodeVisitor<Boolean> {
        static final CanCompileToConstantVisitor INSTANCE = new CanCompileToConstantVisitor();

        private CanCompileToConstantVisitor() {
        }

        @Override
        protected Boolean visitExprRootNode(ExprRootNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitVarRefNode(VarRefNode node) {
            return false;
        }

        @Override
        protected Boolean visitPrimitiveNode(ExprNode.PrimitiveNode node) {
            return true;
        }

        @Override
        protected Boolean visitVeLiteralNode(VeLiteralNode node) {
            return true;
        }

        @Override
        protected Boolean visitGlobalNode(GlobalNode node) {
            return true;
        }

        @Override
        protected Boolean visitListLiteralNode(ListLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitRecordLiteralNode(RecordLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitMapLiteralNode(MapLiteralNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitDataAccessNode(DataAccessNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitOperatorNode(ExprNode.OperatorNode node) {
            return this.areAllChildrenConstant(node);
        }

        @Override
        protected Boolean visitFunctionNode(FunctionNode node) {
            if (!this.areAllChildrenConstant(node)) {
                return false;
            }
            if (!node.getSoyFunction().getClass().isAnnotationPresent(SoyPureFunction.class)) {
                return false;
            }
            if (node.getSoyFunction() instanceof SoyJavaSourceFunction) {
                try {
                    PluginAnalyzer.PluginMetadata metadata = PluginAnalyzer.analyze((SoyJavaSourceFunction)node.getSoyFunction());
                    return metadata.pluginInstanceNames().isEmpty() && !metadata.accessesContext();
                }
                catch (Throwable ignored) {
                    return false;
                }
            }
            return false;
        }

        private boolean areAllChildrenConstant(ExprNode.ParentExprNode node) {
            for (ExprNode child : node.getChildren()) {
                if (((Boolean)this.visit(child)).booleanValue()) continue;
                return false;
            }
            return true;
        }
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<SoyExpression> {
        @Nullable
        final ExpressionDetacher detacher;
        @Nullable
        final TemplateParameterLookup parameters;
        final LocalVariableManager varManager;
        final FieldManager fields;
        final ErrorReporter reporter;
        final SoyTypeRegistry registry;

        CompilerVisitor(@Nullable TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ExpressionDetacher detacher, ErrorReporter reporter, SoyTypeRegistry registry) {
            this.detacher = detacher;
            this.parameters = parameters;
            this.varManager = varManager;
            this.fields = fields;
            this.reporter = reporter;
            this.registry = registry;
        }

        @Override
        protected final SoyExpression visit(ExprNode node) {
            return ((SoyExpression)super.visit(node)).withSourceLocation(node.getSourceLocation());
        }

        @Override
        protected final SoyExpression visitExprRootNode(ExprRootNode node) {
            return this.visit(node.getRoot());
        }

        @Override
        protected final SoyExpression visitNullNode(NullNode node) {
            return SoyExpression.NULL;
        }

        @Override
        protected final SoyExpression visitFloatNode(FloatNode node) {
            return SoyExpression.forFloat(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitStringNode(StringNode node) {
            return SoyExpression.forString(BytecodeUtils.constant(node.getValue(), this.fields));
        }

        @Override
        protected final SoyExpression visitBooleanNode(BooleanNode node) {
            return node.getValue() ? SoyExpression.TRUE : SoyExpression.FALSE;
        }

        @Override
        protected final SoyExpression visitIntegerNode(IntegerNode node) {
            return SoyExpression.forInt(BytecodeUtils.constant(node.getValue()));
        }

        @Override
        protected final SoyExpression visitGlobalNode(GlobalNode node) {
            return this.visit(node.getValue());
        }

        @Override
        protected final SoyExpression visitListLiteralNode(ListLiteralNode node) {
            return SoyExpression.forList((ListType)node.getType(), SoyExpression.asBoxedList(this.visitChildren(node)));
        }

        @Override
        protected final SoyExpression visitRecordLiteralNode(RecordLiteralNode node) {
            int numItems = node.numChildren();
            if (numItems == 0) {
                return SoyExpression.forSoyValue(node.getType(), FieldRef.EMPTY_DICT.accessor());
            }
            ArrayList<Expression> keys = new ArrayList<Expression>(numItems);
            ArrayList<SoyExpression> values = new ArrayList<SoyExpression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(BytecodeUtils.constant(node.getKey(i).identifier()));
                values.add(this.visit(node.getChild(i)).box());
            }
            Expression soyDict = MethodRef.DICT_IMPL_FOR_PROVIDER_MAP.invoke(BytecodeUtils.newLinkedHashMap(keys, values), FieldRef.enumReference(RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD).accessor());
            return SoyExpression.forSoyValue(node.getType(), soyDict);
        }

        @Override
        protected final SoyExpression visitMapLiteralNode(MapLiteralNode node) {
            int numItems = node.numChildren() / 2;
            if (numItems == 0) {
                return SoyExpression.forSoyValue(node.getType(), FieldRef.EMPTY_MAP.accessor());
            }
            ArrayList<SoyExpression> keys = new ArrayList<SoyExpression>(numItems);
            ArrayList<SoyExpression> values = new ArrayList<SoyExpression>(numItems);
            for (int i = 0; i < numItems; ++i) {
                keys.add(this.visit(node.getChild(2 * i)).box());
                values.add(this.visit(node.getChild(2 * i + 1)).box());
            }
            Expression soyDict = MethodRef.MAP_IMPL_FOR_PROVIDER_MAP.invoke(BytecodeUtils.newHashMap(keys, values));
            return SoyExpression.forSoyValue(node.getType(), soyDict);
        }

        @Override
        protected final SoyExpression visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1))));
        }

        @Override
        protected final SoyExpression visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(BytecodeUtils.compareSoyEquals(this.visit(node.getChild(0)), this.visit(node.getChild(1)))));
        }

        @Override
        protected final SoyExpression visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(155, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(155, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(157, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(157, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN.invoke(right.box(), left.box()));
        }

        @Override
        protected final SoyExpression visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(158, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(158, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.unboxAsLong(), right.unboxAsLong()));
            }
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                return SoyExpression.forBool(BytecodeUtils.compare(156, left.coerceToDouble(), right.coerceToDouble()));
            }
            if (left.assignableToNullableString() && right.assignableToNullableString()) {
                return this.createStringComparisonOperator(156, left, right);
            }
            return SoyExpression.forBool(MethodRef.RUNTIME_LESS_THAN_OR_EQUAL.invoke(right.box(), left.box()));
        }

        private SoyExpression createStringComparisonOperator(int operator, SoyExpression left, SoyExpression right) {
            return SoyExpression.forBool(BytecodeUtils.compare(operator, left.coerceToString().invoke(MethodRef.STRING_COMPARE_TO, right.coerceToString()), BytecodeUtils.constant(0)));
        }

        @Override
        protected final SoyExpression visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyRuntimeType leftRuntimeType = left.soyRuntimeType();
            SoyExpression right = this.visit(node.getChild(1));
            SoyRuntimeType rightRuntimeType = right.soyRuntimeType();
            if (leftRuntimeType.assignableToNullableNumber() && rightRuntimeType.assignableToNullableNumber()) {
                if (leftRuntimeType.assignableToNullableInt() && rightRuntimeType.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(97, left, right);
                }
                if (leftRuntimeType.assignableToNullableFloat() || rightRuntimeType.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(99, left, right);
                }
            }
            if (leftRuntimeType.isKnownString() || rightRuntimeType.isKnownString()) {
                SoyExpression leftString = left.coerceToString();
                SoyExpression rightString = right.coerceToString();
                return SoyExpression.forString(leftString.invoke(MethodRef.STRING_CONCAT, rightString));
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_PLUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(101, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(103, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_MINUS.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            SoyExpression left = this.visit(node.getChild(0));
            SoyExpression right = this.visit(node.getChild(1));
            if (left.assignableToNullableNumber() && right.assignableToNullableNumber()) {
                if (left.assignableToNullableInt() && right.assignableToNullableInt()) {
                    return CompilerVisitor.applyBinaryIntOperator(105, left, right);
                }
                if (left.assignableToNullableFloat() || right.assignableToNullableFloat()) {
                    return CompilerVisitor.applyBinaryFloatOperator(107, left, right);
                }
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_TIMES.invoke(left.box(), right.box()));
        }

        @Override
        protected final SoyExpression visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            return CompilerVisitor.applyBinaryFloatOperator(111, this.visit(node.getChild(0)), this.visit(node.getChild(1)));
        }

        @Override
        protected final SoyExpression visitModOpNode(OperatorNodes.ModOpNode node) {
            return CompilerVisitor.applyBinaryIntOperator(113, this.visit(node.getChild(0)), this.visit(node.getChild(1)));
        }

        private static SoyExpression applyBinaryIntOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftInt = left.unboxAsLong();
            final SoyExpression rightInt = right.unboxAsLong();
            return SoyExpression.forInt(new Expression(Type.LONG_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftInt.gen(mv);
                    rightInt.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        private static SoyExpression applyBinaryFloatOperator(final int operator, SoyExpression left, SoyExpression right) {
            final SoyExpression leftFloat = left.coerceToDouble();
            final SoyExpression rightFloat = right.coerceToDouble();
            return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE){

                @Override
                protected void doGen(CodeBuilder mv) {
                    leftFloat.gen(mv);
                    rightFloat.gen(mv);
                    mv.visitInsn(operator);
                }
            });
        }

        @Override
        protected final SoyExpression visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            SoyExpression child = this.visit(node.getChild(0));
            if (child.assignableToNullableInt()) {
                final SoyExpression intExpr = child.unboxAsLong();
                return SoyExpression.forInt(new Expression(Type.LONG_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        intExpr.gen(mv);
                        mv.visitInsn(117);
                    }
                });
            }
            if (child.assignableToNullableFloat()) {
                final SoyExpression floatExpr = child.unboxAsDouble();
                return SoyExpression.forFloat(new Expression(Type.DOUBLE_TYPE, child.features()){

                    @Override
                    protected void doGen(CodeBuilder mv) {
                        floatExpr.gen(mv);
                        mv.visitInsn(119);
                    }
                });
            }
            return SoyExpression.forSoyValue(SoyTypes.NUMBER_TYPE, MethodRef.RUNTIME_NEGATIVE.invoke(child.box()));
        }

        @Override
        protected final SoyExpression visitNotOpNode(OperatorNodes.NotOpNode node) {
            return SoyExpression.forBool(BytecodeUtils.logicalNot(this.visit(node.getChild(0)).coerceToBoolean()));
        }

        @Override
        protected final SoyExpression visitAndOpNode(OperatorNodes.AndOpNode node) {
            SoyExpression left = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression right = this.visit(node.getChild(1)).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalAnd(left, right));
        }

        @Override
        protected final SoyExpression visitOrOpNode(OperatorNodes.OrOpNode node) {
            SoyExpression left = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression right = this.visit(node.getChild(1)).coerceToBoolean();
            return SoyExpression.forBool(BytecodeUtils.logicalOr(left, right));
        }

        @Override
        protected SoyExpression visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            SoyExpression left = this.visit(node.getLeftChild());
            if (left.isNonNullable()) {
                return left;
            }
            SoyExpression right = this.visit(node.getRightChild());
            if (SoyTypes.removeNull(left.soyType()).equals(right.soyType())) {
                SoyExpression result;
                if (left.isBoxed() == right.isBoxed()) {
                    result = right.withSource(BytecodeUtils.firstNonNull(left, right));
                } else {
                    SoyExpression boxedRight = right.box();
                    result = boxedRight.withSource(BytecodeUtils.firstNonNull(left.box(), boxedRight));
                }
                if (Expression.areAllCheap(left, right)) {
                    result = result.asCheap();
                }
                return result;
            }
            Type runtimeType = SoyRuntimeType.getBoxedType(node.getType()).runtimeType();
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.firstNonNull(left.box().checkedCast(runtimeType), right.box().checkedCast(runtimeType)));
        }

        @Override
        protected final SoyExpression visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            SoyExpression condition = this.visit(node.getChild(0)).coerceToBoolean();
            SoyExpression trueBranch = this.visit(node.getChild(1));
            SoyExpression falseBranch = this.visit(node.getChild(2));
            boolean typesEqual = trueBranch.soyType().equals(falseBranch.soyType());
            if (typesEqual) {
                if (trueBranch.isBoxed() == falseBranch.isBoxed()) {
                    return trueBranch.withSource(BytecodeUtils.ternary(condition, trueBranch, falseBranch));
                }
                SoyExpression boxedTrue = trueBranch.box();
                return boxedTrue.withSource(BytecodeUtils.ternary(condition, boxedTrue, falseBranch.box()));
            }
            Type boxedRuntimeType = SoyRuntimeType.getBoxedType(node.getType()).runtimeType();
            return SoyExpression.forSoyValue(node.getType(), BytecodeUtils.ternary(condition, trueBranch.box().checkedCast(boxedRuntimeType), falseBranch.box().checkedCast(boxedRuntimeType)));
        }

        @Override
        SoyExpression visitForLoopVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            if (expression.resultType().equals((Object)Type.LONG_TYPE)) {
                return SoyExpression.forInt(expression);
            }
            expression = this.detacher.resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitParam(VarRefNode varRef, TemplateParam param) {
            Expression paramExpr = this.detacher.resolveSoyValueProvider(this.parameters.getParam(param));
            return SoyExpression.forSoyValue(varRef.getType(), paramExpr.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        SoyExpression visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            Expression expression = this.parameters.getLocal(local);
            expression = this.detacher.resolveSoyValueProvider(expression);
            return SoyExpression.forSoyValue(varRef.getType(), expression.checkedCast(SoyRuntimeType.getBoxedType(varRef.getType()).runtimeType()));
        }

        @Override
        protected SoyExpression visitDataAccessNode(DataAccessNode node) {
            return new NullSafeAccessVisitor().visit(node);
        }

        @Override
        protected SoyExpression visitFieldAccessNode(FieldAccessNode node) {
            return new NullSafeAccessVisitor().visit(node);
        }

        @Override
        SoyExpression visitIsFirstFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = ((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            final Expression expr = this.parameters.getLocal(indexVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    expr.gen(adapter);
                    Label ifFirst = new Label();
                    adapter.ifZCmp(153, ifFirst);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifFirst);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIsLastFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = ((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            SyntheticVarName lengthVar = SyntheticVarName.foreachLoopLength((ForNonemptyNode)foreach);
            final Expression index = this.parameters.getLocal(indexVar);
            final Expression length = this.parameters.getLocal(lengthVar);
            return SoyExpression.forBool(new Expression(Type.BOOLEAN_TYPE){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    index.gen(adapter);
                    adapter.pushInt(1);
                    adapter.visitInsn(96);
                    length.gen(adapter);
                    Label ifLast = new Label();
                    adapter.ifICmp(153, ifLast);
                    adapter.pushBoolean(false);
                    Label end = new Label();
                    adapter.goTo(end);
                    adapter.mark(ifLast);
                    adapter.pushBoolean(true);
                    adapter.mark(end);
                }
            });
        }

        @Override
        SoyExpression visitIndexFunction(FunctionNode node) {
            VarRefNode varRef = (VarRefNode)node.getChild(0);
            SoyNode.LocalVarNode foreach = ((LocalVar)varRef.getDefnDecl()).declaringNode();
            SyntheticVarName indexVar = SyntheticVarName.foreachLoopIndex((ForNonemptyNode)foreach);
            return SoyExpression.forInt(BytecodeUtils.numericConversion(this.parameters.getLocal(indexVar), Type.LONG_TYPE));
        }

        @Override
        SoyExpression visitCheckNotNullFunction(FunctionNode node) {
            final ExprNode childNode = (ExprNode)Iterables.getOnlyElement(node.getChildren());
            final SoyExpression childExpr = this.visit(childNode);
            return childExpr.withSource(new Expression(childExpr.resultType(), childExpr.features()){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    childExpr.gen(adapter);
                    adapter.dup();
                    Label end = new Label();
                    adapter.ifNonNull(end);
                    adapter.throwException(BytecodeUtils.NULL_POINTER_EXCEPTION_TYPE, "'" + childNode.toSourceString() + "' evaluates to null");
                    adapter.mark(end);
                }
            }).asNonNullable();
        }

        @Override
        SoyExpression visitCssFunction(FunctionNode node) {
            StringNode selector = (StringNode)Iterables.getLast(node.getChildren());
            Expression renamedSelector = this.parameters.getRenderContext().renameCss(selector.getValue());
            if (node.numChildren() == 1) {
                return SoyExpression.forString(renamedSelector);
            }
            SoyExpression base = this.visit(node.getChild(0)).coerceToString();
            Expression fullSelector = base.invoke(MethodRef.STRING_CONCAT, BytecodeUtils.constant("-")).invoke(MethodRef.STRING_CONCAT, renamedSelector);
            return SoyExpression.forString(fullSelector);
        }

        @Override
        SoyExpression visitXidFunction(FunctionNode node) {
            StringNode xid = (StringNode)Iterables.getOnlyElement(node.getChildren());
            Expression renamedXid = this.parameters.getRenderContext().renameXid(xid.getValue());
            return SoyExpression.forString(renamedXid);
        }

        @Override
        SoyExpression visitIsPrimaryMsgInUse(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().usePrimaryMsg(((IntegerNode)node.getChild(1)).getValue(), ((IntegerNode)node.getChild(2)).getValue()));
        }

        @Override
        SoyExpression visitToFloatFunction(FunctionNode node) {
            SoyExpression arg = this.visit(node.getChild(0));
            return SoyExpression.forFloat(BytecodeUtils.numericConversion(arg.unboxAsLong(), Type.DOUBLE_TYPE));
        }

        @Override
        SoyExpression visitDebugSoyTemplateInfoFunction(FunctionNode node) {
            return SoyExpression.forBool(this.parameters.getRenderContext().getDebugSoyTemplateInfo());
        }

        @Override
        SoyExpression visitVeDataFunction(FunctionNode node) {
            SoyExpression ve = this.visit(node.getChild(0));
            Expression data = this.visit(node.getChild(1)).unboxAsMessage();
            return SoyExpression.forSoyValue(node.getType(), MethodRef.SOY_VISUAL_ELEMENT_DATA_CREATE.invoke(ve, data));
        }

        @Override
        SoyExpression visitPluginFunction(FunctionNode node) {
            Object fn = node.getSoyFunction();
            List<SoyExpression> args = this.visitChildren(node);
            if (fn instanceof SoyJavaSourceFunction) {
                return new JbcSrcValueFactory(node, this.parameters == null ? new JbcSrcPluginContext(){

                    private Expression error() {
                        throw new UnsupportedOperationException("Cannot access contextual data from a pure context");
                    }

                    @Override
                    public Expression getBidiGlobalDir() {
                        return this.error();
                    }

                    @Override
                    public Expression getAllRequiredCssNamespaces(Expression template) {
                        return this.error();
                    }

                    @Override
                    public Expression getRenderedCssNamespaces() {
                        return this.error();
                    }

                    @Override
                    public Expression getULocale() {
                        return this.error();
                    }
                } : this.parameters.getPluginContext(), new JbcSrcValueFactory.PluginInstanceLookup(){

                    @Override
                    public Expression getPluginInstance(String pluginName) {
                        if (parameters == null) {
                            throw new UnsupportedOperationException("Pure functions cannot have instances");
                        }
                        return parameters.getRenderContext().getPluginInstance(pluginName);
                    }
                }, this.reporter, this.registry).computeForJavaSource(args);
            }
            Expression legacyFunctionRuntimeExpr = this.parameters.getRenderContext().getPluginInstance(node.getFunctionName()).checkedCast(LegacyFunctionAdapter.class);
            Expression list = SoyExpression.asBoxedList(args);
            return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_CALL_LEGACY_FUNCTION.invoke(legacyFunctionRuntimeExpr, list).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
        }

        @Override
        protected final SoyExpression visitProtoInitNode(ProtoInitNode node) {
            return ProtoUtils.createProto(node, (Function<ExprNode, SoyExpression>)((Function)this::visit), this.detacher, this.varManager);
        }

        @Override
        protected SoyExpression visitVeLiteralNode(VeLiteralNode node) {
            return SoyExpression.forSoyValue(node.getType(), MethodRef.SOY_VISUAL_ELEMENT_CREATE.invoke(BytecodeUtils.constant(node.getId()), BytecodeUtils.constant(node.getName().identifier())));
        }

        @Override
        protected final SoyExpression visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException("Support for " + (Object)((Object)node.getKind()) + " has not been added yet");
        }

        private final class NullSafeAccessVisitor {
            Label nullSafeExit;

            private NullSafeAccessVisitor() {
            }

            Label getNullSafeExit() {
                Label local = this.nullSafeExit;
                return local == null ? (this.nullSafeExit = new Label()) : local;
            }

            SoyExpression visit(DataAccessNode node) {
                SoyExpression dataAccess = this.visitNullSafeNodeRecurse(node);
                if (this.nullSafeExit == null) {
                    return dataAccess;
                }
                if (BytecodeUtils.isPrimitive(dataAccess.resultType())) {
                    dataAccess = dataAccess.box();
                }
                return dataAccess.asNullable().labelEnd(this.nullSafeExit);
            }

            SoyExpression addNullSafetyCheck(final SoyExpression baseExpr) {
                final Label nullSafeExit = this.getNullSafeExit();
                return baseExpr.withSource(new Expression(baseExpr.resultType(), baseExpr.features()){

                    @Override
                    protected void doGen(CodeBuilder adapter) {
                        baseExpr.gen(adapter);
                        BytecodeUtils.nullCoalesce(adapter, nullSafeExit);
                    }
                }).asNonNullable();
            }

            SoyExpression visitNullSafeNodeRecurse(ExprNode node) {
                switch (node.getKind()) {
                    case FIELD_ACCESS_NODE: 
                    case ITEM_ACCESS_NODE: {
                        SoyExpression baseExpr = this.visitNullSafeNodeRecurse(((DataAccessNode)node).getBaseExprChild());
                        baseExpr = ((DataAccessNode)node).isNullSafe() ? this.addNullSafetyCheck(baseExpr) : baseExpr.asNonNullable();
                        if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                            return this.visitNullSafeFieldAccess(baseExpr, (FieldAccessNode)node).withSourceLocation(node.getSourceLocation());
                        }
                        return this.visitNullSafeItemAccess(baseExpr, (ItemAccessNode)node).withSourceLocation(node.getSourceLocation());
                    }
                }
                return CompilerVisitor.this.visit(node);
            }

            SoyExpression visitNullSafeFieldAccess(SoyExpression baseExpr, FieldAccessNode node) {
                if (baseExpr.soyRuntimeType().isKnownProtoOrUnionOfProtos()) {
                    if (baseExpr.soyType().getKind() == SoyType.Kind.PROTO) {
                        SoyProtoType protoType = (SoyProtoType)baseExpr.soyType();
                        return ProtoUtils.accessField(protoType, baseExpr, node);
                    }
                    return SoyExpression.forSoyValue(node.getType(), MethodRef.RUNTIME_GET_PROTO_FIELD.invoke(baseExpr.box().checkedCast(SoyProtoValue.class), BytecodeUtils.constant(node.getFieldName())).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
                }
                Expression fieldProvider = MethodRef.RUNTIME_GET_FIELD_PROVIDER.invoke(baseExpr.box().checkedCast(SoyRecord.class), BytecodeUtils.constant(node.getFieldName()));
                return SoyExpression.forSoyValue(node.getType(), CompilerVisitor.this.detacher.resolveSoyValueProvider(fieldProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType()));
            }

            SoyExpression visitNullSafeItemAccess(SoyExpression baseExpr, ItemAccessNode node) {
                SoyExpression keyExpr = CompilerVisitor.this.visit(node.getKeyExprChild());
                Expression soyValueProvider = baseExpr.soyRuntimeType().isKnownListOrUnionOfLists() ? MethodRef.RUNTIME_GET_LIST_ITEM.invoke(baseExpr.unboxAsList(), keyExpr.unboxAsLong()) : (baseExpr.soyRuntimeType().isKnownMapOrUnionOfMaps() ? MethodRef.RUNTIME_GET_MAP_ITEM.invoke(baseExpr.box().checkedCast(SoyMap.class), keyExpr.box()) : MethodRef.RUNTIME_GET_LEGACY_OBJECT_MAP_ITEM.invoke(baseExpr.box().checkedCast(SoyLegacyObjectMap.class), keyExpr.box()));
                Expression soyValue = CompilerVisitor.this.detacher.resolveSoyValueProvider(soyValueProvider).checkedCast(SoyRuntimeType.getBoxedType(node.getType()).runtimeType());
                return SoyExpression.forSoyValue(node.getType(), soyValue);
            }
        }
    }

    static final class BasicExpressionCompiler {
        private final CompilerVisitor compilerVisitor;

        private BasicExpressionCompiler(TemplateParameterLookup parameters, LocalVariableManager varManager, FieldManager fields, ErrorReporter reporter, SoyTypeRegistry registry) {
            this.compilerVisitor = new CompilerVisitor(parameters, varManager, fields, ExpressionDetacher.BasicDetacher.INSTANCE, reporter, registry);
        }

        private BasicExpressionCompiler(CompilerVisitor visitor) {
            this.compilerVisitor = visitor;
        }

        SoyExpression compile(ExprNode expr) {
            return (SoyExpression)this.compilerVisitor.exec(expr);
        }

        List<SoyExpression> compileToList(List<? extends ExprNode> children) {
            ArrayList<SoyExpression> soyExprs = new ArrayList<SoyExpression>(children.size());
            for (ExprNode exprNode : children) {
                soyExprs.add(this.compile(exprNode));
            }
            return soyExprs;
        }
    }
}

