/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSink;
import com.google.common.io.ByteSource;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.base.internal.SoyJarFileWriter;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.CompiledTemplateRegistry;
import com.google.template.soy.jbcsrc.CompilingClassLoader;
import com.google.template.soy.jbcsrc.TemplateCompiler;
import com.google.template.soy.jbcsrc.UnexpectedCompilerFailureException;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.MemoryClassLoader;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BytecodeCompiler {
    private static final Logger logger = Logger.getLogger(BytecodeCompiler.class.getName());
    private static final SoyErrorKind UNEXPECTED_COMPILER_FAILURE = SoyErrorKind.of("Unexpected error while compiling template: ''{0}''\nSoy Stack:\n{1}\nCompiler Stack:\n{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNEXPECTED_ERROR = SoyErrorKind.of("Unexpected error while compiling template: ''{0}''\n{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);

    public static Optional<CompiledTemplates> compile(final TemplateRegistry registry, SoyFileSetNode fileSet, boolean developmentMode, ErrorReporter reporter, ImmutableMap<String, SoyFileSupplier> filePathsToSuppliers, SoyTypeRegistry typeRegistry) {
        final Stopwatch stopwatch = Stopwatch.createStarted();
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return Optional.empty();
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        if (developmentMode) {
            CompiledTemplates templates = new CompiledTemplates(compilerRegistry.getDelegateTemplateNames(), new CompilingClassLoader(compilerRegistry, fileSet, filePathsToSuppliers, typeRegistry));
            if (reporter.errorsSince(checkpoint)) {
                return Optional.empty();
            }
            return Optional.of(templates);
        }
        List<ClassData> classes = BytecodeCompiler.compileTemplates(compilerRegistry, fileSet, reporter, typeRegistry, new CompilerListener<List<ClassData>>(){
            final List<ClassData> compiledClasses = new ArrayList<ClassData>();
            int numBytes = 0;
            int numFields = 0;
            int numDetachStates = 0;

            @Override
            public void onCompile(ClassData clazz) {
                this.numBytes += clazz.data().length;
                this.numFields += clazz.numberOfFields();
                this.numDetachStates += clazz.numberOfDetachStates();
                this.compiledClasses.add(clazz);
            }

            @Override
            public List<ClassData> getResult() {
                logger.log(Level.FINE, "\nCompilation took: {0}\n       templates: {1}\n         classes: {2}\n           bytes: {3}\n          fields: {4}\n    detachStates: {5}", new Object[]{stopwatch.toString(), registry.getAllTemplates().size(), this.compiledClasses.size(), this.numBytes, this.numFields, this.numDetachStates});
                return this.compiledClasses;
            }
        });
        if (reporter.errorsSince(checkpoint)) {
            return Optional.empty();
        }
        CompiledTemplates templates = new CompiledTemplates(compilerRegistry.getDelegateTemplateNames(), new MemoryClassLoader(classes));
        stopwatch.reset().start();
        templates.loadAll((Iterable<String>)compilerRegistry.getTemplateNames());
        logger.log(Level.FINE, "Loaded all classes in {0}", stopwatch);
        return Optional.of(templates);
    }

    public static void compileToJar(TemplateRegistry registry, SoyFileSetNode fileSet, ErrorReporter reporter, SoyTypeRegistry typeRegistry, ByteSink sink) throws IOException {
        ErrorReporter.Checkpoint checkpoint = reporter.checkpoint();
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        CompiledTemplateRegistry compilerRegistry = new CompiledTemplateRegistry(registry);
        if (reporter.errorsSince(checkpoint)) {
            return;
        }
        try (final SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            final TreeSet delTemplates = new TreeSet();
            BytecodeCompiler.compileTemplates(compilerRegistry, fileSet, reporter, typeRegistry, new CompilerListener<Void>(){

                @Override
                void onCompile(ClassData clazz) throws IOException {
                    writer.writeEntry(clazz.type().internalName() + ".class", ByteSource.wrap((byte[])clazz.data()));
                }

                @Override
                void onCompileDelTemplate(String name) {
                    delTemplates.add(name);
                }
            });
            if (!delTemplates.isEmpty()) {
                String delData = Joiner.on((char)'\n').join(delTemplates);
                writer.writeEntry("META-INF/services/com.google.template.soy.deltemplates", ByteSource.wrap((byte[])delData.getBytes(StandardCharsets.UTF_8)));
            }
        }
    }

    public static void writeSrcJar(SoyFileSetNode soyFileSet, ImmutableMap<String, SoyFileSupplier> files, ByteSink sink) throws IOException {
        try (SoyJarFileWriter writer = new SoyJarFileWriter(sink.openStream());){
            for (SoyFileNode file : soyFileSet.getChildren()) {
                String namespace = file.getNamespace();
                String fileName = file.getFileName();
                writer.writeEntry(Names.javaFileName(namespace, fileName), ((SoyFileSupplier)files.get((Object)file.getFilePath())).asCharSource().asByteSource(StandardCharsets.UTF_8));
            }
        }
    }

    private static <T> T compileTemplates(CompiledTemplateRegistry registry, SoyFileSetNode fileSet, ErrorReporter errorReporter, SoyTypeRegistry typeRegistry, CompilerListener<T> listener) {
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getChildren()) {
                CompiledTemplateMetadata classInfo = registry.getTemplateInfoByTemplateName(template.getTemplateName());
                try {
                    TemplateCompiler templateCompiler = new TemplateCompiler(registry, classInfo, template, errorReporter, typeRegistry);
                    for (ClassData clazz : templateCompiler.compile()) {
                        if (Flags.DEBUG) {
                            clazz.checkClass();
                        }
                        listener.onCompile(clazz);
                    }
                    if (template instanceof TemplateDelegateNode) {
                        listener.onCompileDelTemplate(template.getTemplateName());
                        continue;
                    }
                    listener.onCompileTemplate(template.getTemplateName());
                }
                catch (UnexpectedCompilerFailureException e) {
                    errorReporter.report(e.getOriginalLocation(), UNEXPECTED_COMPILER_FAILURE, template.getTemplateNameForUserMsgs(), e.printSoyStack(), Throwables.getStackTraceAsString((Throwable)e));
                }
                catch (Throwable t) {
                    errorReporter.report(template.getSourceLocation(), UNEXPECTED_ERROR, template.getTemplateNameForUserMsgs(), Throwables.getStackTraceAsString((Throwable)t));
                }
            }
        }
        return listener.getResult();
    }

    private BytecodeCompiler() {
    }

    private static abstract class CompilerListener<T> {
        private CompilerListener() {
        }

        abstract void onCompile(ClassData var1) throws Exception;

        void onCompileDelTemplate(String name) {
        }

        void onCompileTemplate(String name) {
        }

        T getResult() {
            return null;
        }
    }
}

