/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import java.util.List;

final class InvocationBuilderTypeUtils {
    private InvocationBuilderTypeUtils() {
    }

    static List<String> getJavaTypes(SoyType soyType) {
        switch (soyType.getKind()) {
            case BOOL: {
                return ImmutableList.of((Object)"boolean");
            }
            case INT: {
                return ImmutableList.of((Object)"long");
            }
            case FLOAT: {
                return ImmutableList.of((Object)"double");
            }
            case STRING: {
                return ImmutableList.of((Object)"String");
            }
            case HTML: {
                return ImmutableList.of((Object)"SafeHtml");
            }
            case JS: {
                return ImmutableList.of((Object)"SafeScript");
            }
            case URI: {
                return ImmutableList.of((Object)"SafeUrl");
            }
            case TRUSTED_RESOURCE_URI: {
                return ImmutableList.of((Object)"TrustedResourceUrl");
            }
            case PROTO: {
                SoyProtoType asProto = (SoyProtoType)soyType;
                return ImmutableList.of((Object)JavaQualifiedNames.getQualifiedName(asProto.getDescriptor()));
            }
            case PROTO_ENUM: {
                SoyProtoEnumType asProtoEnum = (SoyProtoEnumType)soyType;
                return ImmutableList.of((Object)JavaQualifiedNames.getQualifiedName(asProtoEnum.getDescriptor()));
            }
            case UNKNOWN: {
                return ImmutableList.of((Object)"Object");
            }
            case ATTRIBUTES: 
            case CSS: 
            case LIST: 
            case RECORD: 
            case LEGACY_OBJECT_MAP: 
            case MAP: 
            case UNION: 
            case ANY: 
            case ERROR: 
            case NULL: 
            case VE: 
            case VE_DATA: {
                return ImmutableList.of();
            }
        }
        throw new AssertionError((Object)"impossible");
    }
}

