/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.invocationbuilders.passes;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.invocationbuilders.passes.InvocationBuilderTypeUtils;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.internal.gencode.JavaGenerationUtils;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class GenInvocationBuildersVisitor
extends AbstractSoyNodeVisitor<ImmutableList<GeneratedFile>> {
    private static final Logger logger = Logger.getLogger(GenInvocationBuildersVisitor.class.getName());
    private IndentedLinesBuilder ilb;
    private final String javaPackage;
    private ImmutableList.Builder<GeneratedFile> generatedFiles;
    private Set<String> paramsClassNamesUsed;

    public GenInvocationBuildersVisitor(String javaPackage) {
        this.javaPackage = javaPackage;
    }

    @Override
    public ImmutableList<GeneratedFile> exec(SoyNode node) {
        this.generatedFiles = new ImmutableList.Builder();
        this.ilb = null;
        this.visit(node);
        ImmutableList builtFileList = this.generatedFiles.build();
        GenInvocationBuildersVisitor.logWarningIfFilenamesNotUnique((ImmutableList<GeneratedFile>)builtFileList);
        return builtFileList;
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode soyFile) {
        this.ilb = new IndentedLinesBuilder(2);
        this.appendFileHeaderAndImports(soyFile);
        String javaClassNameForSoyFile = GenInvocationBuildersVisitor.convertSoyFileNameToJavaClassName(soyFile);
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wrapper class containing {@link BaseParamsImpl} builders for each template in: " + soyFile.getFileName() + ".", false, true);
        this.ilb.appendLine("@Generated(\"com.google.template.soy.SoyParseInfoGenerator\")");
        this.ilb.appendLine("public final class " + javaClassNameForSoyFile + " {");
        this.ilb.increaseIndent();
        this.generateFooParamsClassesForEachTemplate(soyFile);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        String fileName = javaClassNameForSoyFile + ".java";
        this.generatedFiles.add((Object)GeneratedFile.create(fileName, this.ilb.toString()));
        this.ilb = null;
    }

    private void generateFooParamsClassesForEachTemplate(SoyFileNode soyFile) {
        this.paramsClassNamesUsed = new HashSet<String>();
        for (TemplateNode template : soyFile.getChildren()) {
            if (template.getVisibility() != Visibility.PUBLIC || template.getKind() == SoyNode.Kind.TEMPLATE_DELEGATE_NODE) continue;
            this.visit(template);
        }
    }

    @Override
    protected void visitTemplateNode(TemplateNode template) {
        Optional<String> templateParamsClassname = this.generateBaseParamsImplClassName(template);
        if (!templateParamsClassname.isPresent()) {
            return;
        }
        String paramsClass = templateParamsClassname.get();
        String templateDescription = template.getSoyDocDesc();
        this.ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(this.ilb, "Template params for " + template.getTemplateNameForUserMsgs() + (templateDescription != null ? ": " + templateDescription : "."), false, true);
        this.ilb.appendLine("public static final class " + templateParamsClassname.get() + " extends BaseParamsImpl {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static final String TEMPLATE_NAME = \"" + template.getTemplateName() + "\";");
        this.ilb.appendLine(new Object[0]);
        this.appendFutureWrapperMethod(paramsClass);
        this.ilb.appendLine("private " + paramsClass + "(Map<String, SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(TEMPLATE_NAME, data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.appendParamsBuilderClass(template, templateParamsClassname.get());
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendFutureWrapperMethod(String paramsClass) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Wraps a ListenableFuture<" + paramsClass + "> as a TemplateParameters.AsyncWrapper<" + paramsClass + ">", false, true);
        this.ilb.appendLine("public static TemplateParameters.AsyncWrapper<" + paramsClass + "> wrapFuture(ListenableFuture<" + paramsClass + "> paramsFuture) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new TemplateParameters.AsyncWrapper<>(TEMPLATE_NAME, paramsFuture);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
    }

    private void appendParamsBuilderClass(TemplateNode template, String templateParamsClassname) {
        JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new Builder instance.", false, true);
        this.ilb.appendLine("public static Builder builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new Builder();");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        if (template.getParams().stream().noneMatch(TemplateParam::isRequired)) {
            JavaGenerationUtils.appendJavadoc(this.ilb, "Creates a new instance of " + templateParamsClassname + " with no parameters set. This method was generated because all template parameters are optional.", false, true);
            this.ilb.appendLine("public static " + templateParamsClassname + " getDefaultInstance() {");
            this.ilb.increaseIndent();
            this.ilb.appendLine("return builder().build();");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
            this.ilb.appendLine(new Object[0]);
        }
        this.ilb.appendLine("public static class Builder extends AbstractBuilder<Builder, " + templateParamsClassname + "> {");
        this.ilb.appendLine(new Object[0]);
        this.ilb.increaseIndent();
        String paramsSetConstantName = "PARAMS";
        this.appendParamsImmutableSetConstant(paramsSetConstantName, template.getParams());
        this.ilb.appendLine("private Builder() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(TEMPLATE_NAME, " + paramsSetConstantName + ");");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("@Override");
        this.ilb.appendLine("protected " + templateParamsClassname + " buildInternal(String name, ImmutableMap<String, SoyValueProvider> data) {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return new " + templateParamsClassname + "(data);");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        HashSet paramUpperCamelCaseNamesUsed = new HashSet();
        template.getParams().forEach(param -> this.writeSettersForParam(param.name(), param.type(), Optional.ofNullable(param.desc()), paramUpperCamelCaseNamesUsed, template.getTemplateName()));
        this.ilb.appendLine(new Object[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
    }

    private void appendFileHeaderAndImports(SoyFileNode soyFile) {
        this.ilb.appendLine("// This file was automatically generated by the Soy compiler.");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine("// source: " + soyFile.getFilePath());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("package " + this.javaPackage + ";");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("import com.google.common.util.concurrent.ListenableFuture;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableMap;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSet;");
        this.ilb.appendLine("import com.google.common.html.types.SafeHtml;");
        this.ilb.appendLine("import com.google.common.html.types.SafeScript;");
        this.ilb.appendLine("import com.google.common.html.types.SafeStyle;");
        this.ilb.appendLine("import com.google.common.html.types.SafeStyleSheet;");
        this.ilb.appendLine("import com.google.common.html.types.SafeUrl;");
        this.ilb.appendLine("import com.google.common.html.types.TrustedResourceUrl;");
        this.ilb.appendLine("import com.google.template.soy.data.SanitizedContent;");
        this.ilb.appendLine("import com.google.template.soy.data.SoyValueProvider;");
        this.ilb.appendLine("import com.google.template.soy.data.SoyValueConverter;");
        this.ilb.appendLine("import com.google.template.soy.data.TemplateParameters;");
        this.ilb.appendLine("import com.google.template.soy.data.BaseParamsImpl;");
        this.ilb.appendLine("import java.util.Map;");
        this.ilb.appendLine("import java.util.Objects;");
        this.ilb.appendLine("import java.util.concurrent.Future;");
        this.ilb.appendLine("import javax.annotation.Generated;");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
    }

    private void appendParamsImmutableSetConstant(String constantName, ImmutableList<TemplateParam> params) {
        ImmutableList genCodeForCreatingParams = (ImmutableList)params.stream().map(p -> p.isRequired() ? "BaseParamsImpl.Param.required(\"" + p.name() + "\")" : "BaseParamsImpl.Param.optional(\"" + p.name() + "\")").collect(ImmutableList.toImmutableList());
        this.ilb.appendLineStart("private static final ImmutableSet<Param> " + constantName + " = ");
        JavaGenerationUtils.appendImmutableSetInline(this.ilb, "<BaseParamsImpl.Param>", (Collection<String>)genCodeForCreatingParams);
        this.ilb.appendLineEnd(";");
        this.ilb.appendLine(new Object[0]);
    }

    private void writeSettersForParam(String templateParamName, SoyType soyType, Optional<String> paramDescription, Set<String> paramUpperCamelCaseNamesUsed, String templateName) {
        String upperCamelCaseName = JavaGenerationUtils.makeUpperCamelCase(templateParamName);
        if (!paramUpperCamelCaseNamesUsed.add(upperCamelCaseName)) {
            GenInvocationBuildersVisitor.logDuplicateParamNameWarning(templateParamName, upperCamelCaseName, templateName);
            return;
        }
        InvocationBuilderTypeUtils.getJavaTypes(soyType).forEach(javaType -> GenInvocationBuildersVisitor.writeSetter(this.ilb, templateParamName, upperCamelCaseName, paramDescription, javaType));
    }

    private static void writeSetter(IndentedLinesBuilder ilb, String originalParamName, String paramNameInUpperCamelCase, Optional<String> paramDescription, String javaType) {
        ilb.appendLine(new Object[0]);
        JavaGenerationUtils.appendJavadoc(ilb, "Sets " + originalParamName + (paramDescription.isPresent() ? ": " + paramDescription : "."), false, true);
        ilb.appendLine("public Builder set" + paramNameInUpperCamelCase + "(" + javaType + " value) {");
        ilb.increaseIndent();
        boolean isPrimitiveType = Character.isLowerCase(javaType.charAt(0));
        if (!isPrimitiveType) {
            ilb.appendLine("Objects.requireNonNull(value);");
        }
        ilb.appendLine("return setParam(\"" + originalParamName + "\", value);");
        ilb.decreaseIndent();
        ilb.appendLine("}");
    }

    private static String convertSoyFileNameToJavaClassName(SoyFileNode soyFile) {
        String fileName = soyFile.getFileName();
        if (fileName == null) {
            throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
        }
        if (Ascii.toLowerCase((String)fileName).endsWith(".soy")) {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        return JavaGenerationUtils.makeUpperCamelCase(fileName) + "Templates";
    }

    private Optional<String> generateBaseParamsImplClassName(TemplateNode template) {
        String namespacedTemplateName = template.getTemplateName();
        String templateName = namespacedTemplateName.substring(namespacedTemplateName.lastIndexOf(46) + 1);
        String className = JavaGenerationUtils.makeUpperCamelCase(templateName) + "Params";
        if (!this.paramsClassNamesUsed.add(className)) {
            GenInvocationBuildersVisitor.logDuplicateTemplateNameWarning(template.getTemplateNameForUserMsgs(), className);
            return Optional.empty();
        }
        return Optional.of(className);
    }

    private static void logDuplicateTemplateNameWarning(String templateName, String generatedClassName) {
        logger.warning("When generating soy java invocation builders, soy template: " + templateName + " generated the same Java UpperCamelCase name as another template in this file.\n This template was skipped during invocation builder generation.\n To use this api, all soy template names in a given file should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped).\nThe generated Java class name was: " + generatedClassName + ".");
    }

    private static void logDuplicateParamNameWarning(String templateParamName, String nameAsUpperCamelCase, String templateName) {
        logger.warning("When generating soy java invocation builders, soy template: " + templateName + " had multiple parameters that converted to the same upper camel case name: " + nameAsUpperCamelCase + ".\nParam: " + templateParamName + " is being skipped (no setters will be generated for this param).\n To use this api, all parameter names for a given template should be unique when converted to UpperCamelCase (with non-alphanumeric characters stripped).\n");
    }

    private static void logWarningIfFilenamesNotUnique(ImmutableList<GeneratedFile> files) {
        ImmutableList duplicateFilenames = (ImmutableList)files.stream().collect(Collectors.groupingBy(GeneratedFile::fileName, Collectors.counting())).entrySet().stream().filter(e -> (Long)e.getValue() > 1L).map(e -> (String)e.getKey()).collect(ImmutableList.toImmutableList());
        for (String fileName : duplicateFilenames) {
            logger.warning("While generating Soy Java invocation builders, multiple files in this soy fileset mapped to the same file name: " + fileName + ".\n To use this api, soy file names should be unique when converted to UpperCamelCase (with non-alpha-numeric characters stripped).\n");
        }
    }
}

