/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.internal.proto.ProtoUtils;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public abstract class Field {
    private static final Logger logger = Logger.getLogger(Field.class.getName());
    private static final SoyErrorKind AMBIGUOUS_FIELDS_ERROR = SoyErrorKind.of("Cannot access {0}. It may refer to any one of the following extensions, and Soy does not have enough information to decide which.\n{1}\nTo resolve ensure that all extension fields accessed from soy have unique names.", new SoyErrorKind.StyleAllowance[0]);
    private final Descriptors.FieldDescriptor fieldDesc;
    private final boolean shouldCheckFieldPresenceToEmulateJspbNullability;
    private final String name;

    public static <T extends Field> ImmutableMap<String, T> getFieldsForType(Descriptors.Descriptor descriptor, Set<Descriptors.FieldDescriptor> extensions, Factory<T> factory) {
        T field;
        SetMultimap fieldsBySoyName = MultimapBuilder.hashKeys().linkedHashSetValues().build();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptor.getFields()) {
            if (ProtoUtils.shouldJsIgnoreField(fieldDescriptor)) continue;
            field = factory.create(fieldDescriptor);
            fieldsBySoyName.put((Object)((Field)field).getName(), field);
        }
        for (Descriptors.FieldDescriptor extension : extensions) {
            field = factory.create(extension);
            fieldsBySoyName.put((Object)((Field)field).getName(), field);
        }
        ImmutableMap.Builder fields = ImmutableMap.builder();
        for (Map.Entry group : Multimaps.asMap((SetMultimap)fieldsBySoyName).entrySet()) {
            Set ambiguousFields = (Set)group.getValue();
            String fieldName = (String)group.getKey();
            if (ambiguousFields.size() == 1) {
                fields.put((Object)fieldName, (Object)((Field)Iterables.getOnlyElement((Iterable)ambiguousFields)));
                continue;
            }
            T value = factory.createAmbiguousFieldSet(ambiguousFields);
            logger.severe("Proto " + descriptor.getFullName() + " has multiple extensions with the name \"" + fieldName + "\": " + Field.fullFieldNames(ambiguousFields) + "\nThis field will not be accessible from soy");
            fields.put((Object)fieldName, value);
        }
        return fields.build();
    }

    protected Field(Descriptors.FieldDescriptor fieldDesc) {
        this.fieldDesc = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)fieldDesc);
        this.name = Field.computeSoyName(fieldDesc);
        this.shouldCheckFieldPresenceToEmulateJspbNullability = ProtoUtils.shouldCheckFieldPresenceToEmulateJspbNullability(fieldDesc);
    }

    public final String getName() {
        return this.name;
    }

    public final boolean shouldCheckFieldPresenceToEmulateJspbNullability() {
        return this.shouldCheckFieldPresenceToEmulateJspbNullability;
    }

    public final Descriptors.FieldDescriptor getDescriptor() {
        return this.fieldDesc;
    }

    private static String computeSoyName(Descriptors.FieldDescriptor field) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName()) + Field.fieldSuffix(field);
    }

    private static String fieldSuffix(Descriptors.FieldDescriptor field) {
        if (field.isMapField()) {
            return "Map";
        }
        if (field.isRepeated()) {
            return "List";
        }
        return "";
    }

    protected static RuntimeException ambiguousFieldsError(String name, Set<? extends Field> fields) {
        return new IllegalStateException(AMBIGUOUS_FIELDS_ERROR.format(name, Field.fullFieldNames(fields)));
    }

    public static void reportAmbiguousFieldsError(ErrorReporter reporter, SourceLocation location, String name, Set<? extends Field> fields) {
        reporter.report(location, AMBIGUOUS_FIELDS_ERROR, name, Field.fullFieldNames(fields));
    }

    private static ImmutableSet<String> fullFieldNames(Set<? extends Field> fields) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Field field : fields) {
            builder.add((Object)field.getDescriptor().getFullName());
        }
        return builder.build();
    }

    public static interface Factory<T extends Field> {
        public T create(Descriptors.FieldDescriptor var1);

        public T createAmbiguousFieldSet(Set<T> var1);
    }
}

