/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.i18ndirectives;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.i18ndirectives.I18NDirectivesRuntime;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.ibm.icu.util.ULocale;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@SoyFunctionSignature(name="formatNum", value={@Signature(parameterTypes={"?"}, returnType="string"), @Signature(parameterTypes={"?", "string"}, returnType="string"), @Signature(parameterTypes={"?", "string", "string"}, returnType="string"), @Signature(parameterTypes={"?", "string", "string", "number"}, returnType="string"), @Signature(parameterTypes={"?", "string", "string", "number", "number"}, returnType="string")}, callableAsDeprecatedPrintDirective=true)
class FormatNumFunction
implements SoyJavaSourceFunction,
SoyJavaScriptSourceFunction,
SoyPythonSourceFunction {
    private static final String DEFAULT_FORMAT = "decimal";
    private static final ImmutableMap<String, String> JS_ARGS_TO_ENUM = ImmutableMap.builder().put((Object)"decimal", (Object)"goog.i18n.NumberFormat.Format.DECIMAL").put((Object)"currency", (Object)"goog.i18n.NumberFormat.Format.CURRENCY").put((Object)"percent", (Object)"goog.i18n.NumberFormat.Format.PERCENT").put((Object)"scientific", (Object)"goog.i18n.NumberFormat.Format.SCIENTIFIC").put((Object)"compact_short", (Object)"goog.i18n.NumberFormat.Format.COMPACT_SHORT").put((Object)"compact_long", (Object)"goog.i18n.NumberFormat.Format.COMPACT_LONG").build();

    FormatNumFunction() {
    }

    @Override
    public JavaValue applyForJavaSource(JavaValueFactory factory, List<JavaValue> args, JavaPluginContext context) {
        return factory.callStaticMethod(Methods.FORMAT_NUM, context.getULocale(), args.get(0), FormatNumFunction.getArgOrDefault(args, 1, factory.constant(DEFAULT_FORMAT)), FormatNumFunction.getArgOrDefault(args, 2, factory.constant("local")), FormatNumFunction.getArgOrDefault(args, 3, factory.constantNull()), FormatNumFunction.getArgOrDefault(args, 4, factory.constantNull()));
    }

    @Override
    public JavaScriptValue applyForJavaScriptSource(JavaScriptValueFactory factory, List<JavaScriptValue> args, JavaScriptPluginContext context) {
        ArrayList<JavaScriptValue> jsArgs = new ArrayList<JavaScriptValue>(args);
        if (jsArgs.size() == 1) {
            jsArgs.add(factory.global((String)JS_ARGS_TO_ENUM.get((Object)DEFAULT_FORMAT)));
        } else {
            Optional<String> formatArg = args.get(1).asStringLiteral();
            if (!formatArg.isPresent()) {
                throw new IllegalArgumentException("The second parameter to formatNum must be a string literal");
            }
            String formatEnum = (String)JS_ARGS_TO_ENUM.get((Object)formatArg.get());
            if (formatEnum == null) {
                throw new IllegalArgumentException("The second parameter to formatNum must be one of {" + Joiner.on((String)", ").join((Iterable)JS_ARGS_TO_ENUM.keySet()) + "} but was " + formatArg.get());
            }
            jsArgs.set(1, factory.global(formatEnum));
        }
        if (jsArgs.size() > 2) {
            jsArgs.remove(2);
        }
        return factory.callModuleFunction("soy.i18n", "$$formatNum", jsArgs);
    }

    @Override
    public PythonValue applyForPythonSource(PythonValueFactory factory, List<PythonValue> args, PythonPluginContext context) {
        ArrayList<PythonValue> pyArgs = new ArrayList<PythonValue>(args);
        if (pyArgs.size() > 2) {
            pyArgs.remove(2);
        }
        return factory.global("translator_impl.format_num").call(pyArgs);
    }

    private static JavaValue getArgOrDefault(List<JavaValue> args, int index, JavaValue defaultVal) {
        return args.size() > index ? args.get(index) : defaultVal;
    }

    private static final class Methods {
        static final Method FORMAT_NUM = JavaValueFactory.createMethod(I18NDirectivesRuntime.class, "formatNum", ULocale.class, SoyValue.class, String.class, String.class, NumberData.class, NumberData.class);

        private Methods() {
        }
    }
}

