/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.html.types.SafeHtml;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScript;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyle;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheet;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrl;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrl;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContents;
import com.google.template.soy.data.SoyAbstractCachingValueProvider;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyEasyList;
import com.google.template.soy.data.SoyFutureValueProvider;
import com.google.template.soy.data.SoyGlobalsValue;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.EasyListImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.RenderResult;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public final class SoyValueConverter {
    @Deprecated
    public static final SoyValueConverter UNCUSTOMIZED_INSTANCE;
    public static final SoyValueConverter INSTANCE;
    public static final SoyDict EMPTY_DICT;
    public static final SoyList EMPTY_LIST;
    public static final SoyMapImpl EMPTY_MAP;
    private final TypeMap cheapConverterMap = new TypeMap();
    private final TypeMap expensiveConverterMap = new TypeMap();

    @Inject
    SoyValueConverter() {
        this.cheapConverterMap.put(SoyValueProvider.class, input -> input);
        this.cheapConverterMap.put(String.class, StringData::forValue);
        this.cheapConverterMap.put(Boolean.class, BooleanData::forValue);
        this.cheapConverterMap.put(Integer.class, input -> IntegerData.forValue(input.longValue()));
        this.cheapConverterMap.put(Long.class, IntegerData::forValue);
        this.cheapConverterMap.put(Float.class, input -> FloatData.forValue(input.doubleValue()));
        this.cheapConverterMap.put(Double.class, FloatData::forValue);
        this.cheapConverterMap.put(Future.class, SoyFutureValueProvider::new);
        this.cheapConverterMap.put(Descriptors.EnumValueDescriptor.class, input -> IntegerData.forValue(input.getNumber()));
        this.cheapConverterMap.put(ProtocolMessageEnum.class, input -> IntegerData.forValue(input.getNumber()));
        this.cheapConverterMap.put(SafeHtml.class, SanitizedContents::fromSafeHtml);
        this.cheapConverterMap.put(SafeHtmlProto.class, SanitizedContents::fromSafeHtmlProto);
        this.cheapConverterMap.put(SafeScript.class, SanitizedContents::fromSafeScript);
        this.cheapConverterMap.put(SafeScriptProto.class, SanitizedContents::fromSafeScriptProto);
        this.cheapConverterMap.put(SafeStyle.class, SanitizedContents::fromSafeStyle);
        this.cheapConverterMap.put(SafeStyleProto.class, SanitizedContents::fromSafeStyleProto);
        this.cheapConverterMap.put(SafeStyleSheet.class, SanitizedContents::fromSafeStyleSheet);
        this.cheapConverterMap.put(SafeStyleSheetProto.class, SanitizedContents::fromSafeStyleSheetProto);
        this.cheapConverterMap.put(SafeUrl.class, SanitizedContents::fromSafeUrl);
        this.cheapConverterMap.put(SafeUrlProto.class, SanitizedContents::fromSafeUrlProto);
        this.cheapConverterMap.put(TrustedResourceUrl.class, SanitizedContents::fromTrustedResourceUrl);
        this.cheapConverterMap.put(TrustedResourceUrlProto.class, SanitizedContents::fromTrustedResourceUrlProto);
        this.cheapConverterMap.put(Message.Builder.class, input -> SoyProtoValue.create(input.build()));
        this.cheapConverterMap.put(Message.class, SoyProtoValue::create);
        this.expensiveConverterMap.put(ByteString.class, input -> StringData.forValue(BaseEncoding.base64().encode(input.toByteArray())));
        this.expensiveConverterMap.put(SoyGlobalsValue.class, input -> this.convert(input.getSoyGlobalValue()));
        this.expensiveConverterMap.putStringMap(this::newDictFromMap);
        this.expensiveConverterMap.put(MarkAsSoyMap.class, input -> this.newSoyMapFromJavaMap(input.delegate()));
        this.expensiveConverterMap.put(Collection.class, this::newListFromIterable);
        this.expensiveConverterMap.put(FluentIterable.class, this::newListFromIterable);
    }

    public SoyDict newDictFromMap(Map<String, ?> javaStringMap) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ?> entry : javaStringMap.entrySet()) {
            builder.put((Object)entry.getKey(), (Object)this.convertLazy(entry.getValue()));
        }
        return DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)builder.build(), RuntimeMapTypeTracker.Type.UNKNOWN);
    }

    private SoyMap newSoyMapFromJavaMap(Map<?, ?> javaMap) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)javaMap.size());
        for (Map.Entry<?, ?> entry : javaMap.entrySet()) {
            map.put(this.convert(entry.getKey()).resolve(), this.convertLazy(entry.getValue()));
        }
        return SoyMapImpl.forProviderMap(map);
    }

    public static Object markAsSoyMap(Map<?, ?> delegate) {
        return new MarkAsSoyMap(delegate);
    }

    @Deprecated
    public SoyEasyList newEasyListFromList(SoyList list) {
        EasyListImpl result = new EasyListImpl();
        for (SoyValueProvider soyValueProvider : list.asJavaList()) {
            result.add(soyValueProvider);
        }
        return result;
    }

    private SoyList newListFromIterable(Iterable<?> items) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Object item : items) {
            builder.add((Object)this.convertLazy(item));
        }
        return ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)builder.build());
    }

    @Nonnull
    public SoyValueProvider convert(@Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return this.convertNonPrimitive(obj);
    }

    public SoyValueProvider convertLazy(Supplier<?> supplier) {
        return new LazyProvider(() -> this.convert(supplier.get()));
    }

    private SoyValueProvider convertLazy(final @Nullable Object obj) {
        SoyValueProvider convertedPrimitive = this.convertCheap(obj);
        if (convertedPrimitive != null) {
            return convertedPrimitive;
        }
        return new SoyAbstractCachingValueProvider(){

            @Override
            protected SoyValue compute() {
                return SoyValueConverter.this.convertNonPrimitive(obj).resolve();
            }

            @Override
            public RenderResult status() {
                return RenderResult.done();
            }
        };
    }

    private SoyValueProvider convertNonPrimitive(@Nullable Object obj) {
        SoyValueProvider converted = this.expensiveConverterMap.convert(obj);
        if (converted != null) {
            return converted;
        }
        throw new SoyDataException("Attempting to convert unrecognized object to Soy value (object type " + obj.getClass().getName() + ").");
    }

    @Nullable
    private SoyValueProvider convertCheap(@Nullable Object obj) {
        if (obj == null) {
            return NullData.INSTANCE;
        }
        return this.cheapConverterMap.convert(obj);
    }

    static {
        INSTANCE = UNCUSTOMIZED_INSTANCE = new SoyValueConverter();
        EMPTY_DICT = DictImpl.forProviderMap((Map<String, ? extends SoyValueProvider>)ImmutableMap.of(), RuntimeMapTypeTracker.Type.UNKNOWN);
        EMPTY_LIST = ListImpl.forProviderList((ImmutableList<? extends SoyValueProvider>)ImmutableList.of());
        EMPTY_MAP = SoyMapImpl.forProviderMap((Map<? extends SoyValue, ? extends SoyValueProvider>)ImmutableMap.of());
    }

    private static final class MarkAsSoyMap {
        final Map<?, ?> delegate;

        MarkAsSoyMap(Map<?, ?> delegate) {
            this.delegate = delegate;
        }

        Map<?, ?> delegate() {
            return this.delegate;
        }
    }

    private static final class TypeMap {
        private static final Object NULL_MARKER = new Object();
        private final Map<Class<?>, Object> map = new ConcurrentHashMap();

        private TypeMap() {
        }

        <T> SoyValueProvider convert(T o) {
            Converter<?> converter = this.getConverter(o.getClass());
            if (converter != null) {
                return (SoyValueProvider)converter.apply(o);
            }
            return null;
        }

        <T> Converter<T> getConverter(Class<T> clz) {
            Object o = this.resolveConverter((Class)Preconditions.checkNotNull(clz));
            if (o == NULL_MARKER) {
                return null;
            }
            return (Converter)o;
        }

        <T> void put(Class<T> clazz, Converter<? extends T> converter) {
            Preconditions.checkState((this.map.put(clazz, Preconditions.checkNotNull(converter)) == null ? 1 : 0) != 0);
        }

        void putStringMap(Converter<Map<String, ?>> converter) {
            this.put(Map.class, converter);
        }

        private Object resolveConverter(@Nullable Class<?> clazz) {
            if (clazz == null) {
                return NULL_MARKER;
            }
            Object c = this.map.get(clazz);
            if (c != null) {
                return c;
            }
            c = this.resolveConverter(clazz.getSuperclass());
            if (c == NULL_MARKER) {
                Class<?> iface;
                Class<?>[] classArray = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && (c = this.resolveConverter(iface = classArray[i])) == NULL_MARKER; ++i) {
                }
            }
            this.map.put(clazz, c);
            return c;
        }
    }

    private static interface Converter<T>
    extends Function<T, SoyValueProvider> {
    }

    private static final class LazyProvider
    implements SoyValueProvider {
        Supplier<SoyValueProvider> delegateProvider;
        SoyValueProvider delegate;

        LazyProvider(Supplier<SoyValueProvider> delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        @Override
        public SoyValue resolve() {
            return this.delegate().resolve();
        }

        @Override
        public RenderResult status() {
            return this.delegate().status();
        }

        @Override
        public RenderResult renderAndResolve(LoggingAdvisingAppendable appendable, boolean isLast) throws IOException {
            return this.delegate().renderAndResolve(appendable, isLast);
        }

        SoyValueProvider delegate() {
            if (this.delegate == null) {
                this.delegate = this.delegateProvider.get();
                this.delegateProvider = null;
            }
            return this.delegate;
        }
    }
}

