/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.auto.value.AutoValue;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Streams;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.data.AutoValue_BaseParamsImpl_Param;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.TemplateParameters;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public abstract class BaseParamsImpl
implements TemplateParameters {
    private final String name;
    private final ImmutableMap<String, SoyValueProvider> data;

    protected BaseParamsImpl(String name, Map<String, SoyValueProvider> data) {
        this.name = name;
        this.data = ImmutableMap.copyOf(data);
    }

    @Override
    public String getTemplateName() {
        return this.name;
    }

    @Override
    public Map<String, SoyValueProvider> getParamsAsMap() {
        return this.data;
    }

    @AutoValue
    public static abstract class Param {
        public static Param optional(String name) {
            return new AutoValue_BaseParamsImpl_Param(name, false);
        }

        public static Param required(String name) {
            return new AutoValue_BaseParamsImpl_Param(name, true);
        }

        abstract String getName();

        abstract boolean isRequired();
    }

    public static abstract class AbstractBuilder<B extends AbstractBuilder<?, T>, T extends BaseParamsImpl> {
        private final String templateName;
        private final ImmutableMap<String, Param> params;
        private final SoyValueConverter soyValueConverter;
        private final Map<String, SoyValueProvider> data;

        protected AbstractBuilder(String templateName, Iterable<Param> params) {
            this.templateName = templateName;
            this.params = (ImmutableMap)Streams.stream(params).collect(ImmutableMap.toImmutableMap(Param::getName, (Function)Functions.identity()));
            this.soyValueConverter = SoyValueConverter.INSTANCE;
            this.data = new HashMap<String, SoyValueProvider>();
        }

        public T build() {
            ImmutableMap<String, SoyValueProvider> finalData = this.buildDataMapWithChecks(true, false);
            return this.buildInternal(this.templateName, finalData);
        }

        @ForOverride
        protected abstract T buildInternal(String var1, ImmutableMap<String, SoyValueProvider> var2);

        protected B setParam(String name, Object value) {
            Preconditions.checkNotNull((Object)name);
            SoyValueProvider soyValue = this.soyValueConverter.convert(value);
            this.data.put(name, soyValue);
            return (B)this;
        }

        private ImmutableMap<String, SoyValueProvider> buildDataMapWithChecks(boolean checkRequired, boolean checkNoExtras) {
            Set<String> extraParams;
            Set<String> missingParams;
            ImmutableMap finalData = ImmutableMap.copyOf(this.data);
            if (checkRequired && !(missingParams = this.getMissingParamNames((Map<String, ?>)finalData)).isEmpty()) {
                throw new IllegalStateException("Missing required params: " + Joiner.on((String)", ").join(missingParams));
            }
            if (checkNoExtras && !(extraParams = this.getExtraParamNames((Map<String, ?>)finalData)).isEmpty()) {
                throw new IllegalStateException("Illegal params: " + Joiner.on((String)", ").join(extraParams));
            }
            return finalData;
        }

        private Set<String> getMissingParamNames(Map<String, ?> data) {
            HashSet<String> missing = new HashSet<String>();
            for (Param param : this.params.values()) {
                if (!param.isRequired() || data.containsKey(param.getName())) continue;
                missing.add(param.getName());
            }
            return missing;
        }

        private Set<String> getExtraParamNames(Map<String, ?> data) {
            HashSet<String> extra = new HashSet<String>();
            for (String name : data.keySet()) {
                if (this.params.containsKey((Object)name)) continue;
                extra.add(name);
            }
            return extra;
        }
    }
}

