/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.template.soy.data.Dir;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.internal.i18n.BidiFormatter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.BidiUtils;

public final class BidiFunctionsRuntime {
    public static SanitizedContent bidiDirAttrSanitized(BidiGlobalDir dir, SoyValue value, boolean isHtml) {
        SanitizedContent sanitizedContent;
        Dir valueDir = null;
        boolean isHtmlForValueDirEstimation = false;
        if (value instanceof SanitizedContent && (valueDir = (sanitizedContent = (SanitizedContent)value).getContentDirection()) == null) {
            boolean bl = isHtmlForValueDirEstimation = sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML;
        }
        if (valueDir == null) {
            isHtmlForValueDirEstimation = isHtmlForValueDirEstimation || isHtml;
            valueDir = BidiUtils.estimateDirection(value.coerceToString(), isHtmlForValueDirEstimation);
        }
        BidiFormatter bidiFormatter = BidiFormatter.getInstance(dir.toDir());
        return bidiFormatter.knownDirAttrSanitized(valueDir);
    }

    public static String bidiEndEdge(BidiGlobalDir bidiGlobalDir) {
        return bidiGlobalDir.getStaticValue() < 0 ? "left" : "right";
    }

    public static String bidiStartEdge(BidiGlobalDir bidiGlobalDir) {
        return bidiGlobalDir.getStaticValue() < 0 ? "right" : "left";
    }

    public static String bidiMarkAfter(BidiGlobalDir bidiGlobalDir, SoyValue value, boolean isHtml) {
        Dir valueDir = null;
        if (value instanceof SanitizedContent) {
            SanitizedContent sanitizedContent = (SanitizedContent)value;
            valueDir = sanitizedContent.getContentDirection();
            isHtml = isHtml || sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML;
        }
        String markAfterKnownDir = BidiFormatter.getInstance(bidiGlobalDir.toDir()).markAfter(valueDir, value.coerceToString(), isHtml);
        return markAfterKnownDir;
    }

    public static String bidiMark(BidiGlobalDir bidiGlobalDir) {
        return bidiGlobalDir.getStaticValue() < 0 ? "\u200f" : "\u200e";
    }

    public static int bidiTextDir(SoyValue value, boolean isHtml) {
        SanitizedContent sanitizedContent;
        Dir valueDir = null;
        boolean isHtmlForValueDirEstimation = false;
        if (value instanceof SanitizedContent && (valueDir = (sanitizedContent = (SanitizedContent)value).getContentDirection()) == null) {
            boolean bl = isHtmlForValueDirEstimation = sanitizedContent.getContentKind() == SanitizedContent.ContentKind.HTML;
        }
        if (valueDir == null) {
            isHtmlForValueDirEstimation = isHtmlForValueDirEstimation || isHtml;
            valueDir = BidiUtils.estimateDirection(value.coerceToString(), isHtmlForValueDirEstimation);
        }
        return valueDir.ord;
    }

    public static int bidiGlobalDir(BidiGlobalDir dir) {
        return dir.getStaticValue();
    }
}

