/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.Iterables;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.TemplateMetadataSerializer;
import com.google.template.soy.css.CssMetadata;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.Option;

final class SoyHeaderCompiler
extends AbstractSoyCompiler {
    @Option(name="--output", required=true, usage="[Required] The file name of the output file to be written.  Each compiler invocation will produce exactly one file containing all the TemplateMetadata")
    private File output;
    @Option(name="--cssMetadataOutput", usage="Where to write metadata about CSS.  This will be a file containing a gzipped CssMetadata proto")
    private File cssMetadataOutput = null;

    SoyHeaderCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyHeaderCompiler() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        SoyFileSetParser.ParseResult result = sfsBuilder.build().compileMinimallyForHeaders();
        CompilationUnit unit = TemplateMetadataSerializer.compilationUnitFromFileSet(result.fileSet(), result.registry());
        try (GZIPOutputStream os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.output), 65536);){
            unit.writeTo(os);
        }
        if (this.cssMetadataOutput != null) {
            os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.cssMetadataOutput), 65536);
            var5_5 = null;
            try {
                SoyHeaderCompiler.calculateCssMetadata(result.fileSet()).writeTo(os);
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                SoyHeaderCompiler.$closeResource(var5_5, os);
            }
        }
    }

    private static CssMetadata calculateCssMetadata(SoyFileSetNode fileSet) {
        LinkedHashSet<String> requiredCssNames = new LinkedHashSet<String>();
        LinkedHashSet<String> cssClassNames = new LinkedHashSet<String>();
        for (SoyFileNode file : fileSet.getChildren()) {
            requiredCssNames.addAll((Collection<String>)file.getRequiredCssNamespaces());
            for (TemplateNode template : file.getChildren()) {
                requiredCssNames.addAll((Collection<String>)template.getRequiredCssNamespaces());
                for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(fileSet, BuiltinFunction.CSS)) {
                    cssClassNames.add(((StringNode)Iterables.getLast(fn.getChildren())).getValue());
                }
            }
        }
        return CssMetadata.newBuilder().addAllRequireCssNames(requiredCssNames).addAllCssClassNames(cssClassNames).build();
    }

    public static void main(String[] args) throws IOException {
        new SoyHeaderCompiler().runMain(args);
    }
}

