/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.AutoValue_SoyFileSetParser;
import com.google.template.soy.AutoValue_SoyFileSetParser_CompilationUnitAndKind;
import com.google.template.soy.AutoValue_SoyFileSetParser_ParseResult;
import com.google.template.soy.TemplateMetadataSerializer;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.soyparse.SoyFileParser;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;

@AutoValue
public abstract class SoyFileSetParser {
    public static Builder newBuilder() {
        return new AutoValue_SoyFileSetParser.Builder();
    }

    @Nullable
    abstract SoyAstCache cache();

    public abstract ImmutableMap<String, SoyFileSupplier> soyFileSuppliers();

    abstract ImmutableList<CompilationUnitAndKind> compilationUnits();

    abstract PassManager passManager();

    abstract ErrorReporter errorReporter();

    public abstract SoyTypeRegistry typeRegistry();

    public ParseResult parse() {
        try {
            return this.parseWithVersions();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParseResult parseWithVersions() throws IOException {
        ArrayList<TemplateMetadata> templateMetadatas = new ArrayList<TemplateMetadata>();
        for (CompilationUnitAndKind unit : this.compilationUnits()) {
            templateMetadatas.addAll((Collection<TemplateMetadata>)TemplateMetadataSerializer.templatesFromCompilationUnit(unit.compilationUnit(), unit.fileKind(), this.typeRegistry(), unit.filePath(), this.errorReporter()));
        }
        IdGenerator nodeIdGen = this.cache() != null ? this.cache().getNodeIdGenerator() : new IncrementingIdGenerator();
        SoyFileSetNode soyTree = new SoyFileSetNode(nodeIdGen.genId(), nodeIdGen);
        boolean filesWereSkipped = false;
        IdGenerator idGenerator = nodeIdGen;
        synchronized (idGenerator) {
            for (Iterator fileSupplier : this.soyFileSuppliers().values()) {
                SoyFileNode node;
                SoyAstCache.VersionedFile cachedFile;
                SoyFileSupplier.Version version = fileSupplier.getVersion();
                SoyAstCache.VersionedFile versionedFile = cachedFile = this.cache() != null ? this.cache().get(fileSupplier.getFilePath(), version) : null;
                if (cachedFile == null) {
                    node = this.parseSoyFileHelper((SoyFileSupplier)((Object)fileSupplier), nodeIdGen);
                    if (node == null) {
                        filesWereSkipped = true;
                        continue;
                    }
                    this.passManager().runSingleFilePasses(node, nodeIdGen);
                    if (this.cache() != null) {
                        this.cache().put(fileSupplier.getFilePath(), SoyAstCache.VersionedFile.of(node, version));
                    }
                } else {
                    node = cachedFile.file();
                }
                soyTree.addChild(node);
            }
            TemplateRegistry.Builder builder = TemplateRegistry.builder(this.errorReporter());
            for (TemplateMetadata template : templateMetadatas) {
                builder.addTemplate(template);
            }
            if (!filesWereSkipped) {
                this.passManager().runTemplateReturnTypeInferencePasses(soyTree, builder.build());
            }
            for (SoyFileNode node : soyTree.getChildren()) {
                for (TemplateNode template : node.getChildren()) {
                    builder.addTemplate(TemplateMetadata.fromTemplate(template));
                }
            }
            TemplateRegistry registry = builder.build();
            if (!filesWereSkipped) {
                this.passManager().runWholeFilesetPasses(soyTree, registry);
            }
            return ParseResult.create(soyTree, registry);
        }
    }

    private SoyFileNode parseSoyFileHelper(SoyFileSupplier soyFileSupplier, IdGenerator nodeIdGen) throws IOException {
        if (soyFileSupplier instanceof HasAstOrErrors) {
            return ((HasAstOrErrors)((Object)soyFileSupplier)).getAst(nodeIdGen, this.errorReporter());
        }
        try (Reader soyFileReader = soyFileSupplier.open();){
            String filePath = soyFileSupplier.getFilePath();
            int lastBangIndex = filePath.lastIndexOf(33);
            if (lastBangIndex != -1) {
                filePath = filePath.substring(lastBangIndex + 1);
            }
            SoyFileNode soyFileNode = new SoyFileParser(nodeIdGen, soyFileReader, filePath, this.errorReporter()).parseSoyFile();
            return soyFileNode;
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setCache(SoyAstCache var1);

        public abstract Builder setSoyFileSuppliers(ImmutableMap<String, SoyFileSupplier> var1);

        public abstract Builder setCompilationUnits(ImmutableList<CompilationUnitAndKind> var1);

        public abstract Builder setPassManager(PassManager var1);

        public abstract Builder setErrorReporter(ErrorReporter var1);

        public abstract Builder setTypeRegistry(SoyTypeRegistry var1);

        public abstract SoyFileSetParser build();
    }

    @AutoValue
    public static abstract class ParseResult {
        static ParseResult create(SoyFileSetNode soyTree, TemplateRegistry registry) {
            return new AutoValue_SoyFileSetParser_ParseResult(soyTree, registry);
        }

        public abstract SoyFileSetNode fileSet();

        public abstract TemplateRegistry registry();
    }

    @AutoValue
    public static abstract class CompilationUnitAndKind {
        public static CompilationUnitAndKind create(SoyFileKind fileKind, String filePath, CompilationUnit compilationUnit) {
            Preconditions.checkArgument((fileKind != SoyFileKind.SRC ? 1 : 0) != 0, (Object)"compilation units should only represent dependencies");
            return new AutoValue_SoyFileSetParser_CompilationUnitAndKind(fileKind, filePath, compilationUnit);
        }

        abstract SoyFileKind fileKind();

        abstract String filePath();

        abstract CompilationUnit compilationUnit();
    }

    static interface HasAstOrErrors {
        @Nullable
        public SoyFileNode getAst(IdGenerator var1, ErrorReporter var2);
    }
}

