/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyType;
import java.util.Objects;
import java.util.Optional;

public final class VeType
extends SoyType {
    public static final VeType NO_DATA = new VeType(Optional.empty());
    private final Optional<String> dataType;

    private VeType(Optional<String> dataType) {
        this.dataType = dataType;
    }

    public static VeType of(String dataType) {
        Preconditions.checkNotNull((Object)dataType);
        if (NullType.getInstance().toString().equals(dataType)) {
            return NO_DATA;
        }
        return new VeType(Optional.of(dataType));
    }

    public Optional<String> getDataType() {
        return this.dataType;
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.VE;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType) {
        return srcType.getKind() == SoyType.Kind.VE && this.dataType.equals(((VeType)srcType).dataType);
    }

    @Override
    public String toString() {
        return "ve<" + (this.dataType.isPresent() ? this.dataType.get() : NullType.getInstance().toString()) + ">";
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.setVe(this.dataType.orElse("null"));
    }

    public boolean equals(Object other) {
        return other != null && other.getClass() == this.getClass() && ((VeType)other).dataType.equals(this.dataType);
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.dataType);
    }
}

