/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.types;

import com.google.common.base.Preconditions;
import com.google.template.soy.soytree.SoyTypeP;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.AnyType;
import com.google.template.soy.types.SoyType;
import java.util.Objects;

public final class LegacyObjectMapType
extends AbstractMapType {
    public static final LegacyObjectMapType EMPTY_MAP = new LegacyObjectMapType(null, null);
    public static final LegacyObjectMapType ANY_MAP = new LegacyObjectMapType(AnyType.getInstance(), AnyType.getInstance());
    private final SoyType keyType;
    private final SoyType valueType;

    private LegacyObjectMapType(SoyType keyType, SoyType valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public static LegacyObjectMapType of(SoyType keyType, SoyType valueType) {
        Preconditions.checkNotNull((Object)keyType);
        Preconditions.checkNotNull((Object)valueType);
        return new LegacyObjectMapType(keyType, valueType);
    }

    @Override
    public SoyType.Kind getKind() {
        return SoyType.Kind.LEGACY_OBJECT_MAP;
    }

    @Override
    public SoyType getKeyType() {
        return this.keyType;
    }

    @Override
    public SoyType getValueType() {
        return this.valueType;
    }

    @Override
    boolean doIsAssignableFromNonUnionType(SoyType srcType) {
        if (srcType.getKind() == SoyType.Kind.LEGACY_OBJECT_MAP) {
            LegacyObjectMapType srcMapType = (LegacyObjectMapType)srcType;
            if (srcMapType == EMPTY_MAP) {
                return true;
            }
            if (this == EMPTY_MAP) {
                return false;
            }
            return this.keyType.isAssignableFrom(srcMapType.keyType) && this.valueType.isAssignableFrom(srcMapType.valueType);
        }
        return false;
    }

    @Override
    public String toString() {
        return "legacy_object_map<" + this.keyType + "," + this.valueType + ">";
    }

    @Override
    void doToProto(SoyTypeP.Builder builder) {
        builder.getLegacyObjectMapBuilder().setKey(this.keyType.toProto()).setValue(this.valueType.toProto());
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass() == this.getClass()) {
            LegacyObjectMapType otherMap = (LegacyObjectMapType)other;
            return Objects.equals(otherMap.keyType, this.keyType) && Objects.equals(otherMap.valueType, this.valueType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.keyType, this.valueType);
    }
}

