/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableMap;

public enum WhitespaceMode {
    PRESERVE,
    JOIN;

    private final String attributeValue = Ascii.toLowerCase((String)this.name());
    private static final ImmutableMap<String, WhitespaceMode> MODES_BY_ATTRIBUTE_VALUE;

    public String getAttributeValue() {
        return this.attributeValue;
    }

    public static WhitespaceMode forAttributeValue(String attributeValue) {
        return (WhitespaceMode)((Object)MODES_BY_ATTRIBUTE_VALUE.get((Object)attributeValue));
    }

    public static Iterable<String> getAttributeValues() {
        return MODES_BY_ATTRIBUTE_VALUE.keySet();
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WhitespaceMode value : WhitespaceMode.values()) {
            builder.put((Object)value.getAttributeValue(), (Object)value);
        }
        MODES_BY_ATTRIBUTE_VALUE = builder.build();
    }
}

