/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public final class TemplateRegistry {
    private static final SoyErrorKind DUPLICATE_TEMPLATES = SoyErrorKind.of("Template/element ''{0}'' already defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME = SoyErrorKind.of("Found deltemplate {0} with the same name as a template/element at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DEFAULT_DELEGATE_TEMPLATES = SoyErrorKind.of("Delegate template ''{0}'' already has a default defined at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE = SoyErrorKind.of("Delegate template ''{0}'' already defined in delpackage {1}: {2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ImmutableMap<String, TemplateMetadata> basicTemplatesOrElementsMap;
    private final DelTemplateSelector<TemplateMetadata> delTemplateSelector;
    private final ImmutableMap<String, TemplateMetadata> allTemplates;

    public TemplateRegistry(List<TemplateMetadata> templates, ErrorReporter errorReporter) {
        LinkedHashMap<String, TemplateMetadata> allTemplatesBuilder = new LinkedHashMap<String, TemplateMetadata>();
        DelTemplateSelector.Builder<TemplateMetadata> delTemplateSelectorBuilder = new DelTemplateSelector.Builder<TemplateMetadata>();
        LinkedHashMap<String, TemplateMetadata> basicTemplatesOrElementsMap = new LinkedHashMap<String, TemplateMetadata>();
        HashMultimap delegateTemplates = HashMultimap.create();
        for (TemplateMetadata template : templates) {
            allTemplatesBuilder.put(template.getTemplateName(), template);
            switch (template.getTemplateKind()) {
                case BASIC: 
                case ELEMENT: {
                    TemplateMetadata prev = basicTemplatesOrElementsMap.put(template.getTemplateName(), template);
                    if (prev == null) break;
                    errorReporter.report(template.getSourceLocation(), DUPLICATE_TEMPLATES, template.getTemplateName(), prev.getSourceLocation());
                    break;
                }
                case DELTEMPLATE: {
                    TemplateMetadata previous;
                    String delTemplateName = template.getDelTemplateName();
                    String delPackageName = template.getDelPackageName();
                    String variant = template.getDelTemplateVariant();
                    if (delPackageName == null) {
                        previous = delTemplateSelectorBuilder.addDefault(delTemplateName, variant, template);
                        if (previous != null) {
                            errorReporter.report(template.getSourceLocation(), DUPLICATE_DEFAULT_DELEGATE_TEMPLATES, delTemplateName, previous.getSourceLocation());
                        }
                    } else {
                        previous = delTemplateSelectorBuilder.add(delTemplateName, delPackageName, variant, template);
                        if (previous != null) {
                            errorReporter.report(template.getSourceLocation(), DUPLICATE_DELEGATE_TEMPLATES_IN_DELPACKAGE, delTemplateName, delPackageName, previous.getSourceLocation());
                        }
                    }
                    delegateTemplates.put((Object)delTemplateName, (Object)template);
                }
            }
        }
        for (Map.Entry entry : delegateTemplates.entries()) {
            TemplateMetadata node = (TemplateMetadata)basicTemplatesOrElementsMap.get(entry.getKey());
            if (node == null) continue;
            errorReporter.report(((TemplateMetadata)entry.getValue()).getSourceLocation(), TEMPLATE_OR_ELEMENT_AND_DELTEMPLATE_WITH_SAME_NAME, entry.getKey(), node.getSourceLocation());
        }
        this.basicTemplatesOrElementsMap = ImmutableMap.copyOf(basicTemplatesOrElementsMap);
        this.delTemplateSelector = delTemplateSelectorBuilder.build();
        this.allTemplates = ImmutableMap.copyOf(allTemplatesBuilder);
    }

    public ImmutableSet<String> getBasicTemplateOrElementNames() {
        return this.basicTemplatesOrElementsMap.keySet();
    }

    public ImmutableList<TemplateMetadata> getTemplates(CallNode node) {
        if (node instanceof CallBasicNode) {
            String calleeName = ((CallBasicNode)node).getCalleeName();
            TemplateMetadata template = (TemplateMetadata)this.basicTemplatesOrElementsMap.get((Object)calleeName);
            return template == null ? ImmutableList.of() : ImmutableList.of((Object)template);
        }
        String calleeName = ((CallDelegateNode)node).getDelCalleeName();
        return this.delTemplateSelector.delTemplateNameToValues().get((Object)calleeName);
    }

    @Nullable
    public TemplateMetadata getBasicTemplateOrElement(String templateName) {
        return (TemplateMetadata)this.basicTemplatesOrElementsMap.get((Object)templateName);
    }

    public DelTemplateSelector<TemplateMetadata> getDelTemplateSelector() {
        return this.delTemplateSelector;
    }

    public TemplateMetadata getMetadata(TemplateNode node) {
        return (TemplateMetadata)Preconditions.checkNotNull((Object)((TemplateMetadata)this.allTemplates.get(Preconditions.checkNotNull((Object)node.getTemplateName()))), (String)"couldn't find metadata for %s in %s", (Object)node, this.allTemplates);
    }

    public ImmutableList<TemplateMetadata> getAllTemplates() {
        return this.allTemplates.values().asList();
    }

    public Optional<SanitizedContentKind> getCallContentKind(CallNode node) {
        ImmutableList<TemplateMetadata> templateNodes = this.getTemplates(node);
        if (!templateNodes.isEmpty()) {
            return Optional.of(((TemplateMetadata)templateNodes.get(0)).getContentKind());
        }
        return Optional.empty();
    }
}

