/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CallParamNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MessagePlaceholders;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;

public abstract class CallNode
extends AbstractParentCommandNode<CallParamNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<CallParamNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode,
SoyNode.MsgPlaceholderInitialNode {
    private static final String FALLBACK_BASE_PLACEHOLDER_NAME = "XXX";
    private boolean isPassingAllData;
    @Nullable
    private ExprRootNode dataExpr;
    @Nullable
    private ExprRootNode keyExpr;
    @Nullable
    private final String userSuppliedPlaceholderName;
    @Nullable
    private final String userSuppliedPlaceholderExample;
    @Nullable
    private HtmlContext htmlContext;
    private ImmutableList<SoyPrintDirective> escapingDirectives = ImmutableList.of();
    private boolean isPcData = false;

    protected CallNode(int id, SourceLocation location, String commandName, List<CommandTagAttribute> attributes, ErrorReporter reporter) {
        super(id, location, commandName);
        String phname = null;
        String phex = null;
        for (CommandTagAttribute attr : attributes) {
            String name;
            switch (name = attr.getName().identifier()) {
                case "data": {
                    ExprNode dataExpr = attr.valueAsExpr(reporter);
                    if (dataExpr instanceof GlobalNode && ((GlobalNode)dataExpr).getName().equals("all")) {
                        this.isPassingAllData = true;
                        this.dataExpr = null;
                        break;
                    }
                    this.isPassingAllData = false;
                    this.dataExpr = new ExprRootNode(dataExpr);
                    break;
                }
                case "key": {
                    ExprNode keyExpr = attr.valueAsExpr(reporter);
                    this.keyExpr = new ExprRootNode(keyExpr);
                    break;
                }
                case "phname": {
                    phname = MessagePlaceholders.validatePlaceholderName(attr.getValue(), attr.getValueLocation(), reporter);
                    break;
                }
                case "phex": {
                    phex = MessagePlaceholders.validatePlaceholderExample(attr.getValue(), attr.getValueLocation(), reporter);
                    break;
                }
            }
        }
        this.userSuppliedPlaceholderName = phname;
        this.userSuppliedPlaceholderExample = phex;
    }

    protected CallNode(CallNode orig, CopyState copyState) {
        super(orig, copyState);
        this.isPassingAllData = orig.isPassingAllData;
        this.dataExpr = orig.dataExpr != null ? orig.dataExpr.copy(copyState) : null;
        this.keyExpr = orig.keyExpr != null ? orig.keyExpr.copy(copyState) : null;
        this.userSuppliedPlaceholderName = orig.userSuppliedPlaceholderName;
        this.userSuppliedPlaceholderExample = orig.userSuppliedPlaceholderExample;
        this.escapingDirectives = orig.escapingDirectives;
        this.isPcData = orig.getIsPcData();
    }

    public HtmlContext getHtmlContext() {
        return (HtmlContext)((Object)Preconditions.checkNotNull((Object)((Object)this.htmlContext), (Object)"Cannot access HtmlContext before HtmlContextVisitor or InferenceEngine."));
    }

    public void setHtmlContext(HtmlContext value) {
        this.htmlContext = value;
    }

    public boolean isPassingData() {
        return this.isPassingAllData || this.dataExpr != null;
    }

    public boolean isPassingAllData() {
        return this.isPassingAllData;
    }

    @Nullable
    public ExprRootNode getDataExpr() {
        return this.dataExpr;
    }

    @Nullable
    public ExprRootNode getKeyExpr() {
        return this.keyExpr;
    }

    public boolean getIsPcData() {
        return this.isPcData;
    }

    public void setIsPcData(boolean isPcData) {
        this.isPcData = isPcData;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhName() {
        return this.userSuppliedPlaceholderName;
    }

    @Override
    @Nullable
    public String getUserSuppliedPhExample() {
        return this.userSuppliedPlaceholderExample;
    }

    @Override
    public String genBasePhName() {
        if (this.userSuppliedPlaceholderName != null) {
            return BaseUtils.convertToUpperUnderscore(this.userSuppliedPlaceholderName);
        }
        return FALLBACK_BASE_PLACEHOLDER_NAME;
    }

    @Override
    public Object genSamenessKey() {
        return this;
    }

    @Override
    public String getTagString() {
        return this.getTagString(this.numChildren() == 0);
    }

    @Override
    public String toSourceString() {
        return this.numChildren() == 0 ? this.getTagString() : super.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.dataExpr == null & this.keyExpr == null) {
            return ImmutableList.of();
        }
        if (this.dataExpr != null && this.keyExpr != null) {
            return ImmutableList.of((Object)this.dataExpr, (Object)this.keyExpr);
        }
        return this.dataExpr != null ? ImmutableList.of((Object)this.dataExpr) : ImmutableList.of((Object)this.keyExpr);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    public abstract SourceLocation getSourceCalleeLocation();

    public abstract Predicate<String> getParamsToRuntimeCheck(String var1);

    public ImmutableList<SoyPrintDirective> getEscapingDirectives() {
        return this.escapingDirectives;
    }

    public void setEscapingDirectives(ImmutableList<SoyPrintDirective> escapingDirectives) {
        this.escapingDirectives = escapingDirectives;
    }
}

