/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.annotations.VisibleForTesting;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.sharedpasses.render.Environment;
import java.util.Map;

public final class TestingEnvironment
extends Environment {
    private final SoyRecord params;
    private final Map<String, SoyValueProvider> locals;

    @VisibleForTesting
    public static Environment createForTest(SoyRecord params, Map<String, SoyValueProvider> locals) {
        return new TestingEnvironment(params, locals);
    }

    private TestingEnvironment(SoyRecord params, Map<String, SoyValueProvider> locals) {
        this.params = params;
        this.locals = locals;
    }

    @Override
    void bind(VarDefn var, SoyValueProvider value) {
        throw new UnsupportedOperationException();
    }

    @Override
    void bindLoopPosition(VarDefn loopVar, SoyValueProvider value, int index, boolean isLast) {
        throw new UnsupportedOperationException();
    }

    @Override
    SoyValue getVar(VarDefn var) {
        return this.getVarProvider(var).resolve();
    }

    @Override
    boolean isLast(VarDefn loopVar) {
        return this.doGetProvider(loopVar.name() + "__isLast").resolve().booleanValue();
    }

    @Override
    int getIndex(VarDefn loopVar) {
        return this.doGetProvider(loopVar.name() + "__index").resolve().integerValue();
    }

    @Override
    SoyValueProvider getVarProvider(VarDefn var) {
        return this.doGetProvider(var.name());
    }

    private SoyValueProvider doGetProvider(String name) {
        SoyValueProvider provider = this.locals.get(name);
        if (provider == null && (provider = this.params.getFieldProvider(name)) == null) {
            provider = UndefinedData.INSTANCE;
        }
        return provider;
    }
}

