/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyFutureValueProvider;
import java.io.Flushable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

final class CountingFlushableAppendable
implements Appendable,
Flushable,
SoyFutureValueProvider.FutureBlockCallback {
    private static final Logger logger = Logger.getLogger(CountingFlushableAppendable.class.getName());
    private int count;
    private final Appendable appendable;
    private final Flushable flushable;

    CountingFlushableAppendable(Appendable appendable) {
        Preconditions.checkState((boolean)(appendable instanceof Flushable));
        this.appendable = appendable;
        this.flushable = (Flushable)((Object)appendable);
    }

    CountingFlushableAppendable(Appendable appendable, Flushable flushable) {
        this.appendable = appendable;
        this.flushable = flushable;
    }

    @VisibleForTesting
    int getAppendedCountSinceLastFlush() {
        return this.count;
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        this.count += csq.length();
        return this.appendable.append(csq);
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        this.count += end - start;
        return this.appendable.append(csq, start, end);
    }

    @Override
    public Appendable append(char c) throws IOException {
        ++this.count;
        return this.appendable.append(c);
    }

    @Override
    public void flush() throws IOException {
        this.count = 0;
        this.flushable.flush();
    }

    @Override
    public void beforeBlock() {
        if (this.count > 0) {
            try {
                this.flush();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Flush from soy failed", e);
            }
        }
    }
}

