/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.opti;

import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.sharedpasses.opti.PreevalVisitor;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;

final class SimplifyExprVisitor
extends AbstractExprNodeVisitor<Void> {
    private final PreevalVisitor preevalVisitor = new PreevalVisitor(Environment.prerenderingEnvironment());

    SimplifyExprVisitor() {
    }

    @Override
    protected void visitExprRootNode(ExprRootNode node) {
        this.visit(node.getRoot());
    }

    @Override
    protected void visitListLiteralNode(ListLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitRecordLiteralNode(RecordLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitMapLiteralNode(MapLiteralNode node) {
        this.visitChildren(node);
    }

    @Override
    protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(0);
            node.getParent().replaceChild(node, replacementNode);
        }
    }

    @Override
    protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(0) : node.getChild(1);
            node.getParent().replaceChild(node, replacementNode);
        }
    }

    @Override
    protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 == null) {
            return;
        }
        ExprNode replacementNode = operand0.coerceToBoolean() ? node.getChild(1) : node.getChild(2);
        node.getParent().replaceChild(node, replacementNode);
    }

    @Override
    protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        this.visitChildren(node);
        SoyValue operand0 = SimplifyExprVisitor.getConstantOrNull(node.getChild(0));
        if (operand0 != null) {
            if (operand0 instanceof NullData) {
                node.getParent().replaceChild(node, node.getChild(1));
            } else {
                node.getParent().replaceChild(node, node.getChild(0));
            }
        } else {
            switch (node.getChild(0).getKind()) {
                case LIST_LITERAL_NODE: 
                case RECORD_LITERAL_NODE: 
                case PROTO_INIT_NODE: {
                    node.getParent().replaceChild(node, node.getChild(0));
                    break;
                }
            }
        }
    }

    @Override
    protected void visitFieldAccessNode(FieldAccessNode node) {
        this.visitChildren(node);
        ExprNode baseExpr = node.getChild(0);
        if (baseExpr instanceof RecordLiteralNode) {
            RecordLiteralNode recordLiteral = (RecordLiteralNode)baseExpr;
            for (int i = 0; i < recordLiteral.numChildren(); ++i) {
                if (!recordLiteral.getKey(i).identifier().equals(node.getFieldName())) continue;
                node.getParent().replaceChild(node, recordLiteral.getChild(i));
                return;
            }
        }
    }

    @Override
    protected void visitItemAccessNode(ItemAccessNode node) {
        this.visitChildren(node);
        ExprNode baseExpr = node.getChild(0);
        ExprNode keyExpr = node.getChild(1);
        if (baseExpr instanceof ListLiteralNode && keyExpr instanceof IntegerNode) {
            ListLiteralNode listLiteral = (ListLiteralNode)baseExpr;
            long index = ((IntegerNode)keyExpr).getValue();
            if (index > 0L && index < (long)listLiteral.numChildren()) {
                node.getParent().replaceChild(node, listLiteral.getChild((int)index));
            } else {
                node.getParent().replaceChild(node, new NullNode(node.getSourceLocation()));
            }
        } else if (baseExpr instanceof MapLiteralNode) {
            MapLiteralNode mapLiteral = (MapLiteralNode)baseExpr;
            for (int i = 0; i < mapLiteral.numChildren(); i += 2) {
                if (!ExprEquivalence.get().equivalent(keyExpr, mapLiteral.getChild(i))) continue;
                node.getParent().replaceChild(node, mapLiteral.getChild(i + 1));
                return;
            }
            node.getParent().replaceChild(node, new NullNode(node.getSourceLocation()));
        }
    }

    @Override
    protected void visitFunctionNode(FunctionNode node) {
        if (node.getSoyFunction() instanceof BuiltinFunction) {
            return;
        }
        if (node.getSoyFunction() instanceof LoggingFunction) {
            return;
        }
        this.visitExprNode(node);
    }

    @Override
    protected void visitExprNode(ExprNode node) {
        if (!(node instanceof ExprNode.ParentExprNode)) {
            return;
        }
        ExprNode.ParentExprNode nodeAsParent = (ExprNode.ParentExprNode)node;
        this.visitChildren(nodeAsParent);
        for (ExprNode child : nodeAsParent.getChildren()) {
            if (SimplifyExprVisitor.isConstant(child)) continue;
            return;
        }
        this.attemptPreeval(nodeAsParent);
    }

    private void attemptPreeval(ExprNode node) {
        ExprNode.PrimitiveNode newNode;
        SoyValue preevalResult;
        try {
            preevalResult = (SoyValue)this.preevalVisitor.exec(node);
        }
        catch (RenderException e) {
            return;
        }
        if (preevalResult instanceof PrimitiveData && (newNode = InternalValueUtils.convertPrimitiveDataToExpr((PrimitiveData)preevalResult, node.getSourceLocation())) != null) {
            node.getParent().replaceChild(node, newNode);
        }
    }

    static boolean isConstant(ExprNode expr) {
        return expr instanceof GlobalNode && ((GlobalNode)expr).isResolved() || expr instanceof ExprNode.PrimitiveNode;
    }

    static SoyValue getConstantOrNull(ExprNode expr) {
        switch (expr.getKind()) {
            case NULL_NODE: {
                return NullData.INSTANCE;
            }
            case BOOLEAN_NODE: {
                return BooleanData.forValue(((BooleanNode)expr).getValue());
            }
            case INTEGER_NODE: {
                return IntegerData.forValue(((IntegerNode)expr).getValue());
            }
            case FLOAT_NODE: {
                return FloatData.forValue(((FloatNode)expr).getValue());
            }
            case STRING_NODE: {
                return StringData.forValue(((StringNode)expr).getValue());
            }
            case GLOBAL_NODE: {
                GlobalNode global = (GlobalNode)expr;
                if (global.isResolved()) {
                    return SimplifyExprVisitor.getConstantOrNull(global.getValue());
                }
                return null;
            }
        }
        return null;
    }
}

